/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.mock.action;

import java.net.URISyntaxException;
import org.apache.http.client.utils.URIBuilder;
import org.mockserver.client.http.ApacheHttpClient;
import org.mockserver.model.Header;
import org.mockserver.model.HttpForward;
import org.mockserver.model.HttpRequest;
import org.mockserver.model.HttpResponse;
import org.mockserver.model.Parameter;
import org.mockserver.proxy.filters.Filters;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpForwardActionHandler {
    private final Filters filters;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private ApacheHttpClient apacheHttpClient = new ApacheHttpClient(true);

    public HttpForwardActionHandler(Filters filters) {
        this.filters = filters;
    }

    public HttpResponse handle(HttpForward httpForward, HttpRequest httpRequest) {
        this.updateURLAndHost(httpRequest, httpForward);
        return this.sendRequest(this.filters.applyFilters(httpRequest));
    }

    private void updateURLAndHost(HttpRequest httpRequest, HttpForward httpForward) {
        try {
            URIBuilder uriBuilder = new URIBuilder(httpRequest.getURL());
            uriBuilder.setPath(httpRequest.getPath().startsWith("/") ? httpRequest.getPath() : "/" + httpRequest.getPath());
            uriBuilder.setHost(httpForward.getHost());
            uriBuilder.setPort(httpForward.getPort().intValue());
            uriBuilder.setScheme(httpForward.getScheme().name().toLowerCase());
            for (Parameter parameter : httpRequest.getQueryStringParameters()) {
                for (String value : parameter.getValues()) {
                    uriBuilder.addParameter(parameter.getName(), value);
                }
            }
            httpRequest.withURL(uriBuilder.toString());
            httpRequest.replaceHeader(Header.header("Host", String.format("%s:%d", uriBuilder.getHost(), uriBuilder.getPort())));
        }
        catch (URISyntaxException e) {
            this.logger.warn("URISyntaxException for url " + httpRequest.getURL(), (Throwable)e);
        }
    }

    private HttpResponse sendRequest(HttpRequest httpRequest) {
        if (httpRequest != null) {
            return this.filters.applyFilters(httpRequest, this.apacheHttpClient.sendRequest(httpRequest, false));
        }
        return null;
    }
}

