/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.proxy.filters;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import org.mockserver.model.Header;
import org.mockserver.model.HttpRequest;
import org.mockserver.proxy.filters.ProxyRequestFilter;

public class HopByHopHeaderFilter
implements ProxyRequestFilter {
    @Override
    public HttpRequest onRequest(HttpRequest httpRequest) {
        if (httpRequest != null) {
            List<String> headersToRemove = Arrays.asList("proxy-connection", "connection", "keep-alive", "transfer-encoding", "te", "trailer", "proxy-authorization", "proxy-authenticate", "upgrade");
            ArrayList<Header> filteredHeaders = new ArrayList<Header>();
            for (Header header : httpRequest.getHeaders()) {
                if (headersToRemove.contains(header.getName().toLowerCase(Locale.ENGLISH))) continue;
                filteredHeaders.add(header);
            }
            return httpRequest.withHeaders(filteredHeaders);
        }
        return null;
    }
}

