/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.proxy.filters;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.mockserver.client.serialization.ExpectationSerializer;
import org.mockserver.collections.CircularMultiMap;
import org.mockserver.matchers.HttpRequestMatcher;
import org.mockserver.matchers.MatcherBuilder;
import org.mockserver.matchers.Times;
import org.mockserver.mock.Expectation;
import org.mockserver.model.HttpRequest;
import org.mockserver.model.HttpResponse;
import org.mockserver.proxy.filters.ProxyResponseFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogFilter
implements ProxyResponseFilter {
    private final CircularMultiMap<HttpRequest, HttpResponse> requestResponseLog = new CircularMultiMap(100, 100);
    private final MatcherBuilder matcherBuilder = new MatcherBuilder();
    private Logger requestLogger = LoggerFactory.getLogger((String)"REQUEST");

    @Override
    public synchronized HttpResponse onResponse(HttpRequest httpRequest, HttpResponse httpResponse) {
        if (httpRequest != null && httpResponse != null) {
            this.requestResponseLog.put(httpRequest, httpResponse);
        }
        return httpResponse;
    }

    public synchronized List<HttpResponse> httpResponses(HttpRequest httpRequest) {
        ArrayList<HttpResponse> httpResponses = new ArrayList<HttpResponse>();
        HttpRequestMatcher httpRequestMatcher = this.matcherBuilder.transformsToMatcher(httpRequest);
        for (HttpRequest loggedHttpRequest : this.requestResponseLog.keySet()) {
            if (!httpRequestMatcher.matches(loggedHttpRequest)) continue;
            httpResponses.addAll(this.requestResponseLog.getAll(loggedHttpRequest));
        }
        return httpResponses;
    }

    public synchronized List<HttpRequest> httpRequests(HttpRequest httpRequest) {
        ArrayList<HttpRequest> httpRequests = new ArrayList<HttpRequest>();
        HttpRequestMatcher httpRequestMatcher = this.matcherBuilder.transformsToMatcher(httpRequest);
        for (HttpRequest loggedHttpRequest : this.requestResponseLog.keySet()) {
            if (!httpRequestMatcher.matches(loggedHttpRequest)) continue;
            httpRequests.add(loggedHttpRequest);
        }
        return httpRequests;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void reset() {
        CircularMultiMap<HttpRequest, HttpResponse> circularMultiMap = this.requestResponseLog;
        synchronized (circularMultiMap) {
            this.requestResponseLog.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void clear(HttpRequest httpRequest) {
        if (httpRequest != null) {
            HttpRequestMatcher httpRequestMatcher = this.matcherBuilder.transformsToMatcher(httpRequest);
            for (HttpRequest key : new LinkedHashSet<HttpRequest>(this.requestResponseLog.keySet())) {
                if (!httpRequestMatcher.matches(key)) continue;
                CircularMultiMap<HttpRequest, HttpResponse> circularMultiMap = this.requestResponseLog;
                synchronized (circularMultiMap) {
                    this.requestResponseLog.removeAll(key);
                }
            }
        } else {
            this.reset();
        }
    }

    public synchronized void dumpToLog(HttpRequest httpRequest, boolean asJava) {
        ExpectationSerializer expectationSerializer = new ExpectationSerializer();
        if (httpRequest != null) {
            HttpRequestMatcher httpRequestMatcher = this.matcherBuilder.transformsToMatcher(httpRequest);
            for (Map.Entry<HttpRequest, HttpResponse> entry : this.requestResponseLog.entrySet()) {
                if (!httpRequestMatcher.matches(entry.getKey())) continue;
                if (asJava) {
                    this.requestLogger.warn(expectationSerializer.serializeAsJava(new Expectation(entry.getKey(), Times.once()).thenRespond(entry.getValue())));
                    continue;
                }
                this.requestLogger.warn(expectationSerializer.serialize(new Expectation(entry.getKey(), Times.once()).thenRespond(entry.getValue())));
            }
        } else {
            for (Map.Entry<HttpRequest, HttpResponse> entry : this.requestResponseLog.entrySet()) {
                if (asJava) {
                    this.requestLogger.warn(expectationSerializer.serializeAsJava(new Expectation(entry.getKey(), Times.once()).thenRespond(entry.getValue())));
                    continue;
                }
                this.requestLogger.warn(expectationSerializer.serialize(new Expectation(entry.getKey(), Times.once()).thenRespond(entry.getValue())));
            }
        }
    }

    public synchronized Expectation[] retrieve(HttpRequest httpRequest) {
        ArrayList<Expectation> expectations = new ArrayList<Expectation>();
        if (httpRequest != null) {
            HttpRequestMatcher httpRequestMatcher = this.matcherBuilder.transformsToMatcher(httpRequest);
            for (HttpRequest key : this.requestResponseLog.keySet()) {
                for (HttpResponse value : this.requestResponseLog.getAll(key)) {
                    if (!httpRequestMatcher.matches(key)) continue;
                    expectations.add(new Expectation(key, Times.once()).thenRespond(value));
                }
            }
        } else {
            for (HttpRequest key : this.requestResponseLog.keySet()) {
                for (HttpResponse value : this.requestResponseLog.getAll(key)) {
                    expectations.add(new Expectation(key, Times.once()).thenRespond(value));
                }
            }
        }
        return expectations.toArray(new Expectation[expectations.size()]);
    }
}

