/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.client.netty.codec;

import com.google.common.base.Strings;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToMessageEncoder;
import io.netty.handler.codec.http.ClientCookieEncoder;
import io.netty.handler.codec.http.DefaultCookie;
import io.netty.handler.codec.http.DefaultFullHttpRequest;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.QueryStringEncoder;
import java.util.ArrayList;
import java.util.List;
import org.mockserver.model.Cookie;
import org.mockserver.model.Header;
import org.mockserver.model.HttpRequest;
import org.mockserver.model.OutboundHttpRequest;
import org.mockserver.model.Parameter;

public class MockServerRequestEncoder
extends MessageToMessageEncoder<OutboundHttpRequest> {
    protected void encode(ChannelHandlerContext ctx, OutboundHttpRequest httpRequest, List<Object> out) {
        HttpMethod httpMethod = HttpMethod.valueOf((String)httpRequest.getMethod("GET"));
        DefaultFullHttpRequest request = new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, httpMethod, this.getURI(httpRequest), this.getBody(httpRequest));
        this.setHeader(httpRequest, (FullHttpRequest)request);
        this.setCookies(httpRequest, (FullHttpRequest)request);
        out.add(request);
    }

    public String getURI(OutboundHttpRequest httpRequest) {
        String contextPath = httpRequest.getContextPath();
        if (!Strings.isNullOrEmpty((String)contextPath)) {
            if (contextPath.endsWith("/")) {
                contextPath = contextPath.substring(0, contextPath.lastIndexOf("/"));
            }
            if (!contextPath.startsWith("/")) {
                contextPath = "/" + contextPath;
            }
        }
        QueryStringEncoder queryStringEncoder = new QueryStringEncoder(contextPath + httpRequest.getPath());
        for (Parameter parameter : httpRequest.getQueryStringParameters()) {
            for (String value : parameter.getValues()) {
                queryStringEncoder.addParam(parameter.getName(), value);
            }
        }
        return queryStringEncoder.toString();
    }

    private ByteBuf getBody(HttpRequest httpRequest) {
        ByteBuf content = Unpooled.buffer((int)0);
        if (httpRequest.getBody() != null) {
            content = Unpooled.copiedBuffer((byte[])httpRequest.getBodyAsRawBytes());
        }
        return content;
    }

    private void setCookies(HttpRequest httpRequest, FullHttpRequest request) {
        ArrayList<DefaultCookie> cookies = new ArrayList<DefaultCookie>();
        for (Cookie cookie : httpRequest.getCookies()) {
            if (!cookie.getValues().isEmpty()) {
                for (String value : cookie.getValues()) {
                    cookies.add(new DefaultCookie(cookie.getName(), value));
                }
                continue;
            }
            cookies.add(new DefaultCookie(cookie.getName(), ""));
        }
        if (cookies.size() > 0) {
            request.headers().set("Cookie", (Object)ClientCookieEncoder.encode(cookies));
        }
    }

    private void setHeader(OutboundHttpRequest httpRequest, FullHttpRequest request) {
        for (Header header : httpRequest.getHeaders()) {
            String headerName = header.getName();
            if (headerName.equalsIgnoreCase("Content-Length") || headerName.equalsIgnoreCase("Transfer-Encoding") || headerName.equalsIgnoreCase("Host") || headerName.equalsIgnoreCase("Accept-Encoding")) continue;
            if (!header.getValues().isEmpty()) {
                for (String headerValue : header.getValues()) {
                    request.headers().add(headerName, (Object)headerValue);
                }
                continue;
            }
            request.headers().add(headerName, (Object)"");
        }
        String port = "";
        if (!httpRequest.isSecure() && httpRequest.getPort() != 80 || httpRequest.isSecure() && httpRequest.getPort() != 443) {
            port = ":" + httpRequest.getPort();
        }
        request.headers().add("Host", (Object)(httpRequest.getHost() + port));
        request.headers().set("Accept-Encoding", (Object)"gzip,deflate");
        request.headers().set("Content-Length", (Object)request.content().readableBytes());
        if (HttpHeaders.isKeepAlive((HttpMessage)request)) {
            request.headers().set("Connection", (Object)"keep-alive");
        } else {
            request.headers().set("Connection", (Object)"close");
        }
    }
}

