/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.collections;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import org.mockserver.matchers.RegexStringMatcher;

class CaseInsensitiveRegexHashMap<V>
extends LinkedHashMap<String, V>
implements Map<String, V> {
    static final long serialVersionUID = 1530623482381786485L;

    CaseInsensitiveRegexHashMap() {
    }

    @Override
    public synchronized boolean containsKey(Object key) {
        if (key instanceof String) {
            if (super.containsKey(key)) {
                return true;
            }
            for (String keyToCompare : this.keySet()) {
                if (!RegexStringMatcher.matches((String)key, keyToCompare, true)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public synchronized V get(Object key) {
        if (key instanceof String) {
            if (super.get(key) != null) {
                return super.get(key);
            }
            for (String keyToCompare : this.keySet()) {
                if (!RegexStringMatcher.matches((String)key, keyToCompare, true)) continue;
                return super.get(keyToCompare);
            }
        }
        return null;
    }

    public synchronized Collection<V> getAll(Object key) {
        ArrayList values = new ArrayList();
        if (key instanceof String) {
            for (String keyToCompare : this.keySet()) {
                if (!RegexStringMatcher.matches((String)key, keyToCompare, true)) continue;
                values.add(super.get(keyToCompare));
            }
        }
        return values;
    }

    @Override
    public synchronized V remove(Object key) {
        if (key instanceof String) {
            if (super.get(key) != null) {
                return super.remove(key);
            }
            for (String keyToCompare : this.keySet()) {
                if (!RegexStringMatcher.matches((String)key, keyToCompare, true)) continue;
                return super.remove(keyToCompare);
            }
        }
        return null;
    }
}

