/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.matchers;

import io.netty.handler.codec.http.QueryStringDecoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.mockserver.matchers.BodyMatcher;
import org.mockserver.matchers.MapMatcher;
import org.mockserver.matchers.Matcher;
import org.mockserver.model.KeyToMultiValue;
import org.mockserver.model.Parameter;

public class ParameterStringMatcher
extends BodyMatcher<String>
implements Matcher<String> {
    private final MapMatcher matcher;

    public ParameterStringMatcher(List<Parameter> parameters) {
        this.matcher = new MapMatcher(KeyToMultiValue.toMultiMap(parameters));
    }

    @Override
    public boolean matches(String matched) {
        boolean result = false;
        if (this.matcher.matches(this.parseString(matched))) {
            result = true;
        }
        if (!result) {
            this.logger.trace("Failed to match [{}] with [{}]", (Object)matched, (Object)this.matcher);
        }
        return result;
    }

    private List<KeyToMultiValue> parseString(String matched) {
        HashMap<String, Parameter> mappedParameters = new HashMap<String, Parameter>();
        Map parameters = new QueryStringDecoder("?" + matched).parameters();
        for (String name : parameters.keySet()) {
            for (String value : (List)parameters.get(name)) {
                if (mappedParameters.containsKey(name)) {
                    ((Parameter)mappedParameters.get(name)).addValue(value);
                    continue;
                }
                mappedParameters.put(name, new Parameter(name, value));
            }
        }
        return new ArrayList<KeyToMultiValue>(mappedParameters.values());
    }
}

