/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.mockserver.model.Action;
import org.mockserver.model.BinaryBody;
import org.mockserver.model.Body;
import org.mockserver.model.Cookie;
import org.mockserver.model.Delay;
import org.mockserver.model.Header;
import org.mockserver.model.StringBody;

public class HttpResponse
extends Action {
    private Integer statusCode = 200;
    private Body body = new StringBody("", Body.Type.STRING);
    private Map<String, Header> headers = new LinkedHashMap<String, Header>();
    private Map<String, Cookie> cookies = new LinkedHashMap<String, Cookie>();
    private Delay delay;

    public static HttpResponse response() {
        return new HttpResponse();
    }

    public static HttpResponse response(String body) {
        return new HttpResponse().withBody(body);
    }

    public static HttpResponse notFoundResponse() {
        return new HttpResponse().withStatusCode(404);
    }

    public HttpResponse withStatusCode(Integer statusCode) {
        this.statusCode = statusCode;
        return this;
    }

    public Integer getStatusCode() {
        return this.statusCode;
    }

    public HttpResponse withBody(String body) {
        if (body != null) {
            this.body = new StringBody(body, Body.Type.STRING);
        }
        return this;
    }

    public HttpResponse withBody(byte[] body) {
        this.body = new BinaryBody(body);
        return this;
    }

    public HttpResponse withBody(Body body) {
        this.body = body;
        return this;
    }

    public Body getBody() {
        return this.body;
    }

    @JsonIgnore
    public String getBodyAsString() {
        if (this.body != null) {
            return this.body.toString();
        }
        return null;
    }

    public HttpResponse withHeaders(List<Header> headers) {
        this.headers.clear();
        for (Header header : headers) {
            this.withHeader(header);
        }
        return this;
    }

    public HttpResponse withHeaders(Header ... headers) {
        if (headers != null) {
            this.withHeaders(Arrays.asList(headers));
        }
        return this;
    }

    public HttpResponse withHeader(Header header) {
        if (this.headers.containsKey(header.getName())) {
            this.headers.get(header.getName()).addValues(header.getValues());
        } else {
            this.headers.put(header.getName(), header);
        }
        return this;
    }

    public List<Header> getHeaders() {
        return new ArrayList<Header>(this.headers.values());
    }

    public HttpResponse withCookies(List<Cookie> cookies) {
        this.cookies.clear();
        for (Cookie cookie : cookies) {
            this.withCookie(cookie);
        }
        return this;
    }

    public HttpResponse withCookies(Cookie ... cookies) {
        if (cookies != null) {
            this.withCookies(Arrays.asList(cookies));
        }
        return this;
    }

    public HttpResponse withCookie(Cookie cookie) {
        if (this.cookies.containsKey(cookie.getName())) {
            this.cookies.get(cookie.getName()).addValues(cookie.getValues());
        } else {
            this.cookies.put(cookie.getName(), cookie);
        }
        return this;
    }

    public List<Cookie> getCookies() {
        return new ArrayList<Cookie>(this.cookies.values());
    }

    public HttpResponse withDelay(Delay delay) {
        this.delay = delay;
        return this;
    }

    public Delay getDelay() {
        return this.delay;
    }

    @JsonIgnore
    public HttpResponse applyDelay() {
        if (this.delay != null) {
            this.delay.applyDelay();
        }
        return this;
    }

    @Override
    @JsonIgnore
    public Action.Type getType() {
        return Action.Type.RESPONSE;
    }
}

