/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.mockserver.collections.CaseInsensitiveRegexMultiMap;
import org.mockserver.model.ObjectWithReflectiveEqualsHashCodeToString;

public class KeyToMultiValue
extends ObjectWithReflectiveEqualsHashCodeToString {
    private final String name;
    private final List<String> values;

    public KeyToMultiValue(String name, String ... values) {
        this(name, Arrays.asList(values));
    }

    public KeyToMultiValue(String name, Collection<String> values) {
        this.name = name;
        this.values = values != null ? new ArrayList<String>(values) : new ArrayList<String>();
    }

    public static CaseInsensitiveRegexMultiMap toMultiMap(List<? extends KeyToMultiValue> keyToMultiValues) {
        CaseInsensitiveRegexMultiMap caseInsensitiveRegexMultiMap = new CaseInsensitiveRegexMultiMap();
        if (keyToMultiValues != null) {
            for (KeyToMultiValue keyToMultiValue : keyToMultiValues) {
                for (String value : keyToMultiValue.getValues()) {
                    caseInsensitiveRegexMultiMap.put(keyToMultiValue.getName(), value);
                }
            }
        }
        return caseInsensitiveRegexMultiMap;
    }

    public static CaseInsensitiveRegexMultiMap toMultiMap(KeyToMultiValue ... keyToMultiValues) {
        return KeyToMultiValue.toMultiMap(Arrays.asList(keyToMultiValues));
    }

    public String getName() {
        return this.name;
    }

    public List<String> getValues() {
        return this.values;
    }

    public void addValue(String value) {
        if (this.values != null && !this.values.contains(value)) {
            this.values.add(value);
        }
    }

    public void addValues(List<String> values) {
        if (this.values != null) {
            for (String value : values) {
                if (this.values.contains(value)) continue;
                this.values.add(value);
            }
        }
    }
}

