/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.client.netty;

import io.netty.bootstrap.Bootstrap;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.IOException;
import java.net.ConnectException;
import java.net.SocketAddress;
import java.net.UnknownHostException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.mockserver.client.netty.HttpClientInitializer;
import org.mockserver.client.netty.SocketCommunicationException;
import org.mockserver.client.netty.SocketConnectionException;
import org.mockserver.configuration.ConfigurationProperties;
import org.mockserver.model.HttpResponse;
import org.mockserver.model.OutboundHttpRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NettyHttpClient {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    public HttpResponse sendRequest(OutboundHttpRequest httpRequest) throws SocketConnectionException {
        return this.sendRequest(httpRequest, true);
    }

    private HttpResponse sendRequest(final OutboundHttpRequest httpRequest, boolean retry) throws SocketConnectionException {
        this.logger.debug("Sending request: {}", (Object)httpRequest);
        NioEventLoopGroup group = new NioEventLoopGroup();
        try {
            final HttpClientInitializer channelInitializer = new HttpClientInitializer(httpRequest.isSecure());
            ((Bootstrap)((Bootstrap)((Bootstrap)new Bootstrap().group((EventLoopGroup)group)).channel(NioSocketChannel.class)).handler((ChannelHandler)channelInitializer)).connect((SocketAddress)httpRequest.getDestination()).addListener((GenericFutureListener)new ChannelFutureListener(){

                public void operationComplete(ChannelFuture future) throws Exception {
                    if (future.isSuccess()) {
                        future.channel().writeAndFlush((Object)httpRequest);
                    } else {
                        channelInitializer.getResponseFuture().setException(future.cause());
                    }
                }
            });
            HttpResponse httpResponse = (HttpResponse)channelInitializer.getResponseFuture().get(ConfigurationProperties.maxSocketTimeout(), TimeUnit.MILLISECONDS);
            this.logger.debug("Received response: {}", (Object)httpResponse);
            group.shutdownGracefully(0L, 1L, TimeUnit.MILLISECONDS);
            HttpResponse httpResponse2 = httpResponse;
            return httpResponse2;
        }
        catch (TimeoutException e) {
            throw new SocketCommunicationException("Response was not received after " + ConfigurationProperties.maxSocketTimeout() + " milliseconds, to make the proxy wait longer please use \"mockserver.maxSocketTimeout\" system property or ConfigurationProperties.maxSocketTimeout(long milliseconds)", e.getCause());
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof ConnectException) {
                throw new SocketConnectionException("Unable to connect to socket " + httpRequest.getDestination(), e.getCause());
            }
            if (e.getCause() instanceof UnknownHostException) {
                throw new SocketConnectionException("Unable to resolve host " + httpRequest.getDestination(), e.getCause());
            }
            if (e.getCause() instanceof IOException) {
                if (retry) {
                    HttpResponse httpResponse = this.sendRequest((OutboundHttpRequest)httpRequest.setSecure(!httpRequest.isSecure()), false);
                    return httpResponse;
                }
                throw new SocketCommunicationException("Error while communicating to " + httpRequest.getDestination(), e.getCause());
            }
            throw new RuntimeException("Exception while sending request", e);
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Exception while sending request", e);
        }
        finally {
            group.shutdownGracefully(0L, 1L, TimeUnit.MILLISECONDS);
        }
    }
}

