/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.client.serialization;

import com.fasterxml.jackson.databind.ObjectMapper;
import org.mockserver.client.serialization.ObjectMapperFactory;
import org.mockserver.client.serialization.model.VerificationDTO;
import org.mockserver.verify.Verification;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VerificationSerializer {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private ObjectMapper objectMapper = ObjectMapperFactory.createObjectMapper();

    public String serialize(Verification verification) {
        try {
            return this.objectMapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)new VerificationDTO(verification));
        }
        catch (Exception e) {
            this.logger.error("Exception while serializing verification to JSON with value " + verification, (Throwable)e);
            throw new RuntimeException("Exception while serializing verification to JSON with value " + verification, e);
        }
    }

    public Verification deserialize(String jsonVerification) {
        Verification verification = null;
        if (jsonVerification != null && !jsonVerification.isEmpty()) {
            try {
                VerificationDTO verificationDTO = (VerificationDTO)this.objectMapper.readValue(jsonVerification, VerificationDTO.class);
                if (verificationDTO != null) {
                    verification = verificationDTO.buildObject();
                }
            }
            catch (Exception e) {
                this.logger.info("Exception while parsing response [" + jsonVerification + "] for verification", (Throwable)e);
                throw new RuntimeException("Exception while parsing response [" + jsonVerification + "] for verification", e);
            }
        }
        return verification;
    }
}

