/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.client.serialization.java;

import com.google.common.base.Strings;
import java.util.Arrays;
import java.util.List;
import org.mockserver.client.serialization.java.MultiValueToJavaSerializer;
import org.mockserver.client.serialization.java.NottableStringToJavaSerializer;
import org.mockserver.model.NottableString;
import org.mockserver.model.Parameter;

public class ParameterToJavaSerializer
implements MultiValueToJavaSerializer<Parameter> {
    @Override
    public String serializeAsJava(int numberOfSpacesToIndent, Parameter parameter) {
        StringBuilder output = new StringBuilder();
        output.append(System.getProperty("line.separator")).append(Strings.padStart((String)"", (int)numberOfSpacesToIndent, (char)' '));
        output.append("new Parameter(").append(NottableStringToJavaSerializer.serializeNottableString(parameter.getName()));
        for (NottableString value : parameter.getValues()) {
            output.append(", ").append(NottableStringToJavaSerializer.serializeNottableString(value));
        }
        output.append(")");
        return output.toString();
    }

    @Override
    public String serializeAsJava(int numberOfSpacesToIndent, List<Parameter> parameters) {
        StringBuilder output = new StringBuilder();
        for (int i = 0; i < parameters.size(); ++i) {
            output.append(this.serializeAsJava(numberOfSpacesToIndent, parameters.get(i)));
            if (i >= parameters.size() - 1) continue;
            output.append(",");
        }
        return output.toString();
    }

    @Override
    public String serializeAsJava(int numberOfSpacesToIndent, Parameter ... object) {
        return this.serializeAsJava(numberOfSpacesToIndent, Arrays.asList(object));
    }
}

