/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.configuration;

import com.google.common.base.Joiner;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.security.KeyStore;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Properties;
import java.util.TreeSet;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.IOUtils;
import org.mockserver.socket.SSLFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigurationProperties {
    static final long DEFAULT_MAX_TIMEOUT = 120L;
    static final Logger logger = LoggerFactory.getLogger(ConfigurationProperties.class);
    static final Properties PROPERTIES = ConfigurationProperties.readPropertyFile();

    public static String propertyFile() {
        return System.getProperty("mockserver.propertyFile", "mockserver.properties");
    }

    public static long maxSocketTimeout() {
        return ConfigurationProperties.readLongProperty("mockserver.maxSocketTimeout", TimeUnit.SECONDS.toMillis(120L));
    }

    public static void maxSocketTimeout(long milliseconds) {
        System.setProperty("mockserver.maxSocketTimeout", "" + milliseconds);
    }

    public static String javaKeyStoreFilePath() {
        return ConfigurationProperties.readPropertyHierarchically("mockserver.javaKeyStoreFilePath", SSLFactory.defaultKeyStoreFileName());
    }

    public static void javaKeyStoreFilePath(String keyStoreFilePath) {
        System.setProperty("mockserver.javaKeyStoreFilePath", keyStoreFilePath);
        ConfigurationProperties.rebuildKeyStore(true);
    }

    public static String javaKeyStorePassword() {
        return ConfigurationProperties.readPropertyHierarchically("mockserver.javaKeyStorePassword", "changeit");
    }

    public static void javaKeyStorePassword(String keyStorePassword) {
        System.setProperty("mockserver.javaKeyStorePassword", keyStorePassword);
        ConfigurationProperties.rebuildKeyStore(true);
    }

    public static String javaKeyStoreType() {
        return ConfigurationProperties.readPropertyHierarchically("mockserver.javaKeyStoreType", KeyStore.getDefaultType());
    }

    public static void javaKeyStoreType(String keyStoreType) {
        System.setProperty("mockserver.javaKeyStoreType", keyStoreType);
        ConfigurationProperties.rebuildKeyStore(true);
    }

    public static boolean deleteGeneratedKeyStoreOnExit() {
        return Boolean.parseBoolean(ConfigurationProperties.readPropertyHierarchically("mockserver.deleteGeneratedKeyStoreOnExit", "true"));
    }

    public static void deleteGeneratedKeyStoreOnExit(boolean deleteGeneratedKeyStoreOnExit) {
        System.setProperty("mockserver.deleteGeneratedKeyStoreOnExit", "" + deleteGeneratedKeyStoreOnExit);
        ConfigurationProperties.rebuildKeyStore(true);
    }

    public static String sslCertificateDomainName() {
        return ConfigurationProperties.readPropertyHierarchically("mockserver.sslCertificateDomainName", "localhost");
    }

    public static void sslCertificateDomainName(String domainName) {
        System.setProperty("mockserver.sslCertificateDomainName", domainName);
        ConfigurationProperties.rebuildKeyStore(true);
    }

    public static String[] sslSubjectAlternativeNameDomains() {
        String sslSubjectAlternativeNameDomains = ConfigurationProperties.readPropertyHierarchically("mockserver.sslSubjectAlternativeNameDomains", "localhost");
        if (sslSubjectAlternativeNameDomains.isEmpty()) {
            return new String[0];
        }
        return sslSubjectAlternativeNameDomains.split(",");
    }

    public static void addSslSubjectAlternativeNameDomains(String ... newSubjectAlternativeNameDomains) {
        boolean subjectAlternativeDomainsModified = false;
        TreeSet<String> allSubjectAlternativeDomains = new TreeSet<String>();
        Collections.addAll(allSubjectAlternativeDomains, ConfigurationProperties.sslSubjectAlternativeNameDomains());
        for (String subjectAlternativeDomain : newSubjectAlternativeNameDomains) {
            if (!allSubjectAlternativeDomains.add(subjectAlternativeDomain)) continue;
            subjectAlternativeDomainsModified = true;
        }
        if (subjectAlternativeDomainsModified) {
            System.setProperty("mockserver.sslSubjectAlternativeNameDomains", Joiner.on((String)",").join(allSubjectAlternativeDomains));
            ConfigurationProperties.rebuildKeyStore(true);
        }
    }

    public static String[] sslSubjectAlternativeNameIps() {
        String sslSubjectAlternativeNameIps = ConfigurationProperties.readPropertyHierarchically("mockserver.sslSubjectAlternativeNameIps", "127.0.0.1,0.0.0.0");
        if (sslSubjectAlternativeNameIps.isEmpty()) {
            return new String[0];
        }
        return sslSubjectAlternativeNameIps.split(",");
    }

    public static void addSslSubjectAlternativeNameIps(String ... newSubjectAlternativeNameIps) {
        boolean subjectAlternativeIpsModified = false;
        TreeSet<String> allSubjectAlternativeIps = new TreeSet<String>();
        Collections.addAll(allSubjectAlternativeIps, ConfigurationProperties.sslSubjectAlternativeNameIps());
        for (String subjectAlternativeDomain : newSubjectAlternativeNameIps) {
            if (!allSubjectAlternativeIps.add(subjectAlternativeDomain)) continue;
            subjectAlternativeIpsModified = true;
        }
        if (subjectAlternativeIpsModified) {
            System.setProperty("mockserver.sslSubjectAlternativeNameIps", Joiner.on((String)",").join(allSubjectAlternativeIps));
            ConfigurationProperties.rebuildKeyStore(true);
        }
    }

    public static boolean rebuildKeyStore() {
        return Boolean.parseBoolean(System.getProperty("mockserver.rebuildKeyStore", "false"));
    }

    public static void rebuildKeyStore(boolean rebuildKeyStore) {
        System.setProperty("mockserver.rebuildKeyStore", Boolean.toString(rebuildKeyStore));
    }

    public static int mockServerPort() {
        return ConfigurationProperties.readIntegerProperty("mockserver.mockServerPort", -1);
    }

    public static void mockServerPort(int port) {
        System.setProperty("mockserver.mockServerPort", "" + port);
    }

    public static int proxyPort() {
        return ConfigurationProperties.readIntegerProperty("mockserver.proxyPort", -1);
    }

    public static void proxyPort(int port) {
        System.setProperty("mockserver.proxyPort", "" + port);
    }

    private static Integer readIntegerProperty(String key, int defaultValue) {
        try {
            return Integer.parseInt(ConfigurationProperties.readPropertyHierarchically(key, "" + defaultValue));
        }
        catch (NumberFormatException nfe) {
            logger.error("NumberFormatException converting " + key + " with value [" + ConfigurationProperties.readPropertyHierarchically(key, "" + defaultValue) + "]", (Throwable)nfe);
            return defaultValue;
        }
    }

    private static Long readLongProperty(String key, long defaultValue) {
        try {
            return Long.parseLong(ConfigurationProperties.readPropertyHierarchically(key, "" + defaultValue));
        }
        catch (NumberFormatException nfe) {
            logger.error("NumberFormatException converting " + key + " with value [" + ConfigurationProperties.readPropertyHierarchically(key, "" + defaultValue) + "]", (Throwable)nfe);
            return defaultValue;
        }
    }

    public static Properties readPropertyFile() {
        Properties properties = new Properties();
        InputStream inputStream = ConfigurationProperties.class.getClassLoader().getResourceAsStream(ConfigurationProperties.propertyFile());
        if (inputStream != null) {
            try {
                properties.load(inputStream);
            }
            catch (IOException e) {
                e.printStackTrace();
                logger.error("Exception loading property file [" + ConfigurationProperties.propertyFile() + "]", (Throwable)e);
            }
        } else {
            logger.debug("Property file not found on classpath using path [" + ConfigurationProperties.propertyFile() + "]");
            try {
                properties.load(new FileInputStream(ConfigurationProperties.propertyFile()));
            }
            catch (FileNotFoundException e) {
                logger.debug("Property file not found using path [" + ConfigurationProperties.propertyFile() + "]");
            }
            catch (IOException e) {
                e.printStackTrace();
                logger.error("Exception loading property file [" + ConfigurationProperties.propertyFile() + "]", (Throwable)e);
            }
        }
        if (!properties.isEmpty()) {
            IOUtils.closeQuietly((InputStream)inputStream);
            Enumeration<?> propertyNames = properties.propertyNames();
            StringBuilder propertiesLogDump = new StringBuilder();
            propertiesLogDump.append("Reading properties from property file [").append(ConfigurationProperties.propertyFile()).append("]:\n");
            while (propertyNames.hasMoreElements()) {
                String propertyName = String.valueOf(propertyNames.nextElement());
                propertiesLogDump.append("\t").append(propertyName).append(" = ").append(properties.getProperty(propertyName)).append("\n");
            }
            logger.info(propertiesLogDump.toString());
        }
        return properties;
    }

    public static String readPropertyHierarchically(String key, String defaultValue) {
        return System.getProperty(key, PROPERTIES.getProperty(key, defaultValue));
    }

    public static void overrideLogLevel(String level) {
        if (level != null) {
            if (!Arrays.asList("TRACE", "DEBUG", "INFO", "WARN", "ERROR", "OFF").contains(level)) {
                throw new IllegalArgumentException("log level \"" + level + "\" is not legel it must be one of \"TRACE\", \"DEBUG\", \"INFO\", \"WARN\", \"ERROR\", \"OFF\"");
            }
            System.setProperty("mockserver.logLevel", level);
            System.setProperty("org.slf4j.simpleLogger.defaultLogLevel", level);
            ConfigurationProperties.overrideLogLevelWithReflection(level, "org.mockserver");
            ConfigurationProperties.overrideLogLevelWithReflection(level, "org.mockserver.mockserver");
            ConfigurationProperties.overrideLogLevelWithReflection(level, "org.mockserver.proxy");
        }
    }

    private static void overrideLogLevelWithReflection(String level, String loggerName) {
        Logger rootLogger = LoggerFactory.getLogger((String)loggerName);
        try {
            Class<?> logbackLevelClass = ConfigurationProperties.class.getClassLoader().loadClass("ch.qos.logback.classic.Level");
            Method toLevelMethod = logbackLevelClass.getMethod("toLevel", String.class);
            Object levelInstance = toLevelMethod.invoke(logbackLevelClass, level);
            Method setLevelMethod = rootLogger.getClass().getMethod("setLevel", logbackLevelClass);
            setLevelMethod.invoke((Object)rootLogger, levelInstance);
        }
        catch (Exception e) {
            logger.warn("Exception updating logging level using reflection, likely cause is Logback is not on the classpath");
        }
    }
}

