/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.matchers;

import com.google.common.base.Charsets;
import java.util.ArrayList;
import java.util.List;
import org.mockserver.client.serialization.ObjectMapperFactory;
import org.mockserver.logging.LogFormatter;
import org.mockserver.matchers.BinaryMatcher;
import org.mockserver.matchers.BodyMatcher;
import org.mockserver.matchers.ExactStringMatcher;
import org.mockserver.matchers.HashMapMatcher;
import org.mockserver.matchers.JsonSchemaMatcher;
import org.mockserver.matchers.JsonStringMatcher;
import org.mockserver.matchers.Matcher;
import org.mockserver.matchers.MultiValueMapMatcher;
import org.mockserver.matchers.NotMatcher;
import org.mockserver.matchers.ParameterStringMatcher;
import org.mockserver.matchers.RegexStringMatcher;
import org.mockserver.matchers.XPathStringMatcher;
import org.mockserver.model.BinaryBody;
import org.mockserver.model.Body;
import org.mockserver.model.Cookie;
import org.mockserver.model.Header;
import org.mockserver.model.HttpRequest;
import org.mockserver.model.JsonBody;
import org.mockserver.model.JsonSchemaBody;
import org.mockserver.model.KeyAndValue;
import org.mockserver.model.KeyToMultiValue;
import org.mockserver.model.NottableString;
import org.mockserver.model.Parameter;
import org.mockserver.model.ParameterBody;
import org.mockserver.model.RegexBody;
import org.mockserver.model.StringBody;
import org.mockserver.model.XPathBody;

public class HttpRequestMatcher
extends NotMatcher<HttpRequest> {
    private LogFormatter logFormatter;
    private HttpRequest httpRequest;
    private RegexStringMatcher methodMatcher;
    private RegexStringMatcher pathMatcher;
    private MultiValueMapMatcher queryStringParameterMatcher;
    private BodyMatcher bodyMatcher;
    private MultiValueMapMatcher headerMatcher;
    private HashMapMatcher cookieMatcher;

    public HttpRequestMatcher(HttpRequest httpRequest) {
        this.logFormatter = new LogFormatter(this.logger);
        this.methodMatcher = null;
        this.pathMatcher = null;
        this.queryStringParameterMatcher = null;
        this.bodyMatcher = null;
        this.headerMatcher = null;
        this.cookieMatcher = null;
        this.httpRequest = httpRequest;
        if (httpRequest != null) {
            this.withMethod(httpRequest.getMethod());
            this.withPath(httpRequest.getPath());
            this.withQueryStringParameters(httpRequest.getQueryStringParameters());
            this.withBody(httpRequest.getBody());
            this.withHeaders(httpRequest.getHeaders());
            this.withCookies(httpRequest.getCookies());
        }
        this.addFieldsExcludedFromEqualsAndHashCode("logFormatter");
    }

    private HttpRequestMatcher withMethod(NottableString method) {
        this.methodMatcher = new RegexStringMatcher(method);
        return this;
    }

    private HttpRequestMatcher withPath(NottableString path) {
        this.pathMatcher = new RegexStringMatcher(path);
        return this;
    }

    private HttpRequestMatcher withQueryStringParameters(List<Parameter> parameters) {
        this.queryStringParameterMatcher = new MultiValueMapMatcher(KeyToMultiValue.toMultiMap(parameters));
        return this;
    }

    private HttpRequestMatcher withBody(Body body) {
        if (body != null) {
            switch (body.getType()) {
                case STRING: {
                    StringBody stringBody = (StringBody)body;
                    this.bodyMatcher = new ExactStringMatcher(NottableString.string(stringBody.getValue(), stringBody.getNot()));
                    break;
                }
                case REGEX: {
                    RegexBody regexBody = (RegexBody)body;
                    this.bodyMatcher = new RegexStringMatcher(NottableString.string(regexBody.getValue(), regexBody.getNot()));
                    break;
                }
                case PARAMETERS: {
                    ParameterBody parameterBody = (ParameterBody)body;
                    this.bodyMatcher = new ParameterStringMatcher((List<Parameter>)parameterBody.getValue());
                    break;
                }
                case XPATH: {
                    XPathBody xPathBody = (XPathBody)body;
                    this.bodyMatcher = new XPathStringMatcher(xPathBody.getValue());
                    break;
                }
                case JSON: {
                    JsonBody jsonBody = (JsonBody)body;
                    this.bodyMatcher = new JsonStringMatcher(jsonBody.getValue(), jsonBody.getMatchType());
                    break;
                }
                case JSON_SCHEMA: {
                    JsonSchemaBody jsonSchemaBody = (JsonSchemaBody)body;
                    this.bodyMatcher = new JsonSchemaMatcher(jsonSchemaBody.getValue());
                    break;
                }
                case BINARY: {
                    BinaryBody binaryBody = (BinaryBody)body;
                    this.bodyMatcher = new BinaryMatcher(binaryBody.getValue());
                }
            }
            if (body.isNot()) {
                this.bodyMatcher = HttpRequestMatcher.not(this.bodyMatcher);
            }
        }
        return this;
    }

    private HttpRequestMatcher withHeaders(Header ... headers) {
        this.headerMatcher = new MultiValueMapMatcher(KeyToMultiValue.toMultiMap(headers));
        return this;
    }

    private HttpRequestMatcher withHeaders(List<Header> headers) {
        this.headerMatcher = new MultiValueMapMatcher(KeyToMultiValue.toMultiMap(headers));
        return this;
    }

    private HttpRequestMatcher withCookies(Cookie ... cookies) {
        this.cookieMatcher = new HashMapMatcher(KeyAndValue.toHashMap(cookies));
        return this;
    }

    private HttpRequestMatcher withCookies(List<Cookie> cookies) {
        this.cookieMatcher = new HashMapMatcher(KeyAndValue.toHashMap(cookies));
        return this;
    }

    @Override
    public boolean matches(HttpRequest httpRequest) {
        return this.matches(httpRequest, false);
    }

    public boolean matches(HttpRequest httpRequest, boolean logMatchResults) {
        if (httpRequest == this.httpRequest) {
            return true;
        }
        if (this.httpRequest == null) {
            return true;
        }
        if (httpRequest != null) {
            boolean resultAfterNotOperatorsApplied;
            boolean methodMatches = this.matches(this.methodMatcher, httpRequest.getMethod());
            boolean pathMatches = this.matches(this.pathMatcher, httpRequest.getPath());
            boolean queryStringParametersMatches = this.matches(this.queryStringParameterMatcher, httpRequest.getQueryStringParameters() != null ? new ArrayList<Parameter>(httpRequest.getQueryStringParameters()) : null);
            boolean bodyMatches = this.bodyMatcher instanceof BinaryMatcher ? this.matches(this.bodyMatcher, httpRequest.getBodyAsRawBytes()) : (this.bodyMatcher instanceof ExactStringMatcher || this.bodyMatcher instanceof RegexStringMatcher ? this.matches(this.bodyMatcher, NottableString.string(httpRequest.getBody() != null ? new String(httpRequest.getBody().getRawBytes(), httpRequest.getBody().getCharset(Charsets.UTF_8)) : "")) : this.matches(this.bodyMatcher, httpRequest.getBody() != null ? new String(httpRequest.getBody().getRawBytes(), httpRequest.getBody().getCharset(Charsets.UTF_8)) : ""));
            boolean headersMatch = this.matches(this.headerMatcher, httpRequest.getHeaders() != null ? new ArrayList<Header>(httpRequest.getHeaders()) : null);
            boolean cookiesMatch = this.matches(this.cookieMatcher, httpRequest.getCookies() != null ? new ArrayList<Cookie>(httpRequest.getCookies()) : null);
            boolean result = methodMatches && pathMatches && queryStringParametersMatches && bodyMatches && headersMatch && cookiesMatch;
            boolean bl = resultAfterNotOperatorsApplied = httpRequest.isNot() == (this.httpRequest.isNot() == (this.not != result));
            if (logMatchResults && this.logger.isInfoEnabled()) {
                if (!resultAfterNotOperatorsApplied) {
                    String because = "methodMatches = " + methodMatches + System.getProperty("line.separator") + "pathMatches = " + pathMatches + System.getProperty("line.separator") + "queryStringParametersMatch = " + queryStringParametersMatches + System.getProperty("line.separator") + "bodyMatches = " + bodyMatches + System.getProperty("line.separator") + "headersMatch = " + headersMatch + System.getProperty("line.separator") + "cookiesMatch = " + cookiesMatch + (httpRequest.isNot() ? System.getProperty("line.separator") + "request not operator is enabled" : "") + (this.httpRequest.isNot() ? System.getProperty("line.separator") + "expectation's request not operator is enabled" : "") + (this.not ? System.getProperty("line.separator") + "expectation's request matcher not operator is enabled" : "");
                    this.logFormatter.infoLog("request:{}" + System.getProperty("line.separator") + " did" + (result ? "" : " not") + " match expectation:{}" + System.getProperty("line.separator") + " because:{}", httpRequest, this, because);
                } else {
                    this.logFormatter.infoLog("request:{}" + System.getProperty("line.separator") + " matched expectation:{}", httpRequest, this);
                }
            }
            return resultAfterNotOperatorsApplied;
        }
        return false;
    }

    private <T> boolean matches(Matcher<T> matcher, T t) {
        boolean result = false;
        if (matcher == null) {
            result = true;
        } else if (matcher.matches(t)) {
            result = true;
        }
        return result;
    }

    @Override
    public String toString() {
        try {
            return ObjectMapperFactory.createObjectMapper().writerWithDefaultPrettyPrinter().writeValueAsString((Object)this.httpRequest);
        }
        catch (Exception e) {
            return super.toString();
        }
    }
}

