/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.collections;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.mockserver.collections.CaseInsensitiveNottableRegexListHashMap;
import org.mockserver.matchers.RegexStringMatcher;
import org.mockserver.model.NottableString;
import org.mockserver.model.ObjectWithReflectiveEqualsHashCodeToString;

public class CaseInsensitiveRegexMultiMap
extends ObjectWithReflectiveEqualsHashCodeToString
implements Map<NottableString, NottableString> {
    private final CaseInsensitiveNottableRegexListHashMap backingMap = new CaseInsensitiveNottableRegexListHashMap();

    public static CaseInsensitiveRegexMultiMap multiMap(String[] ... keyAndValues) {
        CaseInsensitiveRegexMultiMap multiMap = new CaseInsensitiveRegexMultiMap();
        for (String[] keyAndValue : keyAndValues) {
            for (int i = 1; i < keyAndValue.length; ++i) {
                multiMap.put(keyAndValue[0], keyAndValue[i]);
            }
        }
        return multiMap;
    }

    public static CaseInsensitiveRegexMultiMap multiMap(NottableString[] ... keyAndValues) {
        CaseInsensitiveRegexMultiMap multiMap = new CaseInsensitiveRegexMultiMap();
        for (NottableString[] keyAndValue : keyAndValues) {
            for (int i = 1; i < keyAndValue.length; ++i) {
                multiMap.put(keyAndValue[0], keyAndValue[i]);
            }
        }
        return multiMap;
    }

    public static Map.Entry<NottableString, NottableString> entry(String key, String value) {
        return new ImmutableEntry(key, value);
    }

    public boolean containsAll(CaseInsensitiveRegexMultiMap subSet) {
        if (this.size() == 0 && subSet.allKeysNotted()) {
            return true;
        }
        for (Map.Entry<NottableString, NottableString> entry : subSet.entryList()) {
            if ((entry.getKey().isNot() || entry.getValue().isNot()) && this.containsKeyValue(entry.getKey().getValue(), entry.getValue().getValue())) {
                return false;
            }
            if (this.containsKeyValue(entry.getKey(), entry.getValue())) continue;
            return false;
        }
        return true;
    }

    private boolean allKeysNotted() {
        for (NottableString key : this.keySet()) {
            if (key.isNot()) continue;
            return false;
        }
        return true;
    }

    public synchronized boolean containsKeyValue(String key, String value) {
        return this.containsKeyValue(NottableString.string(key), NottableString.string(value));
    }

    public synchronized boolean containsKeyValue(NottableString key, NottableString value) {
        boolean result = false;
        for (Map.Entry<NottableString, NottableString> matcherEntry : this.entryList()) {
            if (!RegexStringMatcher.matches(value, matcherEntry.getValue(), true) || !RegexStringMatcher.matches(key, matcherEntry.getKey(), true)) continue;
            result = true;
            break;
        }
        return result;
    }

    @Override
    public synchronized boolean containsValue(Object value) {
        if (value instanceof NottableString) {
            for (NottableString key : this.backingMap.keySet()) {
                for (List<NottableString> allKeyValues : this.backingMap.getAll(key)) {
                    for (NottableString keyValue : allKeyValues) {
                        if (!RegexStringMatcher.matches(keyValue, (NottableString)value, false)) continue;
                        return true;
                    }
                }
            }
        } else if (value instanceof String) {
            return this.containsValue(NottableString.string((String)value));
        }
        return false;
    }

    @Override
    public synchronized boolean containsKey(Object key) {
        return this.backingMap.containsKey(key);
    }

    @Override
    public synchronized NottableString get(Object key) {
        if (key instanceof String) {
            return this.get(NottableString.string((String)key));
        }
        Object values = this.backingMap.get(key);
        if (values != null && values.size() > 0) {
            return (NottableString)values.get(0);
        }
        return null;
    }

    public synchronized List<NottableString> getAll(String key) {
        return this.getAll(NottableString.string(key));
    }

    public synchronized List<NottableString> getAll(NottableString key) {
        ArrayList<NottableString> all = new ArrayList<NottableString>();
        for (List<NottableString> subList : this.backingMap.getAll(key)) {
            all.addAll(subList);
        }
        return all;
    }

    @Override
    public synchronized NottableString put(String key, String value) {
        return this.put(NottableString.string(key), NottableString.string(value));
    }

    @Override
    public synchronized NottableString put(NottableString key, NottableString value) {
        List<NottableString> list = Collections.synchronizedList(new ArrayList());
        for (Map.Entry<NottableString, NottableString> entry : this.entryList()) {
            if (!EqualsBuilder.reflectionEquals((Object)entry.getKey(), (Object)key, (String[])new String[0])) continue;
            list.add(entry.getValue());
        }
        list.add(value);
        this.backingMap.put(key, list);
        return value;
    }

    @Override
    public synchronized List<NottableString> put(String key, List<String> values) {
        return this.put(NottableString.string(key), NottableString.strings(values));
    }

    @Override
    public synchronized List<NottableString> put(NottableString key, List<NottableString> values) {
        if (this.containsKey(key)) {
            for (NottableString value : values) {
                this.put(key, value);
            }
        } else {
            this.backingMap.put(key, values);
        }
        return values;
    }

    public void putValuesForNewKeys(CaseInsensitiveRegexMultiMap multiMap) {
        for (NottableString key : multiMap.keySet()) {
            if (this.containsKey(key)) continue;
            this.backingMap.put(key, multiMap.getAll(key));
        }
    }

    @Override
    public synchronized NottableString remove(Object key) {
        if (key instanceof String) {
            return this.remove(NottableString.string((String)key));
        }
        Object values = this.backingMap.get(key);
        if (values != null && values.size() > 0) {
            NottableString removed = (NottableString)values.remove(0);
            if (values.size() == 0) {
                this.backingMap.remove(key);
            }
            return removed;
        }
        return null;
    }

    public synchronized List<NottableString> removeAll(NottableString key) {
        return this.backingMap.remove(key);
    }

    public synchronized List<NottableString> removeAll(String key) {
        return this.backingMap.remove(key);
    }

    @Override
    public synchronized void putAll(Map<? extends NottableString, ? extends NottableString> map) {
        for (Map.Entry<? extends NottableString, ? extends NottableString> entry : map.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public synchronized void clear() {
        this.backingMap.clear();
    }

    @Override
    public synchronized Set<NottableString> keySet() {
        return this.backingMap.keySet();
    }

    @Override
    public synchronized Collection<NottableString> values() {
        ArrayList<NottableString> values = new ArrayList<NottableString>();
        for (List valuesForKey : this.backingMap.values()) {
            values.addAll(valuesForKey);
        }
        return values;
    }

    @Override
    public synchronized Set<Map.Entry<NottableString, NottableString>> entrySet() {
        LinkedHashSet<Map.Entry<NottableString, NottableString>> entrySet = new LinkedHashSet<Map.Entry<NottableString, NottableString>>();
        for (Map.Entry entry : this.backingMap.entrySet()) {
            for (NottableString value : (List)entry.getValue()) {
                entrySet.add(new ImmutableEntry((NottableString)entry.getKey(), value));
            }
        }
        return entrySet;
    }

    public synchronized List<Map.Entry<NottableString, NottableString>> entryList() {
        ArrayList<Map.Entry<NottableString, NottableString>> entrySet = new ArrayList<Map.Entry<NottableString, NottableString>>();
        for (Map.Entry entry : this.backingMap.entrySet()) {
            for (NottableString value : (List)entry.getValue()) {
                entrySet.add(new ImmutableEntry((NottableString)entry.getKey(), value));
            }
        }
        return entrySet;
    }

    @Override
    public synchronized int size() {
        return this.backingMap.size();
    }

    @Override
    public synchronized boolean isEmpty() {
        return this.backingMap.isEmpty();
    }

    static class ImmutableEntry
    extends ObjectWithReflectiveEqualsHashCodeToString
    implements Map.Entry<NottableString, NottableString> {
        private final NottableString key;
        private final NottableString value;

        ImmutableEntry(String key, String value) {
            this.key = NottableString.string(key);
            this.value = NottableString.string(value);
        }

        ImmutableEntry(NottableString key, NottableString value) {
            this.key = key;
            this.value = value;
        }

        @Override
        public NottableString getKey() {
            return this.key;
        }

        @Override
        public NottableString getValue() {
            return this.value;
        }

        @Override
        public NottableString setValue(NottableString value) {
            throw new UnsupportedOperationException("ImmutableEntry is immutable");
        }
    }
}

