/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.mappers;

import com.google.common.base.Strings;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.util.CharsetUtil;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.UnsupportedCharsetException;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.mockserver.model.HttpRequest;
import org.mockserver.model.HttpResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContentTypeMapper {
    public static final Charset DEFAULT_HTTP_CHARACTER_SET = CharsetUtil.ISO_8859_1;
    private static final Logger logger = LoggerFactory.getLogger(ContentTypeMapper.class);

    public static boolean isBinary(String contentTypeHeader) {
        boolean binary = false;
        if (!Strings.isNullOrEmpty((String)contentTypeHeader)) {
            boolean utf8Body;
            String contentType = contentTypeHeader.toLowerCase();
            boolean bl = utf8Body = contentType.contains("utf-8") || contentType.contains("utf8") || contentType.contains("text") || contentType.contains("javascript") || contentType.contains("json") || contentType.contains("ecmascript") || contentType.contains("css") || contentType.contains("csv") || contentType.contains("html") || contentType.contains("xhtml") || contentType.contains("xml");
            if (!utf8Body) {
                binary = contentType.contains("ogg") || contentType.contains("audio") || contentType.contains("video") || contentType.contains("image") || contentType.contains("pdf") || contentType.contains("postscript") || contentType.contains("font") || contentType.contains("woff") || contentType.contains("model") || contentType.contains("zip") || contentType.contains("gzip") || contentType.contains("nacl") || contentType.contains("pnacl") || contentType.contains("vnd") || contentType.contains("application");
            }
        }
        return binary;
    }

    public static Charset determineCharsetForMessage(HttpMessage httpMessage) {
        return ContentTypeMapper.getCharsetFromContentTypeHeader(httpMessage.headers().get("Content-Type"));
    }

    public static Charset determineCharsetForMessage(HttpServletRequest servletRequest) {
        return ContentTypeMapper.getCharsetFromContentTypeHeader(servletRequest.getHeader("Content-Type"));
    }

    public static Charset determineCharsetForMessage(HttpResponse httpResponse) {
        return ContentTypeMapper.getCharsetFromContentTypeHeader(httpResponse.getFirstHeader("Content-Type"));
    }

    public static Charset determineCharsetForMessage(HttpRequest httpRequest) {
        return ContentTypeMapper.getCharsetFromContentTypeHeader(httpRequest.getFirstHeader("Content-Type"));
    }

    private static Charset getCharsetFromContentTypeHeader(String contentType) {
        String charsetName;
        Charset charset = DEFAULT_HTTP_CHARACTER_SET;
        if (contentType != null && !Strings.isNullOrEmpty((String)(charsetName = StringUtils.substringAfterLast((String)contentType, (String)"charset=")))) {
            try {
                charset = Charset.forName(charsetName);
            }
            catch (UnsupportedCharsetException uce) {
                logger.info("Unsupported character set {} in Content-Type header: {}.", (Object)StringUtils.substringAfterLast((String)contentType, (String)"charset61"), (Object)contentType);
            }
            catch (IllegalCharsetNameException icne) {
                logger.info("Illegal character set {} in Content-Type header: {}.", (Object)StringUtils.substringAfterLast((String)contentType, (String)"charset61"), (Object)contentType);
            }
        }
        return charset;
    }
}

