/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.mock.action;

import org.mockserver.client.netty.NettyHttpClient;
import org.mockserver.model.HttpForward;
import org.mockserver.model.HttpRequest;
import org.mockserver.model.HttpResponse;
import org.mockserver.model.OutboundHttpRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpForwardActionHandler {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private NettyHttpClient httpClient = new NettyHttpClient();

    public HttpResponse handle(HttpForward httpForward, HttpRequest httpRequest) {
        if (httpForward.getScheme().equals((Object)HttpForward.Scheme.HTTPS)) {
            httpRequest.withSecure(true);
        } else {
            httpRequest.withSecure(false);
        }
        return this.sendRequest(OutboundHttpRequest.outboundRequest(httpForward.getHost(), httpForward.getPort(), "", httpRequest));
    }

    private HttpResponse sendRequest(OutboundHttpRequest httpRequest) {
        if (httpRequest != null) {
            try {
                return this.httpClient.sendRequest(httpRequest);
            }
            catch (Exception e) {
                this.logger.error("Exception forwarding request " + httpRequest, (Throwable)e);
            }
        }
        return null;
    }
}

