/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.collections;

import com.google.common.annotations.VisibleForTesting;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.mockserver.collections.CaseInsensitiveNottableRegexListHashMap;
import org.mockserver.logging.MockServerLogger;
import org.mockserver.matchers.RegexStringMatcher;
import org.mockserver.model.NottableString;
import org.mockserver.model.ObjectWithReflectiveEqualsHashCodeToString;

public class CaseInsensitiveRegexMultiMap
extends ObjectWithReflectiveEqualsHashCodeToString
implements Map<NottableString, NottableString> {
    private final CaseInsensitiveNottableRegexListHashMap backingMap;
    private final RegexStringMatcher regexStringMatcher;

    public CaseInsensitiveRegexMultiMap(MockServerLogger mockServerLogger, boolean controlPlaneMatcher) {
        this.regexStringMatcher = new RegexStringMatcher(mockServerLogger, controlPlaneMatcher);
        this.backingMap = new CaseInsensitiveNottableRegexListHashMap(mockServerLogger, controlPlaneMatcher);
    }

    @VisibleForTesting
    public static CaseInsensitiveRegexMultiMap multiMap(boolean controlPlaneMatcher, String[] ... keyAndValues) {
        CaseInsensitiveRegexMultiMap multiMap = new CaseInsensitiveRegexMultiMap(new MockServerLogger(), controlPlaneMatcher);
        for (String[] keyAndValue : keyAndValues) {
            for (int i = 1; i < keyAndValue.length; ++i) {
                multiMap.put(keyAndValue[0], keyAndValue[i]);
            }
        }
        return multiMap;
    }

    @VisibleForTesting
    public static CaseInsensitiveRegexMultiMap multiMap(boolean controlPlaneMatcher, NottableString[] ... keyAndValues) {
        CaseInsensitiveRegexMultiMap multiMap = new CaseInsensitiveRegexMultiMap(new MockServerLogger(), controlPlaneMatcher);
        for (NottableString[] keyAndValue : keyAndValues) {
            for (int i = 1; i < keyAndValue.length; ++i) {
                multiMap.put(keyAndValue[0], keyAndValue[i]);
            }
        }
        return multiMap;
    }

    public static Map.Entry<NottableString, NottableString> entry(String key, String value) {
        return new ImmutableEntry(key, value);
    }

    public boolean containsAll(CaseInsensitiveRegexMultiMap subSet) {
        if (this.isEmpty() && subSet.allKeysNotted()) {
            return true;
        }
        for (Map.Entry<NottableString, NottableString> entry : subSet.entryList()) {
            if ((entry.getKey().isNot() || entry.getValue().isNot()) && this.containsKeyValue(entry.getKey().getValue(), entry.getValue().getValue())) {
                Map.Entry<NottableString, NottableString> matchingEntry = this.retrieveEntry(entry.getKey(), entry.getValue());
                if (matchingEntry != null) {
                    return entry.getKey().isNot() == matchingEntry.getKey().isNot() && entry.getValue().isNot() == matchingEntry.getValue().isNot();
                }
                return false;
            }
            if (this.containsKeyValue(entry.getKey(), entry.getValue())) continue;
            return false;
        }
        return true;
    }

    public boolean allKeysNotted() {
        if (!this.isEmpty()) {
            for (NottableString key : this.keySet()) {
                if (key.isNot()) continue;
                return false;
            }
        }
        return true;
    }

    public synchronized boolean containsKeyValue(String key, String value) {
        return this.containsKeyValue(NottableString.string(key), NottableString.string(value));
    }

    public synchronized boolean containsKeyValue(NottableString key, NottableString value) {
        if (!this.isEmpty()) {
            for (NottableString valueToMatch : this.getAll(key)) {
                if (!this.regexStringMatcher.matches(value, valueToMatch, true)) continue;
                return true;
            }
        }
        return false;
    }

    private synchronized Map.Entry<NottableString, NottableString> retrieveEntry(NottableString key, NottableString value) {
        if (!this.isEmpty()) {
            for (Map.Entry<NottableString, NottableString> matcherEntry : this.entryList()) {
                if (!this.regexStringMatcher.matches(value, matcherEntry.getValue(), true) || !this.regexStringMatcher.matches(key, matcherEntry.getKey(), true)) continue;
                return matcherEntry;
            }
        }
        return null;
    }

    @Override
    public synchronized boolean containsKey(Object key) {
        return this.backingMap.containsKey(key);
    }

    @Override
    public synchronized boolean containsValue(Object value) {
        if (!this.isEmpty()) {
            if (value instanceof NottableString) {
                for (NottableString key : this.backingMap.keySet()) {
                    for (List<NottableString> allKeyValues : this.backingMap.getAll(key)) {
                        for (NottableString keyValue : allKeyValues) {
                            if (!this.regexStringMatcher.matches(keyValue, (NottableString)value, false)) continue;
                            return true;
                        }
                    }
                }
            } else if (value instanceof String) {
                return this.containsValue(NottableString.string((String)value));
            }
        }
        return false;
    }

    @Override
    public synchronized NottableString get(Object key) {
        if (!this.isEmpty()) {
            if (key instanceof String) {
                return this.get(NottableString.string((String)key));
            }
            Object values = this.backingMap.get(key);
            if (values != null && values.size() > 0) {
                return (NottableString)values.get(0);
            }
            return null;
        }
        return null;
    }

    public synchronized List<NottableString> getAll(String key) {
        return this.getAll(NottableString.string(key));
    }

    public synchronized List<NottableString> getAll(NottableString key) {
        if (!this.isEmpty()) {
            ArrayList<NottableString> all = new ArrayList<NottableString>();
            for (List<NottableString> subList : this.backingMap.getAll(key)) {
                all.addAll(subList);
            }
            return all;
        }
        return Collections.emptyList();
    }

    @Override
    public synchronized NottableString put(String key, String value) {
        return this.put(NottableString.string(key), NottableString.string(value));
    }

    @Override
    public synchronized NottableString put(NottableString key, NottableString value) {
        if (key == null) {
            throw new IllegalArgumentException("key must not be null");
        }
        if (value == null) {
            throw new IllegalArgumentException("value must not be null");
        }
        List<NottableString> list = Collections.synchronizedList(new ArrayList());
        for (Map.Entry<NottableString, NottableString> entry : this.entryList()) {
            if (!EqualsBuilder.reflectionEquals((Object)entry.getKey(), (Object)key, (String[])new String[]{"key"})) continue;
            list.add(entry.getValue());
        }
        list.add(value);
        this.backingMap.put(key, list);
        return value;
    }

    @Override
    public synchronized List<NottableString> put(String key, List<String> values) {
        return this.put(NottableString.string(key), NottableString.strings(values));
    }

    @Override
    public synchronized List<NottableString> put(NottableString key, List<NottableString> values) {
        if (this.containsKey(key)) {
            for (NottableString value : values) {
                this.put(key, value);
            }
        } else {
            this.backingMap.put(key, values);
        }
        return values;
    }

    @Override
    public synchronized NottableString remove(Object key) {
        if (!this.isEmpty()) {
            if (key instanceof String) {
                return this.remove(NottableString.string((String)key));
            }
            Object values = this.backingMap.get(key);
            if (values != null && values.size() > 0) {
                NottableString removed = (NottableString)values.remove(0);
                if (values.size() == 0) {
                    this.backingMap.remove(key);
                }
                return removed;
            }
            return null;
        }
        return null;
    }

    public synchronized List<NottableString> removeAll(NottableString key) {
        return this.backingMap.remove(key);
    }

    public synchronized List<NottableString> removeAll(String key) {
        return this.backingMap.remove(key);
    }

    @Override
    public synchronized void putAll(Map<? extends NottableString, ? extends NottableString> map) {
        for (Map.Entry<? extends NottableString, ? extends NottableString> entry : map.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public synchronized void clear() {
        this.backingMap.clear();
    }

    @Override
    public synchronized Set<NottableString> keySet() {
        if (!this.isEmpty()) {
            return this.backingMap.keySet();
        }
        return Collections.emptySet();
    }

    @Override
    public synchronized Collection<NottableString> values() {
        if (!this.isEmpty()) {
            ArrayList<NottableString> values = new ArrayList<NottableString>();
            for (List valuesForKey : this.backingMap.values()) {
                values.addAll(valuesForKey);
            }
            return values;
        }
        return Collections.emptyList();
    }

    @Override
    public synchronized Set<Map.Entry<NottableString, NottableString>> entrySet() {
        if (!this.isEmpty()) {
            LinkedHashSet<Map.Entry<NottableString, NottableString>> entrySet = new LinkedHashSet<Map.Entry<NottableString, NottableString>>();
            for (Map.Entry entry : this.backingMap.entrySet()) {
                for (NottableString value : (List)entry.getValue()) {
                    entrySet.add(new ImmutableEntry((NottableString)entry.getKey(), value));
                }
            }
            return entrySet;
        }
        return Collections.emptySet();
    }

    public synchronized List<Map.Entry<NottableString, NottableString>> entryList() {
        if (!this.isEmpty()) {
            ArrayList<Map.Entry<NottableString, NottableString>> entrySet = new ArrayList<Map.Entry<NottableString, NottableString>>();
            for (Map.Entry entry : this.backingMap.entrySet()) {
                for (NottableString value : (List)entry.getValue()) {
                    entrySet.add(new ImmutableEntry((NottableString)entry.getKey(), value));
                }
            }
            return entrySet;
        }
        return Collections.emptyList();
    }

    @Override
    public synchronized int size() {
        return this.backingMap.size();
    }

    @Override
    public synchronized boolean isEmpty() {
        return this.backingMap.isEmpty();
    }

    static class ImmutableEntry
    extends ObjectWithReflectiveEqualsHashCodeToString
    implements Map.Entry<NottableString, NottableString> {
        private final NottableString key;
        private final NottableString value;

        ImmutableEntry(String key, String value) {
            this.key = NottableString.string(key);
            this.value = NottableString.string(value);
        }

        ImmutableEntry(NottableString key, NottableString value) {
            this.key = key;
            this.value = value;
        }

        @Override
        public NottableString getKey() {
            return this.key;
        }

        @Override
        public NottableString getValue() {
            return this.value;
        }

        @Override
        public NottableString setValue(NottableString value) {
            throw new UnsupportedOperationException("ImmutableEntry is immutable");
        }
    }
}

