/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.mappers;

import io.netty.buffer.ByteBuf;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.DefaultHttpContent;
import io.netty.handler.codec.http.DefaultHttpObject;
import io.netty.handler.codec.http.DefaultHttpResponse;
import io.netty.handler.codec.http.DefaultLastHttpContent;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.cookie.Cookie;
import io.netty.handler.codec.http.cookie.DefaultCookie;
import io.netty.handler.codec.http.cookie.ServerCookieEncoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.mockserver.codec.BodyDecoderEncoder;
import org.mockserver.log.model.LogEntry;
import org.mockserver.logging.MockServerLogger;
import org.mockserver.model.ConnectionOptions;
import org.mockserver.model.HttpResponse;
import org.mockserver.model.NottableString;
import org.slf4j.event.Level;

public class MockServerHttpResponseToFullHttpResponse {
    private final MockServerLogger mockServerLogger;
    private final BodyDecoderEncoder bodyDecoderEncoder;

    public MockServerHttpResponseToFullHttpResponse(MockServerLogger mockServerLogger) {
        this.mockServerLogger = mockServerLogger;
        this.bodyDecoderEncoder = new BodyDecoderEncoder(mockServerLogger);
    }

    public List<DefaultHttpObject> mapMockServerResponseToNettyResponse(HttpResponse httpResponse) {
        try {
            ConnectionOptions connectionOptions = httpResponse.getConnectionOptions();
            if (connectionOptions != null && connectionOptions.getChunkSize() != null && connectionOptions.getChunkSize() > 0) {
                ArrayList<DefaultHttpObject> httpMessages = new ArrayList<DefaultHttpObject>();
                ByteBuf body = this.getBody(httpResponse);
                DefaultHttpResponse defaultHttpResponse = new DefaultHttpResponse(HttpVersion.HTTP_1_1, this.getStatus(httpResponse));
                this.setHeaders(httpResponse, defaultHttpResponse, body);
                HttpUtil.setTransferEncodingChunked((HttpMessage)defaultHttpResponse, (boolean)true);
                this.setCookies(httpResponse, defaultHttpResponse);
                httpMessages.add((DefaultHttpObject)defaultHttpResponse);
                ByteBuf[] chunks = this.bodyDecoderEncoder.bodyToByteBuf(httpResponse.getBody(), httpResponse.getFirstHeader(HttpHeaderNames.CONTENT_TYPE.toString()), connectionOptions.getChunkSize());
                for (int i = 0; i < chunks.length - 1; ++i) {
                    DefaultHttpContent defaultHttpContent = new DefaultHttpContent(chunks[i]);
                    httpMessages.add((DefaultHttpObject)defaultHttpContent);
                }
                httpMessages.add((DefaultHttpObject)new DefaultLastHttpContent(chunks[chunks.length - 1]));
                return httpMessages;
            }
            ByteBuf body = this.getBody(httpResponse);
            DefaultFullHttpResponse defaultFullHttpResponse = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, this.getStatus(httpResponse), body);
            this.setHeaders(httpResponse, (DefaultHttpResponse)defaultFullHttpResponse, body);
            this.setCookies(httpResponse, (DefaultHttpResponse)defaultFullHttpResponse);
            return Collections.singletonList(defaultFullHttpResponse);
        }
        catch (Throwable throwable) {
            this.mockServerLogger.logEvent(new LogEntry().setType(LogEntry.LogMessageType.EXCEPTION).setLogLevel(Level.ERROR).setMessageFormat("exception encoding response{}").setArguments(httpResponse).setThrowable(throwable));
            return Collections.singletonList(new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, this.getStatus(httpResponse)));
        }
    }

    private HttpResponseStatus getStatus(HttpResponse httpResponse) {
        int statusCode;
        int n = statusCode = httpResponse.getStatusCode() != null ? httpResponse.getStatusCode() : 200;
        if (!StringUtils.isEmpty((CharSequence)httpResponse.getReasonPhrase())) {
            return new HttpResponseStatus(statusCode, httpResponse.getReasonPhrase());
        }
        return HttpResponseStatus.valueOf((int)statusCode);
    }

    private ByteBuf getBody(HttpResponse httpResponse) {
        return this.bodyDecoderEncoder.bodyToByteBuf(httpResponse.getBody(), httpResponse.getFirstHeader(HttpHeaderNames.CONTENT_TYPE.toString()));
    }

    private void setHeaders(HttpResponse httpResponse, DefaultHttpResponse response, ByteBuf body) {
        if (httpResponse.getHeaderMultimap() != null) {
            httpResponse.getHeaderMultimap().entries().forEach(entry -> response.headers().add(((NottableString)entry.getKey()).getValue(), (Object)((NottableString)entry.getValue()).getValue()));
        }
        if (StringUtils.isBlank((CharSequence)httpResponse.getFirstHeader(HttpHeaderNames.CONTENT_TYPE.toString())) && httpResponse.getBody() != null && httpResponse.getBody().getContentType() != null) {
            response.headers().set((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)httpResponse.getBody().getContentType());
        }
        ConnectionOptions connectionOptions = httpResponse.getConnectionOptions();
        if (StringUtils.isBlank((CharSequence)httpResponse.getFirstHeader(HttpHeaderNames.CONTENT_LENGTH.toString()))) {
            boolean chunkedEncoding;
            boolean overrideContentLength = connectionOptions != null && connectionOptions.getContentLengthHeaderOverride() != null;
            boolean addContentLength = connectionOptions == null || ConnectionOptions.isFalseOrNull(connectionOptions.getSuppressContentLengthHeader());
            boolean bl = chunkedEncoding = connectionOptions != null && connectionOptions.getChunkSize() != null;
            if (overrideContentLength) {
                response.headers().set((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)connectionOptions.getContentLengthHeaderOverride());
            } else if (addContentLength && !chunkedEncoding) {
                response.headers().set((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)body.readableBytes());
            }
            if (chunkedEncoding) {
                response.headers().set((CharSequence)HttpHeaderNames.TRANSFER_ENCODING, (Object)HttpHeaderValues.CHUNKED);
            }
        }
    }

    private void setCookies(HttpResponse httpResponse, DefaultHttpResponse response) {
        if (httpResponse.getCookieMap() != null) {
            for (Map.Entry<NottableString, NottableString> cookie : httpResponse.getCookieMap().entrySet()) {
                if (!httpResponse.cookieHeadeDoesNotAlreadyExists(cookie.getKey().getValue(), cookie.getValue().getValue())) continue;
                response.headers().add((CharSequence)HttpHeaderNames.SET_COOKIE, (Object)ServerCookieEncoder.LAX.encode((Cookie)new DefaultCookie(cookie.getKey().getValue(), cookie.getValue().getValue())));
            }
        }
    }
}

