/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.matchers;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Predicate;
import net.minidev.json.JSONArray;
import org.apache.commons.lang3.StringUtils;
import org.mockserver.log.model.LogEntry;
import org.mockserver.logging.MockServerLogger;
import org.mockserver.matchers.BodyMatcher;
import org.mockserver.matchers.MatchDifference;
import org.slf4j.event.Level;

public class JsonPathMatcher
extends BodyMatcher<String> {
    private static final String[] EXCLUDED_FIELDS = new String[]{"mockServerLogger", "jsonPath"};
    private final MockServerLogger mockServerLogger;
    private final String matcher;
    private JsonPath jsonPath;

    JsonPathMatcher(MockServerLogger mockServerLogger, String matcher) {
        this.mockServerLogger = mockServerLogger;
        this.matcher = matcher;
        if (StringUtils.isNotBlank((CharSequence)matcher)) {
            try {
                this.jsonPath = JsonPath.compile((String)matcher, (Predicate[])new Predicate[0]);
            }
            catch (Throwable throwable) {
                mockServerLogger.logEvent(new LogEntry().setLogLevel(Level.DEBUG).setMessageFormat("error while creating xpath expression for [" + matcher + "] assuming matcher not xpath - " + throwable.getMessage()).setArguments(throwable));
            }
        }
    }

    @Override
    public boolean matches(MatchDifference context, String matched) {
        boolean result = false;
        boolean alreadyLoggedMatchFailure = false;
        if (this.jsonPath == null) {
            this.mockServerLogger.logEvent(new LogEntry().setLogLevel(Level.DEBUG).setMatchDifference(context).setMessageFormat("json path match failed expected:{}found:{}failed because:{}").setArguments("null", matched, "json path matcher was null"));
            alreadyLoggedMatchFailure = true;
        } else if (this.matcher.equals(matched)) {
            result = true;
        } else if (matched != null) {
            try {
                result = !((JSONArray)this.jsonPath.read(matched)).isEmpty();
            }
            catch (Throwable throwable) {
                this.mockServerLogger.logEvent(new LogEntry().setLogLevel(Level.DEBUG).setMatchDifference(context).setMessageFormat("json path match failed expected:{}found:{}failed because:{}").setArguments(this.matcher, matched, throwable.getMessage()).setThrowable(throwable));
                alreadyLoggedMatchFailure = true;
            }
        }
        if (!result && !alreadyLoggedMatchFailure) {
            this.mockServerLogger.logEvent(new LogEntry().setLogLevel(Level.TRACE).setMatchDifference(context).setMessageFormat("json path match failed expected:{}found:{}failed because:{}").setArguments(this.matcher, matched, "json path did not evaluate to truthy"));
        }
        return this.not != result;
    }

    @Override
    public boolean isBlank() {
        return StringUtils.isBlank((CharSequence)this.matcher);
    }

    @Override
    @JsonIgnore
    protected String[] fieldsExcludedFromEqualsAndHashCode() {
        return EXCLUDED_FIELDS;
    }
}

