/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.matchers;

import com.fasterxml.jackson.annotation.JsonIgnore;
import org.mockserver.collections.CaseInsensitiveRegexMultiMap;
import org.mockserver.log.model.LogEntry;
import org.mockserver.logging.MockServerLogger;
import org.mockserver.matchers.MatchDifference;
import org.mockserver.matchers.NotMatcher;
import org.mockserver.model.KeysToMultiValues;
import org.slf4j.event.Level;

public class MultiValueMapMatcher
extends NotMatcher<KeysToMultiValues> {
    private static final String[] EXCLUDED_FIELDS = new String[]{"mockServerLogger"};
    private final MockServerLogger mockServerLogger;
    private final CaseInsensitiveRegexMultiMap matcher;
    private final KeysToMultiValues keysToMultiValues;
    private final boolean controlPlaneMatcher;

    MultiValueMapMatcher(MockServerLogger mockServerLogger, KeysToMultiValues keysToMultiValues, boolean controlPlaneMatcher) {
        this.mockServerLogger = mockServerLogger;
        this.keysToMultiValues = keysToMultiValues;
        this.controlPlaneMatcher = controlPlaneMatcher;
        this.matcher = keysToMultiValues != null ? keysToMultiValues.toCaseInsensitiveRegexMultiMap(mockServerLogger, controlPlaneMatcher) : null;
    }

    @Override
    public boolean matches(MatchDifference context, KeysToMultiValues values) {
        boolean result;
        if (this.matcher == null || this.matcher.isEmpty()) {
            result = true;
        } else if (values == null || values.isEmpty()) {
            result = this.matcher.allKeysNotted();
        } else if (values.toCaseInsensitiveRegexMultiMap(this.mockServerLogger, this.controlPlaneMatcher).containsAll(this.matcher)) {
            result = true;
        } else {
            this.mockServerLogger.logEvent(new LogEntry().setLogLevel(Level.DEBUG).setMatchDifference(context).setMessageFormat("multimap subset match failed expected:{}found:{}failed because:{}").setArguments(this.keysToMultiValues, values, "multimap is not a subset"));
            result = false;
        }
        return this.not != result;
    }

    @Override
    public boolean isBlank() {
        return this.matcher == null || this.matcher.isEmpty();
    }

    @Override
    @JsonIgnore
    protected String[] fieldsExcludedFromEqualsAndHashCode() {
        return EXCLUDED_FIELDS;
    }
}

