/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.mock;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.Comparator;
import java.util.concurrent.atomic.AtomicInteger;
import org.mockserver.matchers.TimeToLive;
import org.mockserver.matchers.Times;
import org.mockserver.model.Action;
import org.mockserver.model.HttpClassCallback;
import org.mockserver.model.HttpError;
import org.mockserver.model.HttpForward;
import org.mockserver.model.HttpObjectCallback;
import org.mockserver.model.HttpOverrideForwardedRequest;
import org.mockserver.model.HttpRequest;
import org.mockserver.model.HttpResponse;
import org.mockserver.model.HttpTemplate;
import org.mockserver.model.ObjectWithJsonToString;
import org.mockserver.uuid.UUIDService;

public class Expectation
extends ObjectWithJsonToString {
    private static final String[] excludedFields = new String[]{"id", "created"};
    private static final AtomicInteger EXPECTATION_COUNTER = new AtomicInteger(0);
    private static final long START_TIME = System.currentTimeMillis();
    private String id;
    @JsonIgnore
    private long created;
    private final Integer priority;
    private final HttpRequest httpRequest;
    private final Times times;
    private final TimeToLive timeToLive;
    private HttpResponse httpResponse;
    private HttpTemplate httpResponseTemplate;
    private HttpClassCallback httpResponseClassCallback;
    private HttpObjectCallback httpResponseObjectCallback;
    private HttpForward httpForward;
    private HttpTemplate httpForwardTemplate;
    private HttpClassCallback httpForwardClassCallback;
    private HttpObjectCallback httpForwardObjectCallback;
    private HttpOverrideForwardedRequest httpOverrideForwardedRequest;
    private HttpError httpError;
    public static final Comparator<Expectation> EXPECTATION_PRIORITY_COMPARATOR = Comparator.comparing(Expectation::getPriority, Comparator.nullsLast(Comparator.reverseOrder())).thenComparing(Expectation::getCreated, Comparator.nullsLast(Comparator.naturalOrder()));

    public static Expectation when(HttpRequest httpRequest) {
        return new Expectation(httpRequest);
    }

    public static Expectation when(HttpRequest httpRequest, Integer priority) {
        return new Expectation(httpRequest, Times.unlimited(), TimeToLive.unlimited(), priority);
    }

    public static Expectation when(HttpRequest httpRequest, Times times, TimeToLive timeToLive) {
        return new Expectation(httpRequest, times, timeToLive, 0);
    }

    public static Expectation when(HttpRequest httpRequest, Times times, TimeToLive timeToLive, Integer priority) {
        return new Expectation(httpRequest, times, timeToLive, priority);
    }

    public Expectation(HttpRequest httpRequest) {
        this(httpRequest, Times.unlimited(), TimeToLive.unlimited(), 0);
    }

    public Expectation(HttpRequest httpRequest, Times times, TimeToLive timeToLive, Integer priority) {
        EXPECTATION_COUNTER.compareAndSet(Integer.MAX_VALUE, 0);
        this.created = System.currentTimeMillis() - START_TIME + (long)EXPECTATION_COUNTER.incrementAndGet();
        this.httpRequest = httpRequest;
        this.times = times;
        this.timeToLive = timeToLive;
        this.priority = priority;
    }

    public Expectation withId(String key) {
        this.id = key;
        return this;
    }

    public String getId() {
        if (this.id == null) {
            this.id = UUIDService.getUUID();
        }
        return this.id;
    }

    public Integer getPriority() {
        return this.priority;
    }

    public Expectation withCreated(long created) {
        this.created = created;
        return this;
    }

    public long getCreated() {
        return this.created;
    }

    public HttpRequest getHttpRequest() {
        return this.httpRequest;
    }

    public HttpResponse getHttpResponse() {
        return this.httpResponse;
    }

    public HttpTemplate getHttpResponseTemplate() {
        return this.httpResponseTemplate;
    }

    public HttpClassCallback getHttpResponseClassCallback() {
        return this.httpResponseClassCallback;
    }

    public HttpObjectCallback getHttpResponseObjectCallback() {
        return this.httpResponseObjectCallback;
    }

    public HttpForward getHttpForward() {
        return this.httpForward;
    }

    public HttpTemplate getHttpForwardTemplate() {
        return this.httpForwardTemplate;
    }

    public HttpClassCallback getHttpForwardClassCallback() {
        return this.httpForwardClassCallback;
    }

    public HttpObjectCallback getHttpForwardObjectCallback() {
        return this.httpForwardObjectCallback;
    }

    public HttpOverrideForwardedRequest getHttpOverrideForwardedRequest() {
        return this.httpOverrideForwardedRequest;
    }

    public HttpError getHttpError() {
        return this.httpError;
    }

    @JsonIgnore
    public Action getAction() {
        if (this.httpResponse != null) {
            return this.getHttpResponse();
        }
        if (this.httpResponseTemplate != null) {
            return this.getHttpResponseTemplate();
        }
        if (this.httpResponseClassCallback != null) {
            return this.getHttpResponseClassCallback();
        }
        if (this.httpResponseObjectCallback != null) {
            return this.getHttpResponseObjectCallback();
        }
        if (this.httpForward != null) {
            return this.getHttpForward();
        }
        if (this.httpForwardTemplate != null) {
            return this.getHttpForwardTemplate();
        }
        if (this.httpForwardClassCallback != null) {
            return this.getHttpForwardClassCallback();
        }
        if (this.httpForwardObjectCallback != null) {
            return this.getHttpForwardObjectCallback();
        }
        if (this.httpOverrideForwardedRequest != null) {
            return this.getHttpOverrideForwardedRequest();
        }
        if (this.httpError != null) {
            return this.getHttpError();
        }
        return null;
    }

    public Times getTimes() {
        return this.times;
    }

    public TimeToLive getTimeToLive() {
        return this.timeToLive;
    }

    public Expectation thenRespond(HttpResponse httpResponse) {
        if (httpResponse != null) {
            this.validationErrors("a response", httpResponse.getType());
            this.httpResponse = httpResponse;
        }
        return this;
    }

    public Expectation thenRespond(HttpTemplate httpTemplate) {
        if (httpTemplate != null) {
            httpTemplate.setActionType(Action.Type.RESPONSE_TEMPLATE);
            this.validationErrors("a response template", httpTemplate.getType());
            this.httpResponseTemplate = httpTemplate;
        }
        return this;
    }

    public Expectation thenRespond(HttpClassCallback httpClassCallback) {
        if (httpClassCallback != null) {
            httpClassCallback.withActionType(Action.Type.RESPONSE_CLASS_CALLBACK);
            this.validationErrors("a response class callback", httpClassCallback.getType());
            this.httpResponseClassCallback = httpClassCallback;
        }
        return this;
    }

    public Expectation thenRespond(HttpObjectCallback httpObjectCallback) {
        if (httpObjectCallback != null) {
            httpObjectCallback.withActionType(Action.Type.RESPONSE_OBJECT_CALLBACK);
            this.validationErrors("a response object callback", httpObjectCallback.getType());
            this.httpResponseObjectCallback = httpObjectCallback;
        }
        return this;
    }

    public Expectation thenForward(HttpForward httpForward) {
        if (httpForward != null) {
            this.validationErrors("a forward", httpForward.getType());
            this.httpForward = httpForward;
        }
        return this;
    }

    public Expectation thenForward(HttpTemplate httpTemplate) {
        if (httpTemplate != null) {
            httpTemplate.setActionType(Action.Type.FORWARD_TEMPLATE);
            this.validationErrors("a forward template", httpTemplate.getType());
            this.httpForwardTemplate = httpTemplate;
        }
        return this;
    }

    public Expectation thenForward(HttpClassCallback httpClassCallback) {
        if (httpClassCallback != null) {
            httpClassCallback.withActionType(Action.Type.FORWARD_CLASS_CALLBACK);
            this.validationErrors("a forward class callback", httpClassCallback.getType());
            this.httpForwardClassCallback = httpClassCallback;
        }
        return this;
    }

    public Expectation thenForward(HttpObjectCallback httpObjectCallback) {
        if (httpObjectCallback != null) {
            httpObjectCallback.withActionType(Action.Type.FORWARD_OBJECT_CALLBACK);
            this.validationErrors("a forward object callback", httpObjectCallback.getType());
            this.httpForwardObjectCallback = httpObjectCallback;
        }
        return this;
    }

    public Expectation thenForward(HttpOverrideForwardedRequest httpOverrideForwardedRequest) {
        if (httpOverrideForwardedRequest != null) {
            this.validationErrors("a forward replace", httpOverrideForwardedRequest.getType());
            this.httpOverrideForwardedRequest = httpOverrideForwardedRequest;
        }
        return this;
    }

    public Expectation thenError(HttpError httpError) {
        if (httpError != null) {
            this.validationErrors("an error", httpError.getType());
            this.httpError = httpError;
        }
        return this;
    }

    private void validationErrors(String actionDescription, Action.Type actionType) {
        if (actionType != Action.Type.RESPONSE && this.httpResponse != null) {
            throw new IllegalArgumentException("It is not possible to set " + actionDescription + " once a response has been set");
        }
        if (actionType != Action.Type.RESPONSE_TEMPLATE && this.httpResponseTemplate != null) {
            throw new IllegalArgumentException("It is not possible to set " + actionDescription + " once a response template has been set");
        }
        if (actionType != Action.Type.RESPONSE_CLASS_CALLBACK && this.httpResponseClassCallback != null) {
            throw new IllegalArgumentException("It is not possible to set " + actionDescription + " once a class callback has been set");
        }
        if (actionType != Action.Type.RESPONSE_OBJECT_CALLBACK && this.httpResponseObjectCallback != null) {
            throw new IllegalArgumentException("It is not possible to set " + actionDescription + " once an object callback has been set");
        }
        if (actionType != Action.Type.FORWARD && this.httpForward != null) {
            throw new IllegalArgumentException("It is not possible to set " + actionDescription + " once a forward has been set");
        }
        if (actionType != Action.Type.FORWARD_TEMPLATE && this.httpForwardTemplate != null) {
            throw new IllegalArgumentException("It is not possible to set " + actionDescription + " once a forward template has been set");
        }
        if (actionType != Action.Type.FORWARD_CLASS_CALLBACK && this.httpForwardClassCallback != null) {
            throw new IllegalArgumentException("It is not possible to set " + actionDescription + " once a class callback has been set");
        }
        if (actionType != Action.Type.FORWARD_OBJECT_CALLBACK && this.httpForwardObjectCallback != null) {
            throw new IllegalArgumentException("It is not possible to set " + actionDescription + " once an object callback has been set");
        }
        if (actionType != Action.Type.FORWARD_REPLACE && this.httpOverrideForwardedRequest != null) {
            throw new IllegalArgumentException("It is not possible to set " + actionDescription + " once a forward replace has been set");
        }
        if (actionType != Action.Type.ERROR && this.httpError != null) {
            throw new IllegalArgumentException("It is not possible to set " + actionDescription + " callback once an error has been set");
        }
    }

    @JsonIgnore
    public boolean isActive() {
        return this.hasRemainingMatches() && this.isStillAlive();
    }

    private boolean hasRemainingMatches() {
        return this.times == null || this.times.greaterThenZero();
    }

    private boolean isStillAlive() {
        return this.timeToLive == null || this.timeToLive.stillAlive();
    }

    public boolean decrementRemainingMatches() {
        if (this.times != null) {
            return this.times.decrement();
        }
        return false;
    }

    public boolean contains(HttpRequest httpRequest) {
        return httpRequest != null && this.httpRequest.equals(httpRequest);
    }

    public Expectation clone() {
        return new Expectation(this.httpRequest, this.times.clone(), this.timeToLive, this.priority).withId(this.id).withCreated(this.created).thenRespond(this.httpResponse).thenRespond(this.httpResponseTemplate).thenRespond(this.httpResponseClassCallback).thenRespond(this.httpResponseObjectCallback).thenForward(this.httpForward).thenForward(this.httpForwardTemplate).thenForward(this.httpForwardClassCallback).thenForward(this.httpForwardObjectCallback).thenForward(this.httpOverrideForwardedRequest).thenError(this.httpError);
    }

    @Override
    @JsonIgnore
    public String[] fieldsExcludedFromEqualsAndHashCode() {
        return excludedFields;
    }
}

