/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.mock.action;

import org.mockserver.logging.MockServerLogger;
import org.mockserver.model.HttpRequest;
import org.mockserver.model.HttpResponse;
import org.mockserver.model.HttpTemplate;
import org.mockserver.serialization.model.HttpResponseDTO;
import org.mockserver.templates.engine.TemplateEngine;
import org.mockserver.templates.engine.javascript.JavaScriptTemplateEngine;
import org.mockserver.templates.engine.velocity.VelocityTemplateEngine;

public class HttpResponseTemplateActionHandler {
    private JavaScriptTemplateEngine javaScriptTemplateEngine;
    private VelocityTemplateEngine velocityTemplateEngine;

    public HttpResponseTemplateActionHandler(MockServerLogger logFormatter) {
        this.javaScriptTemplateEngine = new JavaScriptTemplateEngine(logFormatter);
        this.velocityTemplateEngine = new VelocityTemplateEngine(logFormatter);
    }

    public HttpResponse handle(HttpTemplate httpTemplate, HttpRequest httpRequest) {
        HttpResponse templatedResponse;
        TemplateEngine templateEngine;
        HttpResponse httpResponse = HttpResponse.notFoundResponse();
        switch (httpTemplate.getTemplateType()) {
            case VELOCITY: {
                templateEngine = this.velocityTemplateEngine;
                break;
            }
            case JAVASCRIPT: {
                templateEngine = this.javaScriptTemplateEngine;
                break;
            }
            default: {
                throw new RuntimeException("Unknown no template engine available for " + (Object)((Object)httpTemplate.getTemplateType()));
            }
        }
        if (templateEngine != null && (templatedResponse = (HttpResponse)templateEngine.executeTemplate(httpTemplate.getTemplate(), httpRequest, HttpResponseDTO.class)) != null) {
            return templatedResponse;
        }
        return httpResponse;
    }
}

