/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.serialization.java;

import com.google.common.base.Strings;
import org.mockserver.character.Character;
import org.mockserver.model.SocketAddress;
import org.mockserver.serialization.java.ToJavaSerializer;

public class SocketAddressToJavaSerializer
implements ToJavaSerializer<SocketAddress> {
    @Override
    public String serialize(int numberOfSpacesToIndent, SocketAddress socketAddress) {
        StringBuffer output = new StringBuffer();
        if (socketAddress != null) {
            this.appendNewLineAndIndent(numberOfSpacesToIndent * 8, output).append("new SocketAddress()");
            if (socketAddress.getHost() != null) {
                this.appendNewLineAndIndent((numberOfSpacesToIndent + 1) * 8, output).append(".withHost(\"").append(socketAddress.getHost()).append("\")");
            }
            if (socketAddress.getPort() != null) {
                this.appendNewLineAndIndent((numberOfSpacesToIndent + 1) * 8, output).append(".withPort(").append(socketAddress.getPort()).append(")");
            }
            if (socketAddress.getScheme() != null) {
                this.appendNewLineAndIndent((numberOfSpacesToIndent + 1) * 8, output).append(".withScheme(SocketAddress.Scheme.").append((Object)socketAddress.getScheme()).append(")");
            }
        }
        return output.toString();
    }

    private StringBuffer appendNewLineAndIndent(int numberOfSpacesToIndent, StringBuffer output) {
        return output.append(Character.NEW_LINE).append(Strings.padStart((String)"", (int)numberOfSpacesToIndent, (char)' '));
    }
}

