/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.serialization.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import org.mockserver.matchers.TimeToLive;
import org.mockserver.matchers.Times;
import org.mockserver.mock.Expectation;
import org.mockserver.model.HttpClassCallback;
import org.mockserver.model.HttpError;
import org.mockserver.model.HttpForward;
import org.mockserver.model.HttpObjectCallback;
import org.mockserver.model.HttpOverrideForwardedRequest;
import org.mockserver.model.HttpRequest;
import org.mockserver.model.HttpResponse;
import org.mockserver.model.HttpTemplate;
import org.mockserver.model.ObjectWithJsonToString;
import org.mockserver.serialization.model.DTO;
import org.mockserver.serialization.model.HttpClassCallbackDTO;
import org.mockserver.serialization.model.HttpErrorDTO;
import org.mockserver.serialization.model.HttpForwardDTO;
import org.mockserver.serialization.model.HttpObjectCallbackDTO;
import org.mockserver.serialization.model.HttpOverrideForwardedRequestDTO;
import org.mockserver.serialization.model.HttpRequestDTO;
import org.mockserver.serialization.model.HttpResponseDTO;
import org.mockserver.serialization.model.HttpTemplateDTO;
import org.mockserver.serialization.model.TimeToLiveDTO;
import org.mockserver.serialization.model.TimesDTO;

public class ExpectationDTO
extends ObjectWithJsonToString
implements DTO<Expectation> {
    private static final String[] excludedFields = new String[]{"id"};
    private String id;
    private Integer priority;
    private HttpRequestDTO httpRequest;
    private HttpResponseDTO httpResponse;
    private HttpTemplateDTO httpResponseTemplate;
    private HttpClassCallbackDTO httpResponseClassCallback;
    private HttpObjectCallbackDTO httpResponseObjectCallback;
    private HttpForwardDTO httpForward;
    private HttpTemplateDTO httpForwardTemplate;
    private HttpClassCallbackDTO httpForwardClassCallback;
    private HttpObjectCallbackDTO httpForwardObjectCallback;
    private HttpOverrideForwardedRequestDTO httpOverrideForwardedRequest;
    private HttpErrorDTO httpError;
    private TimesDTO times;
    private TimeToLiveDTO timeToLive;

    public ExpectationDTO(Expectation expectation) {
        if (expectation != null) {
            TimeToLive timeToLive;
            Times times;
            HttpError httpError;
            HttpOverrideForwardedRequest httpOverrideForwardedRequest;
            HttpObjectCallback httpForwardObjectCallback;
            HttpClassCallback httpForwardClassCallback;
            HttpTemplate httpForwardTemplate;
            HttpForward httpForward;
            HttpObjectCallback httpResponseObjectCallback;
            HttpClassCallback httpResponseClassCallback;
            HttpTemplate httpResponseTemplate;
            HttpResponse httpResponse;
            HttpRequest httpRequest;
            this.id = expectation.getId();
            Integer priority = expectation.getPriority();
            if (priority != null) {
                this.priority = expectation.getPriority();
            }
            if ((httpRequest = expectation.getHttpRequest()) != null) {
                this.httpRequest = new HttpRequestDTO(httpRequest, httpRequest.getNot());
            }
            if ((httpResponse = expectation.getHttpResponse()) != null) {
                this.httpResponse = new HttpResponseDTO(httpResponse);
            }
            if ((httpResponseTemplate = expectation.getHttpResponseTemplate()) != null) {
                this.httpResponseTemplate = new HttpTemplateDTO(httpResponseTemplate);
            }
            if ((httpResponseClassCallback = expectation.getHttpResponseClassCallback()) != null) {
                this.httpResponseClassCallback = new HttpClassCallbackDTO(httpResponseClassCallback);
            }
            if ((httpResponseObjectCallback = expectation.getHttpResponseObjectCallback()) != null) {
                this.httpResponseObjectCallback = new HttpObjectCallbackDTO(httpResponseObjectCallback);
            }
            if ((httpForward = expectation.getHttpForward()) != null) {
                this.httpForward = new HttpForwardDTO(httpForward);
            }
            if ((httpForwardTemplate = expectation.getHttpForwardTemplate()) != null) {
                this.httpForwardTemplate = new HttpTemplateDTO(httpForwardTemplate);
            }
            if ((httpForwardClassCallback = expectation.getHttpForwardClassCallback()) != null) {
                this.httpForwardClassCallback = new HttpClassCallbackDTO(httpForwardClassCallback);
            }
            if ((httpForwardObjectCallback = expectation.getHttpForwardObjectCallback()) != null) {
                this.httpForwardObjectCallback = new HttpObjectCallbackDTO(httpForwardObjectCallback);
            }
            if ((httpOverrideForwardedRequest = expectation.getHttpOverrideForwardedRequest()) != null) {
                this.httpOverrideForwardedRequest = new HttpOverrideForwardedRequestDTO(httpOverrideForwardedRequest);
            }
            if ((httpError = expectation.getHttpError()) != null) {
                this.httpError = new HttpErrorDTO(httpError);
            }
            if ((times = expectation.getTimes()) != null) {
                this.times = new TimesDTO(times);
            }
            if ((timeToLive = expectation.getTimeToLive()) != null) {
                this.timeToLive = new TimeToLiveDTO(timeToLive);
            }
        }
    }

    public ExpectationDTO() {
    }

    @Override
    public Expectation buildObject() {
        HttpRequest httpRequest = null;
        HttpResponse httpResponse = null;
        HttpTemplate httpResponseTemplate = null;
        HttpClassCallback httpResponseClassCallback = null;
        HttpObjectCallback httpResponseObjectCallback = null;
        HttpForward httpForward = null;
        HttpTemplate httpForwardTemplate = null;
        HttpClassCallback httpForwardClassCallback = null;
        HttpObjectCallback httpForwardObjectCallback = null;
        HttpOverrideForwardedRequest httpOverrideForwardedRequest = null;
        HttpError httpError = null;
        if (this.httpRequest != null) {
            httpRequest = this.httpRequest.buildObject();
        }
        if (this.httpResponse != null) {
            httpResponse = this.httpResponse.buildObject();
        }
        if (this.httpResponseTemplate != null) {
            httpResponseTemplate = this.httpResponseTemplate.buildObject();
        }
        if (this.httpResponseClassCallback != null) {
            httpResponseClassCallback = this.httpResponseClassCallback.buildObject();
        }
        if (this.httpResponseObjectCallback != null) {
            httpResponseObjectCallback = this.httpResponseObjectCallback.buildObject();
        }
        if (this.httpForward != null) {
            httpForward = this.httpForward.buildObject();
        }
        if (this.httpForwardTemplate != null) {
            httpForwardTemplate = this.httpForwardTemplate.buildObject();
        }
        if (this.httpForwardClassCallback != null) {
            httpForwardClassCallback = this.httpForwardClassCallback.buildObject();
        }
        if (this.httpForwardObjectCallback != null) {
            httpForwardObjectCallback = this.httpForwardObjectCallback.buildObject();
        }
        if (this.httpOverrideForwardedRequest != null) {
            httpOverrideForwardedRequest = this.httpOverrideForwardedRequest.buildObject();
        }
        if (this.httpError != null) {
            httpError = this.httpError.buildObject();
        }
        Times times = this.times != null ? this.times.buildObject() : Times.unlimited();
        TimeToLive timeToLive = this.timeToLive != null ? this.timeToLive.buildObject() : TimeToLive.unlimited();
        int priority = this.priority != null ? this.priority : 0;
        return new Expectation(httpRequest, times, timeToLive, priority).withId(this.id).thenRespond(httpResponse).thenRespond(httpResponseTemplate).thenRespond(httpResponseClassCallback).thenRespond(httpResponseObjectCallback).thenForward(httpForward).thenForward(httpForwardTemplate).thenForward(httpForwardClassCallback).thenForward(httpForwardObjectCallback).thenForward(httpOverrideForwardedRequest).thenError(httpError);
    }

    public String getId() {
        return this.id;
    }

    public ExpectationDTO setId(String id) {
        this.id = id;
        return this;
    }

    public Integer getPriority() {
        return this.priority;
    }

    public ExpectationDTO setPriority(Integer priority) {
        this.priority = priority;
        return this;
    }

    public HttpRequestDTO getHttpRequest() {
        return this.httpRequest;
    }

    public ExpectationDTO setHttpRequest(HttpRequestDTO httpRequest) {
        this.httpRequest = httpRequest;
        return this;
    }

    public HttpResponseDTO getHttpResponse() {
        return this.httpResponse;
    }

    public ExpectationDTO setHttpResponse(HttpResponseDTO httpResponse) {
        this.httpResponse = httpResponse;
        return this;
    }

    public HttpTemplateDTO getHttpResponseTemplate() {
        return this.httpResponseTemplate;
    }

    public ExpectationDTO setHttpResponseTemplate(HttpTemplateDTO httpResponseTemplate) {
        this.httpResponseTemplate = httpResponseTemplate;
        return this;
    }

    public HttpClassCallbackDTO getHttpResponseClassCallback() {
        return this.httpResponseClassCallback;
    }

    public ExpectationDTO setHttpResponseClassCallback(HttpClassCallbackDTO httpObjectCallback) {
        this.httpResponseClassCallback = httpObjectCallback;
        return this;
    }

    public HttpObjectCallbackDTO getHttpResponseObjectCallback() {
        return this.httpResponseObjectCallback;
    }

    public ExpectationDTO setHttpResponseObjectCallback(HttpObjectCallbackDTO httpObjectCallback) {
        this.httpResponseObjectCallback = httpObjectCallback;
        return this;
    }

    public HttpForwardDTO getHttpForward() {
        return this.httpForward;
    }

    public ExpectationDTO setHttpForward(HttpForwardDTO httpForward) {
        this.httpForward = httpForward;
        return this;
    }

    public HttpTemplateDTO getHttpForwardTemplate() {
        return this.httpForwardTemplate;
    }

    public ExpectationDTO setHttpForwardTemplate(HttpTemplateDTO httpForwardTemplate) {
        this.httpForwardTemplate = httpForwardTemplate;
        return this;
    }

    public HttpClassCallbackDTO getHttpForwardClassCallback() {
        return this.httpForwardClassCallback;
    }

    public ExpectationDTO setHttpForwardClassCallback(HttpClassCallbackDTO httpClassCallback) {
        this.httpForwardClassCallback = httpClassCallback;
        return this;
    }

    public HttpObjectCallbackDTO getHttpForwardObjectCallback() {
        return this.httpForwardObjectCallback;
    }

    public ExpectationDTO setHttpForwardObjectCallback(HttpObjectCallbackDTO httpObjectCallback) {
        this.httpForwardObjectCallback = httpObjectCallback;
        return this;
    }

    public HttpOverrideForwardedRequestDTO getHttpOverrideForwardedRequest() {
        return this.httpOverrideForwardedRequest;
    }

    public ExpectationDTO setHttpOverrideForwardedRequest(HttpOverrideForwardedRequestDTO httpOverrideForwardedRequest) {
        this.httpOverrideForwardedRequest = httpOverrideForwardedRequest;
        return this;
    }

    public HttpErrorDTO getHttpError() {
        return this.httpError;
    }

    public ExpectationDTO setHttpError(HttpErrorDTO httpError) {
        this.httpError = httpError;
        return this;
    }

    public TimesDTO getTimes() {
        return this.times;
    }

    public ExpectationDTO setTimes(TimesDTO times) {
        this.times = times;
        return this;
    }

    public TimeToLiveDTO getTimeToLive() {
        return this.timeToLive;
    }

    public ExpectationDTO setTimeToLive(TimeToLiveDTO timeToLive) {
        this.timeToLive = timeToLive;
        return this;
    }

    @Override
    @JsonIgnore
    public String[] fieldsExcludedFromEqualsAndHashCode() {
        return excludedFields;
    }
}

