/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.echo.http;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.socket.SocketChannel;
import io.netty.handler.codec.http.HttpContentDecompressor;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.HttpServerCodec;
import io.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import io.netty.handler.ssl.SslContext;
import java.util.List;
import org.mockserver.codec.MockServerHttpServerCodec;
import org.mockserver.echo.http.EchoServer;
import org.mockserver.echo.http.EchoServerHandler;
import org.mockserver.echo.http.ErrorHandler;
import org.mockserver.echo.http.WebSocketServerHandler;
import org.mockserver.log.MockServerEventLog;
import org.mockserver.log.model.LogEntry;
import org.mockserver.logging.LoggingHandler;
import org.mockserver.logging.MockServerLogger;
import org.mockserver.socket.tls.NettySslContextFactory;
import org.slf4j.event.Level;

public class EchoServerInitializer
extends ChannelInitializer<SocketChannel> {
    private final MockServerLogger mockServerLogger;
    private final boolean secure;
    private final EchoServer.Error error;
    private final List<TextWebSocketFrame> textWebSocketFrames;
    private final List<Channel> websocketChannels;
    private final List<String> registeredClients;
    private final SslContext sslContext;

    EchoServerInitializer(MockServerLogger mockServerLogger, boolean secure, SslContext sslContext, EchoServer.Error error, List<String> registeredClients, List<Channel> websocketChannels, List<TextWebSocketFrame> textWebSocketFrames) {
        this.mockServerLogger = mockServerLogger;
        this.secure = secure;
        this.sslContext = sslContext;
        if (!secure && error == EchoServer.Error.CLOSE_CONNECTION) {
            throw new IllegalArgumentException("Error type CLOSE_CONNECTION is not supported in non-secure mode");
        }
        this.error = error;
        this.registeredClients = registeredClients;
        this.websocketChannels = websocketChannels;
        this.textWebSocketFrames = textWebSocketFrames;
    }

    public void initChannel(SocketChannel channel) {
        ChannelPipeline pipeline = channel.pipeline();
        if (this.error != null) {
            pipeline.addLast(new ChannelHandler[]{new ErrorHandler(this.error)});
        }
        if (this.secure) {
            pipeline.addLast(new ChannelHandler[]{(this.sslContext != null ? this.sslContext : new NettySslContextFactory(this.mockServerLogger).createServerSslContext()).newHandler(channel.alloc())});
        }
        if (MockServerLogger.isEnabled(Level.TRACE)) {
            pipeline.addLast(new ChannelHandler[]{new LoggingHandler("EchoServer <-->")});
        }
        pipeline.addLast(new ChannelHandler[]{new HttpServerCodec()});
        pipeline.addLast(new ChannelHandler[]{new HttpContentDecompressor()});
        pipeline.addLast(new ChannelHandler[]{new HttpObjectAggregator(Integer.MAX_VALUE)});
        pipeline.addLast(new ChannelHandler[]{new WebSocketServerHandler(this.mockServerLogger, this.registeredClients, this.websocketChannels, this.textWebSocketFrames, this.secure)});
        pipeline.addLast(new ChannelHandler[]{new MockServerHttpServerCodec(this.mockServerLogger, this.secure, channel.localAddress().getPort())});
        if (!this.secure && this.error == EchoServer.Error.CLOSE_CONNECTION) {
            throw new IllegalArgumentException("Error type CLOSE_CONNECTION is not supported in non-secure mode");
        }
        pipeline.addLast(new ChannelHandler[]{new EchoServerHandler(this.error, this.mockServerLogger, (MockServerEventLog)channel.attr(EchoServer.LOG_FILTER).get(), (EchoServer.NextResponse)channel.attr(EchoServer.NEXT_RESPONSE).get())});
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        this.mockServerLogger.logEvent(new LogEntry().setLogLevel(Level.ERROR).setMessageFormat("echo server server caught exception").setThrowable(cause));
        ctx.close();
    }
}

