/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.matchers;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.mockserver.model.ObjectWithReflectiveEqualsHashCodeToString;

public class TimeToLive
extends ObjectWithReflectiveEqualsHashCodeToString {
    private static final String[] EXCLUDED_FIELDS = new String[]{"endDate"};
    private static final TimeToLive TIME_TO_LIVE_UNLIMITED = new TimeToLive(null, null, true){

        @Override
        public boolean stillAlive() {
            return true;
        }
    };
    private int hashCode;
    private final TimeUnit timeUnit;
    private final Long timeToLive;
    private final boolean unlimited;
    private long endDate;

    private TimeToLive(TimeUnit timeUnit, Long timeToLive, boolean unlimited) {
        this.timeUnit = timeUnit;
        this.timeToLive = timeToLive;
        this.unlimited = unlimited;
        if (!unlimited) {
            this.endDate = System.currentTimeMillis() + timeUnit.toMillis(timeToLive);
        }
    }

    public static TimeToLive unlimited() {
        return TIME_TO_LIVE_UNLIMITED;
    }

    public static TimeToLive exactly(TimeUnit timeUnit, Long timeToLive) {
        return new TimeToLive(timeUnit, timeToLive, false);
    }

    public TimeUnit getTimeUnit() {
        return this.timeUnit;
    }

    public Long getTimeToLive() {
        return this.timeToLive;
    }

    @JsonIgnore
    public long getEndDate() {
        return this.endDate;
    }

    public TimeToLive setEndDate(long endDate) {
        this.endDate = endDate;
        return this;
    }

    public boolean isUnlimited() {
        return this.unlimited;
    }

    public boolean stillAlive() {
        return this.unlimited || this.isAfterNow(this.endDate);
    }

    private boolean isAfterNow(long date) {
        return date > System.currentTimeMillis();
    }

    @Override
    @JsonIgnore
    protected String[] fieldsExcludedFromEqualsAndHashCode() {
        return EXCLUDED_FIELDS;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (this.hashCode() != o.hashCode()) {
            return false;
        }
        TimeToLive that = (TimeToLive)o;
        return this.unlimited == that.unlimited && this.timeUnit == that.timeUnit && Objects.equals(this.timeToLive, that.timeToLive);
    }

    @Override
    public int hashCode() {
        if (this.hashCode == 0) {
            this.hashCode = Objects.hash(new Object[]{this.timeUnit, this.timeToLive, this.unlimited});
        }
        return this.hashCode;
    }
}

