/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.metrics;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.mockserver.configuration.ConfigurationProperties;
import org.mockserver.model.Action;

public class Metrics {
    private static Map<Name, Integer> metrics = new ConcurrentHashMap<Name, Integer>();

    public static void clear() {
        metrics.clear();
    }

    public static void set(Name name, Integer value) {
        metrics.put(name, value);
    }

    public static Integer get(Name name) {
        Integer value = metrics.get((Object)name);
        return value != null ? value : 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void increment(Name name) {
        if (ConfigurationProperties.metricsEnabled()) {
            Name name2 = name;
            synchronized (name2) {
                metrics.merge(name, 1, Integer::sum);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void decrement(Name name) {
        if (ConfigurationProperties.metricsEnabled()) {
            Name name2 = name;
            synchronized (name2) {
                Integer currentValue = metrics.get((Object)name);
                if (currentValue == null) {
                    throw new IllegalArgumentException("Can not decrement metric \"" + (Object)((Object)name) + "\" because it not exist");
                }
                metrics.put(name, currentValue - 1);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void increment(Action.Type type) {
        if (ConfigurationProperties.metricsEnabled()) {
            Name name;
            Name name2 = name = Name.valueOf("ACTION_" + type.name() + "_COUNT");
            synchronized (name2) {
                metrics.merge(name, 1, Integer::sum);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void decrement(Action.Type type) {
        if (ConfigurationProperties.metricsEnabled()) {
            Name name;
            Name name2 = name = Name.valueOf("ACTION_" + type.name() + "_COUNT");
            synchronized (name2) {
                Integer currentValue = metrics.get((Object)name);
                if (currentValue == null) {
                    throw new IllegalArgumentException("Can not decrement metric \"" + (Object)((Object)name) + "\" because it not exist");
                }
                metrics.put(name, currentValue - 1);
            }
        }
    }

    public static void clearActionMetrics() {
        metrics.remove((Object)Name.ACTION_FORWARD_COUNT);
        metrics.remove((Object)Name.ACTION_FORWARD_TEMPLATE_COUNT);
        metrics.remove((Object)Name.ACTION_FORWARD_CLASS_CALLBACK_COUNT);
        metrics.remove((Object)Name.ACTION_FORWARD_OBJECT_CALLBACK_COUNT);
        metrics.remove((Object)Name.ACTION_FORWARD_REPLACE_COUNT);
        metrics.remove((Object)Name.ACTION_RESPONSE_COUNT);
        metrics.remove((Object)Name.ACTION_RESPONSE_TEMPLATE_COUNT);
        metrics.remove((Object)Name.ACTION_RESPONSE_CLASS_CALLBACK_COUNT);
        metrics.remove((Object)Name.ACTION_RESPONSE_OBJECT_CALLBACK_COUNT);
        metrics.remove((Object)Name.ACTION_ERROR_COUNT);
    }

    public static void clearWebSocketMetrics() {
        metrics.remove((Object)Name.WEBSOCKET_CALLBACK_CLIENT_COUNT);
        metrics.remove((Object)Name.WEBSOCKET_CALLBACK_RESPONSE_HANDLER_COUNT);
        metrics.remove((Object)Name.WEBSOCKET_CALLBACK_FORWARD_HANDLER_COUNT);
    }

    public static enum Name {
        EXPECTATION_NOT_MATCHED_COUNT,
        RESPONSE_EXPECTATION_MATCHED_COUNT,
        FORWARD_EXPECTATION_MATCHED_COUNT,
        ACTION_FORWARD_COUNT,
        ACTION_FORWARD_TEMPLATE_COUNT,
        ACTION_FORWARD_CLASS_CALLBACK_COUNT,
        ACTION_FORWARD_OBJECT_CALLBACK_COUNT,
        ACTION_FORWARD_REPLACE_COUNT,
        ACTION_RESPONSE_COUNT,
        ACTION_RESPONSE_TEMPLATE_COUNT,
        ACTION_RESPONSE_CLASS_CALLBACK_COUNT,
        ACTION_RESPONSE_OBJECT_CALLBACK_COUNT,
        ACTION_ERROR_COUNT,
        WEBSOCKET_CALLBACK_CLIENT_COUNT,
        WEBSOCKET_CALLBACK_RESPONSE_HANDLER_COUNT,
        WEBSOCKET_CALLBACK_FORWARD_HANDLER_COUNT;

    }
}

