/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.serialization.serializers.body;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import org.mockserver.log.model.LogEntry;
import org.mockserver.logging.MockServerLogger;
import org.mockserver.model.JsonBody;
import org.mockserver.serialization.ObjectMapperFactory;
import org.mockserver.serialization.model.JsonBodyDTO;

public class JsonBodyDTOSerializer
extends StdSerializer<JsonBodyDTO> {
    private static final ObjectMapper OBJECT_MAPPER = ObjectMapperFactory.createObjectMapper();

    public JsonBodyDTOSerializer() {
        super(JsonBodyDTO.class);
    }

    public void serialize(JsonBodyDTO jsonBodyDTO, JsonGenerator jgen, SerializerProvider provider) throws IOException {
        boolean matchTypeNonDefault;
        boolean notNonDefault = jsonBodyDTO.getNot() != null && jsonBodyDTO.getNot() != false;
        boolean optionalNonDefault = jsonBodyDTO.getOptional() != null && jsonBodyDTO.getOptional() != false;
        boolean contentTypeNonDefault = jsonBodyDTO.getContentType() != null && !jsonBodyDTO.getContentType().equals(JsonBody.DEFAULT_JSON_CONTENT_TYPE.toString());
        boolean bl = matchTypeNonDefault = jsonBodyDTO.getMatchType() != JsonBody.DEFAULT_MATCH_TYPE;
        if (notNonDefault || optionalNonDefault || contentTypeNonDefault || matchTypeNonDefault) {
            jgen.writeStartObject();
            if (notNonDefault) {
                jgen.writeBooleanField("not", jsonBodyDTO.getNot().booleanValue());
            }
            if (optionalNonDefault) {
                jgen.writeBooleanField("optional", jsonBodyDTO.getOptional().booleanValue());
            }
            if (contentTypeNonDefault) {
                jgen.writeStringField("contentType", jsonBodyDTO.getContentType());
            }
            jgen.writeStringField("type", jsonBodyDTO.getType().name());
            try {
                jgen.writeObjectField("json", (Object)OBJECT_MAPPER.readTree(jsonBodyDTO.getJson()));
            }
            catch (Throwable throwable) {
                new MockServerLogger().logEvent(new LogEntry().setType(LogEntry.LogMessageType.EXCEPTION).setMessageFormat("exception:{} while deserialising JsonBodyDTO with json:{}").setArguments(throwable.getMessage(), jsonBodyDTO.getJson()).setThrowable(throwable));
            }
            if (jsonBodyDTO.getRawBytes() != null) {
                jgen.writeObjectField("rawBytes", (Object)jsonBodyDTO.getRawBytes());
            }
            if (matchTypeNonDefault) {
                jgen.writeStringField("matchType", jsonBodyDTO.getMatchType().name());
            }
            jgen.writeEndObject();
        } else {
            jgen.writeObject((Object)OBJECT_MAPPER.readTree(jsonBodyDTO.getJson()));
        }
    }
}

