/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.matchers;

import java.util.concurrent.TimeUnit;
import org.mockserver.cache.LRUCache;
import org.mockserver.logging.MockServerLogger;
import org.mockserver.matchers.AbstractHttpRequestMatcher;
import org.mockserver.matchers.HttpRequestMatcher;
import org.mockserver.matchers.HttpRequestPropertiesMatcher;
import org.mockserver.matchers.HttpRequestsPropertiesMatcher;
import org.mockserver.mock.Expectation;
import org.mockserver.model.OpenAPIDefinition;
import org.mockserver.model.RequestDefinition;

public class MatcherBuilder {
    private final MockServerLogger mockServerLogger;
    private final LRUCache<RequestDefinition, HttpRequestMatcher> requestMatcherLRUCache;

    public MatcherBuilder(MockServerLogger mockServerLogger) {
        this.mockServerLogger = mockServerLogger;
        this.requestMatcherLRUCache = new LRUCache(mockServerLogger, 250, TimeUnit.MINUTES.toMillis(10L));
    }

    public HttpRequestMatcher transformsToMatcher(RequestDefinition requestDefinition) {
        HttpRequestMatcher httpRequestMatcher = this.requestMatcherLRUCache.get(requestDefinition);
        if (httpRequestMatcher == null) {
            httpRequestMatcher = requestDefinition instanceof OpenAPIDefinition ? new HttpRequestsPropertiesMatcher(this.mockServerLogger) : new HttpRequestPropertiesMatcher(this.mockServerLogger);
            httpRequestMatcher.update(requestDefinition);
            this.requestMatcherLRUCache.put(requestDefinition, httpRequestMatcher);
        }
        return httpRequestMatcher;
    }

    public HttpRequestMatcher transformsToMatcher(Expectation expectation) {
        AbstractHttpRequestMatcher httpRequestMatcher = expectation.getHttpRequest() instanceof OpenAPIDefinition ? new HttpRequestsPropertiesMatcher(this.mockServerLogger) : new HttpRequestPropertiesMatcher(this.mockServerLogger);
        httpRequestMatcher.update(expectation);
        return httpRequestMatcher;
    }
}

