/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.serialization.deserializers.body;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.UnsupportedCharsetException;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.mockserver.log.model.LogEntry;
import org.mockserver.logging.MockServerLogger;
import org.mockserver.model.BinaryBody;
import org.mockserver.model.Body;
import org.mockserver.model.JsonBody;
import org.mockserver.model.MediaType;
import org.mockserver.model.StringBody;
import org.mockserver.model.XmlBody;
import org.mockserver.serialization.model.BinaryBodyDTO;
import org.mockserver.serialization.model.BodyDTO;
import org.mockserver.serialization.model.BodyWithContentTypeDTO;
import org.mockserver.serialization.model.JsonBodyDTO;
import org.mockserver.serialization.model.StringBodyDTO;
import org.mockserver.serialization.model.XmlBodyDTO;
import org.slf4j.event.Level;

public class BodyWithContentTypeDTODeserializer
extends StdDeserializer<BodyWithContentTypeDTO> {
    private static final Map<String, Body.Type> fieldNameToType = new HashMap<String, Body.Type>();
    private static final Base64.Decoder BASE64_DECODER = Base64.getDecoder();
    private static ObjectWriter jsonBodyObjectWriter;
    private static final MockServerLogger MOCK_SERVER_LOGGER;

    public BodyWithContentTypeDTODeserializer() {
        super(BodyWithContentTypeDTO.class);
    }

    public BodyWithContentTypeDTO deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
        BodyDTO result = null;
        JsonToken currentToken = jsonParser.getCurrentToken();
        String valueJsonValue = "";
        byte[] rawBytes = null;
        Enum type = null;
        Boolean not = null;
        Boolean optional = null;
        MediaType contentType = null;
        Charset charset = null;
        if (currentToken == JsonToken.START_OBJECT) {
            Map body = (Map)ctxt.readValue(jsonParser, Map.class);
            for (Map.Entry entry : body.entrySet()) {
                String key;
                block45: {
                    block44: {
                        block43: {
                            if (!(entry.getKey() instanceof String)) continue;
                            key = (String)entry.getKey();
                            if (key.equalsIgnoreCase("type")) {
                                try {
                                    type = Body.Type.valueOf(String.valueOf(entry.getValue()));
                                }
                                catch (IllegalArgumentException iae) {
                                    if (!MockServerLogger.isEnabled(Level.TRACE)) break block43;
                                    MOCK_SERVER_LOGGER.logEvent(new LogEntry().setLogLevel(Level.TRACE).setMessageFormat("ignoring invalid value for \"type\" field of \"" + entry.getValue() + "\"").setThrowable(iae));
                                }
                            }
                        }
                        if (this.containsIgnoreCase(key, "string", "regex", "json", "jsonSchema", "jsonPath", "xml", "xmlSchema", "xpath", "base64Bytes") && type != Body.Type.PARAMETERS) {
                            String fieldName = String.valueOf(entry.getKey()).toLowerCase();
                            if (fieldNameToType.containsKey(fieldName)) {
                                type = fieldNameToType.get(fieldName);
                            }
                            if (Map.class.isAssignableFrom(entry.getValue().getClass()) || this.containsIgnoreCase(key, "json", "jsonSchema") && !String.class.isAssignableFrom(entry.getValue().getClass())) {
                                if (jsonBodyObjectWriter == null) {
                                    jsonBodyObjectWriter = new ObjectMapper().writerWithDefaultPrettyPrinter();
                                }
                                valueJsonValue = jsonBodyObjectWriter.writeValueAsString(entry.getValue());
                            } else {
                                valueJsonValue = String.valueOf(entry.getValue());
                            }
                        }
                        if (this.containsIgnoreCase(key, "rawBytes", "base64Bytes") && entry.getValue() instanceof String) {
                            try {
                                rawBytes = BASE64_DECODER.decode((String)entry.getValue());
                            }
                            catch (Throwable throwable) {
                                if (!MockServerLogger.isEnabled(Level.DEBUG)) break block44;
                                MOCK_SERVER_LOGGER.logEvent(new LogEntry().setLogLevel(Level.DEBUG).setMessageFormat("invalid base64 encoded rawBytes with value \"" + entry.getValue() + "\"").setThrowable(throwable));
                            }
                        }
                    }
                    if (key.equalsIgnoreCase("not")) {
                        not = Boolean.parseBoolean(String.valueOf(entry.getValue()));
                    }
                    if (key.equalsIgnoreCase("optional")) {
                        optional = Boolean.parseBoolean(String.valueOf(entry.getValue()));
                    }
                    if (key.equalsIgnoreCase("contentType")) {
                        try {
                            MediaType parsedMediaTypeHeader;
                            String mediaTypeHeader = String.valueOf(entry.getValue());
                            if (StringUtils.isNotBlank((CharSequence)mediaTypeHeader) && StringUtils.isNotBlank((CharSequence)(parsedMediaTypeHeader = MediaType.parse(mediaTypeHeader)).toString())) {
                                contentType = parsedMediaTypeHeader;
                            }
                        }
                        catch (IllegalArgumentException uce) {
                            if (!MockServerLogger.isEnabled(Level.DEBUG)) break block45;
                            MOCK_SERVER_LOGGER.logEvent(new LogEntry().setLogLevel(Level.DEBUG).setMessageFormat("ignoring unsupported MediaType with value \"" + entry.getValue() + "\"").setThrowable(uce));
                        }
                    }
                }
                if (!key.equalsIgnoreCase("charset")) continue;
                try {
                    charset = Charset.forName(String.valueOf(entry.getValue()));
                }
                catch (UnsupportedCharsetException uce) {
                    if (!MockServerLogger.isEnabled(Level.DEBUG)) continue;
                    MOCK_SERVER_LOGGER.logEvent(new LogEntry().setLogLevel(Level.DEBUG).setMessageFormat("ignoring unsupported Charset with value \"" + entry.getValue() + "\"").setThrowable(uce));
                }
                catch (IllegalCharsetNameException icne) {
                    if (!MockServerLogger.isEnabled(Level.DEBUG)) continue;
                    MOCK_SERVER_LOGGER.logEvent(new LogEntry().setLogLevel(Level.DEBUG).setMessageFormat("ignoring invalid Charset with value \"" + entry.getValue() + "\"").setThrowable(icne));
                }
            }
            if (type != null) {
                switch (1.$SwitchMap$org$mockserver$model$Body$Type[type.ordinal()]) {
                    case 1: {
                        if (contentType != null && StringUtils.isNotBlank((CharSequence)contentType.toString())) {
                            result = new BinaryBodyDTO(new BinaryBody(rawBytes, contentType), not);
                            break;
                        }
                        result = new BinaryBodyDTO(new BinaryBody(rawBytes), not);
                        break;
                    }
                    case 2: {
                        if (contentType != null && StringUtils.isNotBlank((CharSequence)contentType.toString())) {
                            result = new JsonBodyDTO(new JsonBody(valueJsonValue, rawBytes, contentType, JsonBody.DEFAULT_MATCH_TYPE), not);
                            break;
                        }
                        if (charset != null) {
                            result = new JsonBodyDTO(new JsonBody(valueJsonValue, rawBytes, JsonBody.DEFAULT_JSON_CONTENT_TYPE.withCharset(charset), JsonBody.DEFAULT_MATCH_TYPE), not);
                            break;
                        }
                        result = new JsonBodyDTO(new JsonBody(valueJsonValue, rawBytes, JsonBody.DEFAULT_JSON_CONTENT_TYPE, JsonBody.DEFAULT_MATCH_TYPE), not);
                        break;
                    }
                    case 3: {
                        if (contentType != null && StringUtils.isNotBlank((CharSequence)contentType.toString())) {
                            result = new StringBodyDTO(new StringBody(valueJsonValue, rawBytes, false, contentType), not);
                            break;
                        }
                        if (charset != null) {
                            result = new StringBodyDTO(new StringBody(valueJsonValue, rawBytes, false, StringBody.DEFAULT_CONTENT_TYPE.withCharset(charset)), not);
                            break;
                        }
                        result = new StringBodyDTO(new StringBody(valueJsonValue, rawBytes, false, null), not);
                        break;
                    }
                    case 4: {
                        result = contentType != null && StringUtils.isNotBlank((CharSequence)contentType.toString()) ? new XmlBodyDTO(new XmlBody(valueJsonValue, rawBytes, contentType), not) : (charset != null ? new XmlBodyDTO(new XmlBody(valueJsonValue, rawBytes, XmlBody.DEFAULT_XML_CONTENT_TYPE.withCharset(charset)), not) : new XmlBodyDTO(new XmlBody(valueJsonValue, rawBytes, XmlBody.DEFAULT_XML_CONTENT_TYPE), not));
                    }
                }
            } else if (body.size() > 0) {
                if (jsonBodyObjectWriter == null) {
                    jsonBodyObjectWriter = new ObjectMapper().writerWithDefaultPrettyPrinter();
                }
                result = new JsonBodyDTO(new JsonBody(jsonBodyObjectWriter.writeValueAsString((Object)body), JsonBody.DEFAULT_MATCH_TYPE), null);
            }
        } else if (currentToken == JsonToken.START_ARRAY) {
            if (jsonBodyObjectWriter == null) {
                jsonBodyObjectWriter = new ObjectMapper().writerWithDefaultPrettyPrinter();
            }
            result = new JsonBodyDTO(new JsonBody(jsonBodyObjectWriter.writeValueAsString(ctxt.readValue(jsonParser, List.class)), JsonBody.DEFAULT_MATCH_TYPE), null);
        } else if (currentToken == JsonToken.VALUE_STRING) {
            result = new StringBodyDTO(new StringBody(jsonParser.getText()));
        }
        if (result != null) {
            result.withOptional(optional);
        }
        return result;
    }

    private boolean containsIgnoreCase(String valueToMatch, String ... listOfValues) {
        for (String item : listOfValues) {
            if (!item.equalsIgnoreCase(valueToMatch)) continue;
            return true;
        }
        return false;
    }

    static {
        fieldNameToType.put("base64Bytes".toLowerCase(), Body.Type.BINARY);
        fieldNameToType.put("json".toLowerCase(), Body.Type.JSON);
        fieldNameToType.put("string".toLowerCase(), Body.Type.STRING);
        fieldNameToType.put("xml".toLowerCase(), Body.Type.XML);
        MOCK_SERVER_LOGGER = new MockServerLogger(BodyWithContentTypeDTODeserializer.class);
    }
}

