/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.closurecallback.websocketclient;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.http.DefaultHttpHeaders;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.websocketx.CloseWebSocketFrame;
import io.netty.handler.codec.http.websocketx.PingWebSocketFrame;
import io.netty.handler.codec.http.websocketx.PongWebSocketFrame;
import io.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketClientHandshaker;
import io.netty.handler.codec.http.websocketx.WebSocketClientHandshakerFactory;
import io.netty.handler.codec.http.websocketx.WebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketVersion;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.concurrent.CompletableFuture;
import org.apache.commons.lang3.StringUtils;
import org.mockserver.closurecallback.websocketclient.WebSocketClient;
import org.mockserver.closurecallback.websocketclient.WebSocketException;
import org.mockserver.log.model.LogEntry;
import org.mockserver.logging.LoggingHandler;
import org.mockserver.logging.MockServerLogger;
import org.mockserver.mappers.FullHttpResponseToMockServerHttpResponse;
import org.mockserver.model.MediaType;
import org.slf4j.event.Level;

public class WebSocketClientHandler
extends SimpleChannelInboundHandler<Object> {
    private final WebSocketClient webSocketClient;
    private final WebSocketClientHandshaker handshaker;
    private final MockServerLogger mockServerLogger;
    private final String clientId;

    WebSocketClientHandler(MockServerLogger mockServerLogger, String clientId, InetSocketAddress serverAddress, String contextPath, WebSocketClient webSocketClient, boolean isSecure) throws URISyntaxException {
        this.mockServerLogger = mockServerLogger;
        this.clientId = clientId;
        this.handshaker = WebSocketClientHandshakerFactory.newHandshaker((URI)new URI((isSecure ? "wss" : "ws") + "://" + serverAddress.getHostName() + ":" + serverAddress.getPort() + this.cleanContextPath(contextPath) + "/_mockserver_callback_websocket"), (WebSocketVersion)WebSocketVersion.V13, null, (boolean)false, (HttpHeaders)new DefaultHttpHeaders().add("X-CLIENT-REGISTRATION-ID", (Object)clientId), (int)Integer.MAX_VALUE);
        this.webSocketClient = webSocketClient;
    }

    private String cleanContextPath(String contextPath) {
        if (StringUtils.isNotBlank((CharSequence)contextPath)) {
            return (!contextPath.startsWith("/") ? "/" : "") + contextPath;
        }
        return "";
    }

    public void channelActive(ChannelHandlerContext ctx) {
        this.handshaker.handshake(ctx.channel());
    }

    public void channelInactive(ChannelHandlerContext ctx) {
        if (MockServerLogger.isEnabled(Level.TRACE)) {
            this.mockServerLogger.logEvent(new LogEntry().setLogLevel(Level.TRACE).setMessageFormat("web socket client disconnected"));
        }
    }

    public void channelRead0(ChannelHandlerContext ctx, Object msg) {
        Channel ch = ctx.channel();
        if (MockServerLogger.isEnabled(Level.TRACE)) {
            this.mockServerLogger.logEvent(new LogEntry().setLogLevel(Level.TRACE).setMessageFormat("web socket client handshake handler received{}").setArguments(msg));
        }
        if (msg instanceof FullHttpResponse) {
            FullHttpResponse httpResponse = (FullHttpResponse)msg;
            CompletableFuture registrationFuture = (CompletableFuture)ch.attr(WebSocketClient.REGISTRATION_FUTURE).get();
            if (httpResponse.headers().contains((CharSequence)HttpHeaderNames.UPGRADE, (CharSequence)HttpHeaderValues.WEBSOCKET, true) && !this.handshaker.isHandshakeComplete()) {
                this.handshaker.finishHandshake(ch, httpResponse);
                registrationFuture.complete(this.clientId);
                if (MockServerLogger.isEnabled(Level.TRACE)) {
                    this.mockServerLogger.logEvent(new LogEntry().setLogLevel(Level.TRACE).setMessageFormat("web socket client " + this.clientId + " connected"));
                }
                if (MockServerLogger.isEnabled(Level.TRACE)) {
                    ch.pipeline().addFirst(new ChannelHandler[]{new LoggingHandler("WebSocketClient first -->")});
                }
            } else if (httpResponse.status().equals((Object)HttpResponseStatus.NOT_IMPLEMENTED)) {
                String message = this.readRequestBody(httpResponse);
                registrationFuture.completeExceptionally(new WebSocketException(message));
                if (MockServerLogger.isEnabled(Level.WARN)) {
                    this.mockServerLogger.logEvent(new LogEntry().setLogLevel(Level.WARN).setMessageFormat(message));
                }
            } else if (httpResponse.status().equals((Object)HttpResponseStatus.RESET_CONTENT)) {
                if (MockServerLogger.isEnabled(Level.TRACE)) {
                    this.mockServerLogger.logEvent(new LogEntry().setLogLevel(Level.TRACE).setMessageFormat("web socket client not required MockServer in same JVM as client"));
                }
                registrationFuture.complete(this.clientId);
            } else {
                registrationFuture.completeExceptionally(new WebSocketException("handshake failure unsupported message received " + new FullHttpResponseToMockServerHttpResponse(this.mockServerLogger).mapFullHttpResponseToMockServerResponse(httpResponse)));
                if (MockServerLogger.isEnabled(Level.WARN)) {
                    this.mockServerLogger.logEvent(new LogEntry().setLogLevel(Level.WARN).setMessageFormat("web socket client handshake handler received an unsupported FullHttpResponse message{}").setArguments(msg));
                }
            }
        } else if (msg instanceof WebSocketFrame) {
            WebSocketFrame frame = (WebSocketFrame)msg;
            if (frame instanceof TextWebSocketFrame) {
                this.webSocketClient.receivedTextWebSocketFrame((TextWebSocketFrame)frame);
            } else if (frame instanceof PingWebSocketFrame) {
                ctx.write((Object)new PongWebSocketFrame(frame.content().retain()));
            } else if (frame instanceof CloseWebSocketFrame) {
                if (MockServerLogger.isEnabled(Level.TRACE)) {
                    this.mockServerLogger.logEvent(new LogEntry().setLogLevel(Level.TRACE).setMessageFormat("web socket client received request to close"));
                }
                ch.close();
            } else if (MockServerLogger.isEnabled(Level.WARN)) {
                this.mockServerLogger.logEvent(new LogEntry().setLogLevel(Level.WARN).setMessageFormat("web socket client received an unsupported WebSocketFrame message{}").setArguments(msg));
            }
        } else if (MockServerLogger.isEnabled(Level.WARN)) {
            this.mockServerLogger.logEvent(new LogEntry().setLogLevel(Level.WARN).setMessageFormat("web socket client received a message of unknown type{}").setArguments(msg));
        }
    }

    private String readRequestBody(FullHttpResponse fullHttpResponse) {
        if (fullHttpResponse.content().readableBytes() > 0) {
            byte[] bodyBytes = new byte[fullHttpResponse.content().readableBytes()];
            fullHttpResponse.content().readBytes(bodyBytes);
            MediaType mediaType = MediaType.parse(fullHttpResponse.headers().get((CharSequence)HttpHeaderNames.CONTENT_TYPE));
            return new String(bodyBytes, mediaType.getCharsetOrDefault());
        }
        return "";
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        this.mockServerLogger.logEvent(new LogEntry().setLogLevel(Level.ERROR).setMessageFormat("web socket client caught exception").setThrowable(cause));
        CompletableFuture registrationFuture = (CompletableFuture)ctx.channel().attr(WebSocketClient.REGISTRATION_FUTURE).get();
        if (!registrationFuture.isDone()) {
            registrationFuture.completeExceptionally(cause);
        }
        ctx.close();
    }
}

