/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.cors;

import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpMethod;
import org.mockserver.configuration.ConfigurationProperties;
import org.mockserver.model.Headers;
import org.mockserver.model.HttpRequest;
import org.mockserver.model.HttpResponse;

public class CORSHeaders {
    private static final String ANY_ORIGIN = "*";
    private static final String NULL_ORIGIN = "null";
    private final String corsAllowHeaders;
    private final String corsAllowMethods;
    private final boolean corsAllowCredentials;
    private final String corsMaxAge;

    public CORSHeaders(String corsAllowHeaders, String corsAllowMethods, boolean corsAllowCredentials, int corsMaxAge) {
        this.corsAllowHeaders = corsAllowHeaders;
        this.corsAllowMethods = corsAllowMethods;
        this.corsAllowCredentials = corsAllowCredentials;
        this.corsMaxAge = "" + corsMaxAge;
    }

    public CORSHeaders() {
        this(ConfigurationProperties.corsAllowHeaders(), ConfigurationProperties.corsAllowMethods(), ConfigurationProperties.corsAllowCredentials(), ConfigurationProperties.corsMaxAgeInSeconds());
    }

    public static boolean isPreflightRequest(HttpRequest request) {
        boolean isPreflightRequest;
        Headers headers = request.getHeaders();
        boolean bl = isPreflightRequest = request.getMethod().getValue().equals(HttpMethod.OPTIONS.name()) && headers.containsEntry(HttpHeaderNames.ORIGIN.toString()) && headers.containsEntry(HttpHeaderNames.ACCESS_CONTROL_REQUEST_METHOD.toString());
        if (isPreflightRequest) {
            ConfigurationProperties.enableCORSForAPI(true);
        }
        return isPreflightRequest;
    }

    public void addCORSHeaders(HttpRequest request, HttpResponse response) {
        String origin = request.getFirstHeader(HttpHeaderNames.ORIGIN.toString());
        if (NULL_ORIGIN.equals(origin)) {
            this.setHeaderIfNotAlreadyExists(response, HttpHeaderNames.ACCESS_CONTROL_ALLOW_ORIGIN.toString(), NULL_ORIGIN);
        } else if (!origin.isEmpty() && this.corsAllowCredentials) {
            this.setHeaderIfNotAlreadyExists(response, HttpHeaderNames.ACCESS_CONTROL_ALLOW_ORIGIN.toString(), origin);
            this.setHeaderIfNotAlreadyExists(response, HttpHeaderNames.ACCESS_CONTROL_ALLOW_CREDENTIALS.toString(), "true");
        } else {
            this.setHeaderIfNotAlreadyExists(response, HttpHeaderNames.ACCESS_CONTROL_ALLOW_ORIGIN.toString(), ANY_ORIGIN);
        }
        this.setHeaderIfNotAlreadyExists(response, HttpHeaderNames.ACCESS_CONTROL_ALLOW_METHODS.toString(), this.corsAllowMethods);
        String allowHeaders = this.corsAllowHeaders;
        if (!request.getFirstHeader(HttpHeaderNames.ACCESS_CONTROL_REQUEST_HEADERS.toString()).isEmpty()) {
            allowHeaders = allowHeaders + ", " + request.getFirstHeader(HttpHeaderNames.ACCESS_CONTROL_REQUEST_HEADERS.toString());
        }
        this.setHeaderIfNotAlreadyExists(response, HttpHeaderNames.ACCESS_CONTROL_ALLOW_HEADERS.toString(), allowHeaders);
        this.setHeaderIfNotAlreadyExists(response, HttpHeaderNames.ACCESS_CONTROL_EXPOSE_HEADERS.toString(), allowHeaders);
        this.setHeaderIfNotAlreadyExists(response, HttpHeaderNames.ACCESS_CONTROL_MAX_AGE.toString(), this.corsMaxAge);
    }

    private void setHeaderIfNotAlreadyExists(HttpResponse response, String name, String value) {
        if (response.getFirstHeader(name).isEmpty()) {
            response.withHeader(name, value);
        }
    }
}

