/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.mappers;

import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.handler.codec.http.cookie.Cookie;
import io.netty.handler.codec.http.cookie.ServerCookieDecoder;
import java.util.Set;
import org.mockserver.codec.BodyDecoderEncoder;
import org.mockserver.codec.ExpandedParameterDecoder;
import org.mockserver.log.model.LogEntry;
import org.mockserver.logging.MockServerLogger;
import org.mockserver.model.Cookies;
import org.mockserver.model.Header;
import org.mockserver.model.Headers;
import org.mockserver.model.HttpRequest;
import org.mockserver.url.URLParser;
import org.slf4j.event.Level;

public class FullHttpRequestToMockServerHttpRequest {
    private final MockServerLogger mockServerLogger;
    private final BodyDecoderEncoder bodyDecoderEncoder;
    private final ExpandedParameterDecoder formParameterParser;
    private final boolean isSecure;
    private final Integer port;

    public FullHttpRequestToMockServerHttpRequest(MockServerLogger mockServerLogger, boolean isSecure, Integer port) {
        this.mockServerLogger = mockServerLogger;
        this.bodyDecoderEncoder = new BodyDecoderEncoder();
        this.formParameterParser = new ExpandedParameterDecoder(mockServerLogger);
        this.isSecure = isSecure;
        this.port = port;
    }

    public HttpRequest mapFullHttpRequestToMockServerRequest(FullHttpRequest fullHttpRequest) {
        HttpRequest httpRequest = new HttpRequest();
        try {
            if (fullHttpRequest != null) {
                if (fullHttpRequest.decoderResult().isFailure()) {
                    this.mockServerLogger.logEvent(new LogEntry().setLogLevel(Level.ERROR).setMessageFormat("exception decoding request " + fullHttpRequest.decoderResult().cause().getMessage()).setThrowable(fullHttpRequest.decoderResult().cause()));
                }
                this.setMethod(httpRequest, fullHttpRequest);
                this.setPath(httpRequest, fullHttpRequest);
                this.setQueryString(httpRequest, fullHttpRequest);
                this.setHeaders(httpRequest, fullHttpRequest);
                this.setCookies(httpRequest, fullHttpRequest);
                this.setBody(httpRequest, fullHttpRequest);
                this.setSocketAddress(httpRequest, this.isSecure, this.port, fullHttpRequest);
                httpRequest.withKeepAlive(HttpUtil.isKeepAlive((HttpMessage)fullHttpRequest));
                httpRequest.withSecure(this.isSecure);
            }
        }
        catch (Throwable throwable) {
            this.mockServerLogger.logEvent(new LogEntry().setLogLevel(Level.ERROR).setMessageFormat("exception decoding request{}").setArguments(fullHttpRequest).setThrowable(throwable));
        }
        return httpRequest;
    }

    private void setSocketAddress(HttpRequest httpRequest, boolean isSecure, Integer port, FullHttpRequest fullHttpRequest) {
        httpRequest.withSocketAddress(isSecure, fullHttpRequest.headers().get("host"), port);
    }

    private void setMethod(HttpRequest httpRequest, FullHttpRequest fullHttpResponse) {
        httpRequest.withMethod(fullHttpResponse.method().name());
    }

    private void setPath(HttpRequest httpRequest, FullHttpRequest fullHttpRequest) {
        httpRequest.withPath(URLParser.returnPath(fullHttpRequest.uri()));
    }

    private void setQueryString(HttpRequest httpRequest, FullHttpRequest fullHttpRequest) {
        if (fullHttpRequest.uri().contains("?")) {
            httpRequest.withQueryStringParameters(this.formParameterParser.retrieveQueryParameters(fullHttpRequest.uri(), true));
        }
    }

    private void setHeaders(HttpRequest httpRequest, FullHttpRequest fullHttpResponse) {
        Headers headers = new Headers(new Header[0]);
        HttpHeaders httpHeaders = fullHttpResponse.headers();
        for (String headerName : httpHeaders.names()) {
            headers.withEntry(headerName, httpHeaders.getAll(headerName));
        }
        httpRequest.withHeaders(headers);
    }

    private void setCookies(HttpRequest httpRequest, FullHttpRequest fullHttpResponse) {
        Cookies cookies = new Cookies(new org.mockserver.model.Cookie[0]);
        for (String cookieHeader : fullHttpResponse.headers().getAll((CharSequence)HttpHeaderNames.COOKIE)) {
            Set decodedCookies = ServerCookieDecoder.LAX.decode(cookieHeader);
            for (Cookie decodedCookie : decodedCookies) {
                cookies.withEntry(decodedCookie.name(), decodedCookie.value());
            }
        }
        httpRequest.withCookies(cookies);
    }

    private void setBody(HttpRequest httpRequest, FullHttpRequest fullHttpRequest) {
        httpRequest.withBody(this.bodyDecoderEncoder.byteBufToBody(fullHttpRequest.content(), fullHttpRequest.headers().get((CharSequence)HttpHeaderNames.CONTENT_TYPE)));
    }
}

