/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.persistence;

import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.ObjectWriter;
import java.io.FileOutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.locks.ReentrantLock;
import org.mockserver.configuration.ConfigurationProperties;
import org.mockserver.file.FileReader;
import org.mockserver.log.model.LogEntry;
import org.mockserver.logging.MockServerLogger;
import org.mockserver.mock.Expectation;
import org.mockserver.mock.RequestMatchers;
import org.mockserver.mock.listeners.MockServerMatcherListener;
import org.mockserver.mock.listeners.MockServerMatcherNotifier;
import org.mockserver.serialization.ObjectMapperFactory;
import org.mockserver.serialization.serializers.response.TimeToLiveSerializer;
import org.slf4j.event.Level;

public class ExpectationFileSystemPersistence
implements MockServerMatcherListener {
    private final ObjectWriter objectWriter;
    private final MockServerLogger mockServerLogger;
    private final Path filePath;
    private final boolean initializationPathMatchesPersistencePath;
    private final ReentrantLock fileWriteLock = new ReentrantLock();
    private final RequestMatchers requestMatchers;

    public ExpectationFileSystemPersistence(MockServerLogger mockServerLogger, RequestMatchers requestMatchers) {
        if (ConfigurationProperties.persistExpectations()) {
            this.mockServerLogger = mockServerLogger;
            this.requestMatchers = requestMatchers;
            this.objectWriter = ObjectMapperFactory.createObjectMapper(true, new JsonSerializer[]{new TimeToLiveSerializer()});
            this.filePath = Paths.get(ConfigurationProperties.persistedExpectationsPath(), new String[0]);
            try {
                Files.createFile(this.filePath, new FileAttribute[0]);
            }
            catch (FileAlreadyExistsException fileAlreadyExistsException) {
            }
            catch (Throwable throwable) {
                mockServerLogger.logEvent(new LogEntry().setLogLevel(Level.ERROR).setMessageFormat("exception creating persisted expectations file " + this.filePath).setThrowable(throwable));
            }
            this.initializationPathMatchesPersistencePath = FileReader.expandFilePathGlobs(ConfigurationProperties.initializationJsonPath()).contains(ConfigurationProperties.persistedExpectationsPath());
            requestMatchers.registerListener(this);
            if (MockServerLogger.isEnabled(Level.INFO)) {
                mockServerLogger.logEvent(new LogEntry().setLogLevel(Level.INFO).setMessageFormat("created expectation file system persistence for{}").setArguments(ConfigurationProperties.persistedExpectationsPath()));
            }
        } else {
            this.mockServerLogger = null;
            this.requestMatchers = null;
            this.objectWriter = null;
            this.filePath = null;
            this.initializationPathMatchesPersistencePath = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updated(RequestMatchers requestMatchers, MockServerMatcherNotifier.Cause cause) {
        if (cause == MockServerMatcherNotifier.Cause.API || cause.getType() == MockServerMatcherNotifier.Cause.Type.CLASS_INITIALISER || !this.initializationPathMatchesPersistencePath) {
            this.fileWriteLock.lock();
            try {
                try (FileOutputStream fileOutputStream = new FileOutputStream(this.filePath.toFile());
                     FileChannel fileChannel = fileOutputStream.getChannel();
                     FileLock fileLock = fileChannel.lock();){
                    if (fileLock != null) {
                        List<Expectation> expectations = requestMatchers.retrieveActiveExpectations(null);
                        if (MockServerLogger.isEnabled(Level.TRACE)) {
                            this.mockServerLogger.logEvent(new LogEntry().setLogLevel(Level.TRACE).setMessageFormat("persisting expectations{}to{}").setArguments(expectations, ConfigurationProperties.persistedExpectationsPath()));
                        } else if (MockServerLogger.isEnabled(Level.DEBUG)) {
                            this.mockServerLogger.logEvent(new LogEntry().setLogLevel(Level.DEBUG).setMessageFormat("persisting expectations to{}").setArguments(ConfigurationProperties.persistedExpectationsPath()));
                        }
                        byte[] data = this.serialize(expectations).getBytes(StandardCharsets.UTF_8);
                        ByteBuffer buffer = ByteBuffer.wrap(data);
                        buffer.put(data);
                        buffer.flip();
                        while (buffer.hasRemaining()) {
                            fileChannel.write(buffer);
                        }
                    }
                }
                catch (Throwable throwable) {
                    this.mockServerLogger.logEvent(new LogEntry().setLogLevel(Level.ERROR).setMessageFormat("exception while persisting expectations to " + this.filePath.toString()).setThrowable(throwable));
                }
            }
            finally {
                this.fileWriteLock.unlock();
            }
        }
    }

    public String serialize(List<Expectation> expectations) {
        return this.serialize(expectations.toArray(new Expectation[0]));
    }

    public String serialize(Expectation ... expectations) {
        try {
            if (expectations != null && expectations.length > 0) {
                return this.objectWriter.writeValueAsString((Object)expectations);
            }
            return "[]";
        }
        catch (Exception e) {
            this.mockServerLogger.logEvent(new LogEntry().setLogLevel(Level.ERROR).setMessageFormat("exception while serializing expectation to JSON with value " + Arrays.asList(expectations)).setThrowable(e));
            throw new RuntimeException("Exception while serializing expectation to JSON with value " + Arrays.asList(expectations), e);
        }
    }

    public void stop() {
        if (this.requestMatchers != null) {
            this.requestMatchers.unregisterListener(this);
        }
    }
}

