/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.responsewriter;

import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpResponseStatus;
import org.mockserver.configuration.ConfigurationProperties;
import org.mockserver.cors.CORSHeaders;
import org.mockserver.model.ConnectionOptions;
import org.mockserver.model.Header;
import org.mockserver.model.HttpRequest;
import org.mockserver.model.HttpResponse;
import org.mockserver.version.Version;

public abstract class ResponseWriter {
    private static final CORSHeaders CORS_HEADERS = new CORSHeaders();

    public void writeResponse(HttpRequest request, HttpResponseStatus responseStatus) {
        this.writeResponse(request, responseStatus, "", "application/json");
    }

    public void writeResponse(HttpRequest request, HttpResponseStatus responseStatus, String body, String contentType) {
        HttpResponse response = HttpResponse.response().withStatusCode(responseStatus.code()).withReasonPhrase(responseStatus.reasonPhrase()).withBody(body);
        if (body != null && !body.isEmpty()) {
            response.replaceHeader(Header.header(HttpHeaderNames.CONTENT_TYPE.toString(), contentType + "; charset=utf-8"));
        }
        this.writeResponse(request, response, true);
    }

    public void writeResponse(HttpRequest request, HttpResponse response, boolean apiResponse) {
        if (response == null) {
            response = HttpResponse.notFoundResponse();
        }
        if (ConfigurationProperties.enableCORSForAllResponses()) {
            CORS_HEADERS.addCORSHeaders(request, response);
        } else if (apiResponse && ConfigurationProperties.enableCORSForAPI()) {
            CORS_HEADERS.addCORSHeaders(request, response);
        }
        if (apiResponse) {
            response.withHeader("version", Version.getVersion());
            String path = request.getPath().getValue();
            if (!path.startsWith("/mockserver") && !path.equals(ConfigurationProperties.livenessHttpGetPath())) {
                response.withHeader("deprecated", "\"" + path + "\" is deprecated use \"" + "/mockserver" + path + "\" instead");
            }
        }
        this.sendResponse(request, this.addConnectionHeader(request, response));
    }

    public abstract void sendResponse(HttpRequest var1, HttpResponse var2);

    protected HttpResponse addConnectionHeader(HttpRequest request, HttpResponse response) {
        ConnectionOptions connectionOptions = response.getConnectionOptions();
        HttpResponse responseWithConnectionHeader = response.clone();
        if (connectionOptions != null && (connectionOptions.getSuppressConnectionHeader() != null || connectionOptions.getKeepAliveOverride() != null)) {
            if (!Boolean.TRUE.equals(connectionOptions.getSuppressConnectionHeader())) {
                if (Boolean.TRUE.equals(connectionOptions.getKeepAliveOverride())) {
                    responseWithConnectionHeader.replaceHeader(Header.header(HttpHeaderNames.CONNECTION.toString(), HttpHeaderValues.KEEP_ALIVE.toString()));
                } else {
                    responseWithConnectionHeader.replaceHeader(Header.header(HttpHeaderNames.CONNECTION.toString(), HttpHeaderValues.CLOSE.toString()));
                }
            }
        } else if (Boolean.TRUE.equals(request.isKeepAlive())) {
            responseWithConnectionHeader.replaceHeader(Header.header(HttpHeaderNames.CONNECTION.toString(), HttpHeaderValues.KEEP_ALIVE.toString()));
        } else {
            responseWithConnectionHeader.replaceHeader(Header.header(HttpHeaderNames.CONNECTION.toString(), HttpHeaderValues.CLOSE.toString()));
        }
        return responseWithConnectionHeader;
    }
}

