/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.socket.tls.bouncycastle;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.math.BigInteger;
import java.security.Key;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Security;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.security.interfaces.RSAPrivateKey;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Random;
import org.apache.commons.lang3.StringUtils;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.BasicConstraints;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.asn1.x509.KeyPurposeId;
import org.bouncycastle.asn1.x509.KeyUsage;
import org.bouncycastle.asn1.x509.SubjectKeyIdentifier;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.X509v3CertificateBuilder;
import org.bouncycastle.cert.bc.BcX509ExtensionUtils;
import org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import org.bouncycastle.cert.jcajce.JcaX509v3CertificateBuilder;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.openssl.jcajce.JcaPEMWriter;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;
import org.bouncycastle.util.IPAddress;
import org.mockserver.configuration.ConfigurationProperties;
import org.mockserver.file.FileReader;
import org.mockserver.log.model.LogEntry;
import org.mockserver.logging.MockServerLogger;
import org.mockserver.socket.tls.KeyAndCertificateFactory;
import org.mockserver.socket.tls.PEMToFile;
import org.mockserver.socket.tls.jdk.CertificateSigningRequest;
import org.slf4j.event.Level;

public class BCKeyAndCertificateFactory
implements KeyAndCertificateFactory {
    private static final String PROVIDER_NAME = "BC";
    private static final String SIGNATURE_ALGORITHM = "SHA256WithRSAEncryption";
    private final MockServerLogger mockServerLogger;
    private PrivateKey privateKey;
    private X509Certificate x509Certificate;
    private RSAPrivateKey certificateAuthorityPrivateKey;
    private X509Certificate certificateAuthorityX509Certificate;

    public BCKeyAndCertificateFactory(MockServerLogger mockServerLogger) {
        this.mockServerLogger = mockServerLogger;
    }

    @Override
    public void buildAndSaveCertificateAuthorityPrivateKeyAndX509Certificate() {
        if (this.dynamicCertificateAuthorityUpdate() && this.certificateAuthorityCertificateNotYetCreated()) {
            try {
                KeyPair caKeyPair = this.generateKeyPair(2048);
                this.saveAsPEMFile(this.createCACert(caKeyPair.getPublic(), caKeyPair.getPrivate()), this.certificateAuthorityX509CertificatePath(), "Certificate Authority X509 Certificate");
                this.saveAsPEMFile(caKeyPair.getPrivate(), this.certificateAuthorityPrivateKeyPath(), "Certificate Authority Private Key");
            }
            catch (Exception e) {
                this.mockServerLogger.logEvent(new LogEntry().setLogLevel(Level.ERROR).setMessageFormat("exception while generating certificate authority private key and X509 certificate").setThrowable(e));
            }
        }
    }

    private void saveAsPEMFile(Object object, String absolutePath, String type) throws IOException {
        if (MockServerLogger.isEnabled(Level.DEBUG)) {
            this.mockServerLogger.logEvent(new LogEntry().setLogLevel(Level.DEBUG).setMessageFormat("created dynamic " + type + " PEM file at{}").setArguments(absolutePath));
        }
        try (FileWriter pemfileWriter = new FileWriter(this.createFileIfNotExists(type, new File(absolutePath)));
             JcaPEMWriter jcaPEMWriter = new JcaPEMWriter((Writer)pemfileWriter);){
            jcaPEMWriter.writeObject(object);
        }
    }

    private File createFileIfNotExists(String type, File file) {
        if (!file.exists()) {
            try {
                BCKeyAndCertificateFactory.createParentDirs(file);
                if (!file.createNewFile()) {
                    this.mockServerLogger.logEvent(new LogEntry().setLogLevel(Level.ERROR).setMessageFormat("failed to create the file{}while attempting to save Certificate Authority " + type + " PEM file").setArguments(file.getAbsolutePath()));
                }
            }
            catch (Throwable throwable) {
                this.mockServerLogger.logEvent(new LogEntry().setLogLevel(Level.ERROR).setMessageFormat("failed to create the file{}while attempting to save Certificate Authority " + type + " PEM file").setArguments(file.getAbsolutePath()).setThrowable(throwable));
            }
        }
        return file;
    }

    public static void createParentDirs(File file) throws IOException {
        File parent = file.getCanonicalFile().getParentFile();
        if (parent == null) {
            return;
        }
        BCKeyAndCertificateFactory.createParentDirs(parent);
        if (!parent.exists()) {
            parent.mkdirs();
        }
        if (!parent.isDirectory()) {
            throw new IOException("Unable to create parent directories of " + file);
        }
    }

    private boolean dynamicCertificateAuthorityUpdate() {
        return ConfigurationProperties.dynamicallyCreateCertificateAuthorityCertificate() && StringUtils.isNotBlank((CharSequence)ConfigurationProperties.directoryToSaveDynamicSSLCertificate());
    }

    public boolean certificateAuthorityCertificateNotYetCreated() {
        return !PEMToFile.validX509PEMFileExists(this.certificateAuthorityX509CertificatePath());
    }

    private String certificateAuthorityPrivateKeyPath() {
        if (this.dynamicCertificateAuthorityUpdate()) {
            return new File(new File(ConfigurationProperties.directoryToSaveDynamicSSLCertificate()), "PKCS8CertificateAuthorityPrivateKey.pem").getAbsolutePath();
        }
        return ConfigurationProperties.certificateAuthorityPrivateKey();
    }

    private String certificateAuthorityX509CertificatePath() {
        if (this.dynamicCertificateAuthorityUpdate()) {
            return new File(new File(ConfigurationProperties.directoryToSaveDynamicSSLCertificate()), "CertificateAuthorityCertificate.pem").getAbsolutePath();
        }
        return ConfigurationProperties.certificateAuthorityCertificate();
    }

    private X509Certificate createCACert(PublicKey publicKey, PrivateKey privateKey) throws Exception {
        X500Name issuerName = new X500Name("CN=www.mockserver.com, O=MockServer, L=London, ST=England, C=UK");
        BigInteger serial = BigInteger.valueOf(new Random().nextInt(Integer.MAX_VALUE));
        JcaX509v3CertificateBuilder builder = new JcaX509v3CertificateBuilder(issuerName, serial, CertificateSigningRequest.NOT_BEFORE, CertificateSigningRequest.NOT_AFTER, issuerName, publicKey);
        builder.addExtension(Extension.subjectKeyIdentifier, false, (ASN1Encodable)this.createSubjectKeyIdentifier(publicKey));
        builder.addExtension(Extension.basicConstraints, true, (ASN1Encodable)new BasicConstraints(true));
        KeyUsage usage = new KeyUsage(182);
        builder.addExtension(Extension.keyUsage, false, (ASN1Encodable)usage);
        ASN1EncodableVector purposes = new ASN1EncodableVector();
        purposes.add((ASN1Encodable)KeyPurposeId.id_kp_serverAuth);
        purposes.add((ASN1Encodable)KeyPurposeId.id_kp_clientAuth);
        purposes.add((ASN1Encodable)KeyPurposeId.anyExtendedKeyUsage);
        builder.addExtension(Extension.extendedKeyUsage, false, (ASN1Encodable)new DERSequence(purposes));
        X509Certificate cert = this.signCertificate((X509v3CertificateBuilder)builder, privateKey);
        cert.checkValidity(new Date());
        cert.verify(publicKey);
        return cert;
    }

    private RSAPrivateKey certificateAuthorityPrivateKey() {
        if (this.certificateAuthorityPrivateKey == null) {
            if (this.dynamicCertificateAuthorityUpdate()) {
                this.buildAndSaveCertificateAuthorityPrivateKeyAndX509Certificate();
            }
            this.certificateAuthorityPrivateKey = PEMToFile.privateKeyFromPEMFile(this.certificateAuthorityPrivateKeyPath());
            if (MockServerLogger.isEnabled(Level.TRACE)) {
                this.mockServerLogger.logEvent(new LogEntry().setLogLevel(Level.TRACE).setMessageFormat("loaded dynamic CA private key from path{}PEM{}").setArguments(this.certificateAuthorityPrivateKeyPath(), this.certificateAuthorityPrivateKey));
            }
        }
        return this.certificateAuthorityPrivateKey;
    }

    @Override
    public X509Certificate certificateAuthorityX509Certificate() {
        if (this.certificateAuthorityX509Certificate == null) {
            if (this.dynamicCertificateAuthorityUpdate()) {
                this.buildAndSaveCertificateAuthorityPrivateKeyAndX509Certificate();
            }
            this.certificateAuthorityX509Certificate = PEMToFile.x509FromPEMFile(this.certificateAuthorityX509CertificatePath());
            if (MockServerLogger.isEnabled(Level.TRACE)) {
                this.mockServerLogger.logEvent(new LogEntry().setLogLevel(Level.TRACE).setMessageFormat("loaded dynamic CA X509 from path{}from PEM{}as{}").setArguments(this.certificateAuthorityX509CertificatePath(), FileReader.readFileFromClassPathOrPath(this.certificateAuthorityX509CertificatePath()), this.certificateAuthorityX509Certificate));
            }
        }
        return this.certificateAuthorityX509Certificate;
    }

    private boolean customPrivateKeyAndCertificateProvided() {
        return StringUtils.isBlank((CharSequence)ConfigurationProperties.privateKeyPath()) || StringUtils.isBlank((CharSequence)ConfigurationProperties.x509CertificatePath());
    }

    @Override
    public void buildAndSavePrivateKeyAndX509Certificate() {
        if (this.customPrivateKeyAndCertificateProvided()) {
            try {
                if (this.dynamicCertificateAuthorityUpdate()) {
                    this.buildAndSaveCertificateAuthorityPrivateKeyAndX509Certificate();
                }
                KeyPair keyPair = this.generateKeyPair(2048);
                this.privateKey = keyPair.getPrivate();
                this.x509Certificate = this.createCASignedCert(keyPair.getPublic(), this.certificateAuthorityX509Certificate(), this.certificateAuthorityPrivateKey(), this.certificateAuthorityX509Certificate().getPublicKey(), ConfigurationProperties.sslCertificateDomainName(), ConfigurationProperties.sslSubjectAlternativeNameDomains(), ConfigurationProperties.sslSubjectAlternativeNameIps());
                if (MockServerLogger.isEnabled(Level.TRACE)) {
                    this.mockServerLogger.logEvent(new LogEntry().setLogLevel(Level.TRACE).setMessageFormat("created new X509{}with SAN Domain Names{}and IPs{}").setArguments(this.x509Certificate(), Arrays.toString(ConfigurationProperties.sslSubjectAlternativeNameDomains()), Arrays.toString(ConfigurationProperties.sslSubjectAlternativeNameIps())));
                }
                if (ConfigurationProperties.preventCertificateDynamicUpdate()) {
                    this.saveAsPEMFile(this.x509Certificate, this.x509CertificatePath(), "X509 Certificate");
                    this.saveAsPEMFile(this.privateKey, this.privateKeyPath(), "Private Key");
                }
            }
            catch (Exception e) {
                this.mockServerLogger.logEvent(new LogEntry().setLogLevel(Level.ERROR).setMessageFormat("exception while generating private key and X509 certificate").setThrowable(e));
            }
        }
    }

    private X509Certificate createCASignedCert(PublicKey publicKey, X509Certificate certificateAuthorityCert, PrivateKey certificateAuthorityPrivateKey, PublicKey certificateAuthorityPublicKey, String domain, String[] subjectAlternativeNameDomains, String[] subjectAlternativeNameIps) throws Exception {
        X500Name issuer = new X509CertificateHolder(certificateAuthorityCert.getEncoded()).getSubject();
        X500Name subject = new X500Name("CN=" + domain + ", O=MockServer, L=London, ST=England, C=UK");
        BigInteger serial = BigInteger.valueOf(new Random().nextInt(Integer.MAX_VALUE));
        JcaX509v3CertificateBuilder builder = new JcaX509v3CertificateBuilder(issuer, serial, CertificateSigningRequest.NOT_BEFORE, CertificateSigningRequest.NOT_AFTER, subject, publicKey);
        builder.addExtension(Extension.subjectKeyIdentifier, false, (ASN1Encodable)this.createSubjectKeyIdentifier(publicKey));
        builder.addExtension(Extension.basicConstraints, false, (ASN1Encodable)new BasicConstraints(false));
        ArrayList<GeneralName> subjectAlternativeNames = new ArrayList<GeneralName>();
        if (subjectAlternativeNameDomains != null) {
            subjectAlternativeNames.add(new GeneralName(2, domain));
            for (String subjectAlternativeNameDomain : subjectAlternativeNameDomains) {
                subjectAlternativeNames.add(new GeneralName(2, subjectAlternativeNameDomain));
            }
        }
        if (subjectAlternativeNameIps != null) {
            for (String subjectAlternativeNameIp : subjectAlternativeNameIps) {
                if (!IPAddress.isValidIPv6WithNetmask((String)subjectAlternativeNameIp) && !IPAddress.isValidIPv6((String)subjectAlternativeNameIp) && !IPAddress.isValidIPv4WithNetmask((String)subjectAlternativeNameIp) && !IPAddress.isValidIPv4((String)subjectAlternativeNameIp)) continue;
                subjectAlternativeNames.add(new GeneralName(7, subjectAlternativeNameIp));
            }
        }
        if (subjectAlternativeNames.size() > 0) {
            DERSequence subjectAlternativeNamesExtension = new DERSequence(subjectAlternativeNames.toArray(new ASN1Encodable[0]));
            builder.addExtension(Extension.subjectAlternativeName, false, (ASN1Encodable)subjectAlternativeNamesExtension);
        }
        X509Certificate signedX509Certificate = this.signCertificate((X509v3CertificateBuilder)builder, certificateAuthorityPrivateKey);
        signedX509Certificate.checkValidity(new Date());
        signedX509Certificate.verify(certificateAuthorityPublicKey);
        return signedX509Certificate;
    }

    private X509Certificate signCertificate(X509v3CertificateBuilder certificateBuilder, PrivateKey privateKey) throws OperatorCreationException, CertificateException {
        ContentSigner signer = new JcaContentSignerBuilder(SIGNATURE_ALGORITHM).setProvider(PROVIDER_NAME).build(privateKey);
        return new JcaX509CertificateConverter().setProvider(PROVIDER_NAME).getCertificate(certificateBuilder.build(signer));
    }

    private KeyPair generateKeyPair(int keySize) throws Exception {
        KeyPairGenerator generator = KeyPairGenerator.getInstance("RSA", PROVIDER_NAME);
        generator.initialize(keySize, new SecureRandom());
        return generator.generateKeyPair();
    }

    private SubjectKeyIdentifier createSubjectKeyIdentifier(Key key) throws IOException {
        try (ASN1InputStream is = new ASN1InputStream((InputStream)new ByteArrayInputStream(key.getEncoded()));){
            ASN1Sequence seq = (ASN1Sequence)is.readObject();
            SubjectPublicKeyInfo info = SubjectPublicKeyInfo.getInstance((Object)seq);
            SubjectKeyIdentifier subjectKeyIdentifier = new BcX509ExtensionUtils().createSubjectKeyIdentifier(info);
            return subjectKeyIdentifier;
        }
    }

    @Override
    public boolean certificateNotYetCreated() {
        return this.customPrivateKeyAndCertificateProvided() && this.x509Certificate == null;
    }

    private String privateKeyPath() {
        return new File(new File(ConfigurationProperties.directoryToSaveDynamicSSLCertificate()), "PKCS8PrivateKey.pem").getAbsolutePath();
    }

    private String x509CertificatePath() {
        return new File(new File(ConfigurationProperties.directoryToSaveDynamicSSLCertificate()), "Certificate.pem").getAbsolutePath();
    }

    @Override
    public PrivateKey privateKey() {
        if (this.customPrivateKeyAndCertificateProvided()) {
            return this.privateKey;
        }
        return PEMToFile.privateKeyFromPEMFile(ConfigurationProperties.privateKeyPath());
    }

    @Override
    public X509Certificate x509Certificate() {
        if (this.customPrivateKeyAndCertificateProvided()) {
            return this.x509Certificate;
        }
        return PEMToFile.x509FromPEMFile(ConfigurationProperties.x509CertificatePath());
    }

    static {
        Security.addProvider((Provider)new BouncyCastleProvider());
    }
}

