/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.socket.tls.jdk;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import org.apache.commons.lang3.StringUtils;
import org.mockserver.configuration.ConfigurationProperties;
import org.mockserver.file.FileReader;
import org.mockserver.log.model.LogEntry;
import org.mockserver.logging.MockServerLogger;
import org.mockserver.socket.tls.KeyAndCertificateFactory;
import org.mockserver.socket.tls.PEMToFile;
import org.mockserver.socket.tls.jdk.CertificateSigningRequest;
import org.mockserver.socket.tls.jdk.X509AndPrivateKey;
import org.mockserver.socket.tls.jdk.X509Generator;
import org.slf4j.event.Level;

public class JDKKeyAndCertificateFactory
implements KeyAndCertificateFactory {
    private final MockServerLogger mockServerLogger;
    private final X509Generator x509Generator;
    private X509AndPrivateKey x509AndPrivateKey;
    private String certificateAuthorityPrivateKey;
    private X509Certificate certificateAuthorityX509Certificate;

    public JDKKeyAndCertificateFactory(MockServerLogger mockServerLogger) {
        this.mockServerLogger = mockServerLogger;
        this.x509Generator = new X509Generator(new MockServerLogger());
    }

    @Override
    public void buildAndSaveCertificateAuthorityPrivateKeyAndX509Certificate() {
        if (this.dynamicallyUpdateCertificateAuthority() && this.certificateAuthorityCertificateNotYetCreated()) {
            try {
                X509AndPrivateKey certificateAuthorityX509AndPrivateKey = this.x509Generator.generateRootX509AndPrivateKey(new CertificateSigningRequest().setKeyPairAlgorithm("RSA").setSigningAlgorithm("SHA256withRSA").setCommonName("www.mockserver.com").setKeyPairSize(2048));
                this.saveAsPEMFile(certificateAuthorityX509AndPrivateKey.getCert(), this.certificateAuthorityX509CertificatePath(), "Certificate Authority X509 Certificate");
                this.saveAsPEMFile(certificateAuthorityX509AndPrivateKey.getPrivateKey(), this.certificateAuthorityPrivateKeyPath(), "Certificate Authority Private Key");
            }
            catch (Exception e) {
                this.mockServerLogger.logEvent(new LogEntry().setLogLevel(Level.ERROR).setMessageFormat("exception while generating certificate authority private key and X509 certificate").setThrowable(e));
            }
        }
    }

    private void saveAsPEMFile(String pem, String absolutePath, String type) throws IOException {
        if (MockServerLogger.isEnabled(Level.DEBUG)) {
            this.mockServerLogger.logEvent(new LogEntry().setLogLevel(Level.DEBUG).setMessageFormat("created dynamic " + type + " PEM file at{}").setArguments(absolutePath));
        }
        try (FileWriter fileWriter = new FileWriter(this.createFileIfNotExists(type, new File(absolutePath)));){
            fileWriter.write(pem);
        }
    }

    private File createFileIfNotExists(String type, File file) {
        if (!file.exists()) {
            try {
                JDKKeyAndCertificateFactory.createParentDirs(file);
                if (!file.createNewFile()) {
                    this.mockServerLogger.logEvent(new LogEntry().setLogLevel(Level.ERROR).setMessageFormat("failed to create the file{}while attempting to save Certificate Authority " + type + " PEM file").setArguments(file.getAbsolutePath()));
                }
            }
            catch (Throwable throwable) {
                this.mockServerLogger.logEvent(new LogEntry().setLogLevel(Level.ERROR).setMessageFormat("failed to create the file{}while attempting to save Certificate Authority " + type + " PEM file").setArguments(file.getAbsolutePath()).setThrowable(throwable));
            }
        }
        return file;
    }

    public static void createParentDirs(File file) throws IOException {
        File parent = file.getCanonicalFile().getParentFile();
        if (parent == null) {
            return;
        }
        JDKKeyAndCertificateFactory.createParentDirs(parent);
        if (!parent.exists()) {
            parent.mkdirs();
        }
        if (!parent.isDirectory()) {
            throw new IOException("Unable to create parent directories of " + file);
        }
    }

    private boolean dynamicallyUpdateCertificateAuthority() {
        return ConfigurationProperties.dynamicallyCreateCertificateAuthorityCertificate() && StringUtils.isNotBlank((CharSequence)ConfigurationProperties.directoryToSaveDynamicSSLCertificate());
    }

    public boolean certificateAuthorityCertificateNotYetCreated() {
        return !PEMToFile.validX509PEMFileExists(this.certificateAuthorityX509CertificatePath());
    }

    private String certificateAuthorityPrivateKeyPath() {
        if (this.dynamicallyUpdateCertificateAuthority()) {
            return new File(new File(ConfigurationProperties.directoryToSaveDynamicSSLCertificate()), "PKCS8CertificateAuthorityPrivateKey.pem").getAbsolutePath();
        }
        return ConfigurationProperties.certificateAuthorityPrivateKey();
    }

    private String certificateAuthorityX509CertificatePath() {
        if (this.dynamicallyUpdateCertificateAuthority()) {
            return new File(new File(ConfigurationProperties.directoryToSaveDynamicSSLCertificate()), "CertificateAuthorityCertificate.pem").getAbsolutePath();
        }
        return ConfigurationProperties.certificateAuthorityCertificate();
    }

    private String certificateAuthorityPrivateKey() {
        if (this.certificateAuthorityPrivateKey == null) {
            if (this.dynamicallyUpdateCertificateAuthority()) {
                this.buildAndSaveCertificateAuthorityPrivateKeyAndX509Certificate();
            }
            this.certificateAuthorityPrivateKey = FileReader.readFileFromClassPathOrPath(this.certificateAuthorityPrivateKeyPath());
            if (MockServerLogger.isEnabled(Level.TRACE)) {
                this.mockServerLogger.logEvent(new LogEntry().setLogLevel(Level.TRACE).setMessageFormat("loaded dynamic CA private key from path{}PEM{}").setArguments(this.certificateAuthorityPrivateKeyPath(), this.certificateAuthorityPrivateKey));
            }
        }
        return this.certificateAuthorityPrivateKey;
    }

    @Override
    public X509Certificate certificateAuthorityX509Certificate() {
        if (this.certificateAuthorityX509Certificate == null) {
            if (this.dynamicallyUpdateCertificateAuthority()) {
                this.buildAndSaveCertificateAuthorityPrivateKeyAndX509Certificate();
            }
            this.certificateAuthorityX509Certificate = PEMToFile.x509FromPEMFile(this.certificateAuthorityX509CertificatePath());
            if (MockServerLogger.isEnabled(Level.TRACE)) {
                this.mockServerLogger.logEvent(new LogEntry().setLogLevel(Level.TRACE).setMessageFormat("loaded dynamic CA X509 from path{}from PEM{}as{}").setArguments(this.certificateAuthorityX509CertificatePath(), FileReader.readFileFromClassPathOrPath(this.certificateAuthorityX509CertificatePath()), this.certificateAuthorityX509Certificate));
            }
        }
        return this.certificateAuthorityX509Certificate;
    }

    private boolean customPrivateKeyAndCertificateProvided() {
        return StringUtils.isBlank((CharSequence)ConfigurationProperties.privateKeyPath()) || StringUtils.isBlank((CharSequence)ConfigurationProperties.x509CertificatePath());
    }

    @Override
    public void buildAndSavePrivateKeyAndX509Certificate() {
        if (this.customPrivateKeyAndCertificateProvided()) {
            try {
                if (this.dynamicallyUpdateCertificateAuthority()) {
                    this.buildAndSaveCertificateAuthorityPrivateKeyAndX509Certificate();
                }
                String caPrivateKey = this.certificateAuthorityPrivateKey();
                X509Certificate certificateAuthorityX509Certificate = this.certificateAuthorityX509Certificate();
                this.x509AndPrivateKey = this.x509Generator.generateLeafX509AndPrivateKey(new CertificateSigningRequest().setKeyPairAlgorithm("RSA").setSigningAlgorithm("SHA256withRSA").setCommonName("www.mockserver.com").setCommonName(ConfigurationProperties.sslCertificateDomainName()).addSubjectAlternativeNames(ConfigurationProperties.sslSubjectAlternativeNameDomains()).addSubjectAlternativeNames(ConfigurationProperties.sslSubjectAlternativeNameIps()).setKeyPairSize(2048), certificateAuthorityX509Certificate.getIssuerDN().getName(), caPrivateKey, certificateAuthorityX509Certificate);
                if (MockServerLogger.isEnabled(Level.TRACE)) {
                    this.mockServerLogger.logEvent(new LogEntry().setLogLevel(Level.TRACE).setMessageFormat("created new X509{}with SAN Domain Names{}and IPs{}").setArguments(this.x509Certificate(), Arrays.toString(ConfigurationProperties.sslSubjectAlternativeNameDomains()), Arrays.toString(ConfigurationProperties.sslSubjectAlternativeNameIps())));
                }
                if (ConfigurationProperties.preventCertificateDynamicUpdate()) {
                    this.saveAsPEMFile(this.x509AndPrivateKey.getCert(), this.x509CertificatePath(), "X509 Certificate");
                    this.saveAsPEMFile(this.x509AndPrivateKey.getPrivateKey(), this.privateKeyPath(), "Private Key");
                }
            }
            catch (Exception e) {
                this.mockServerLogger.logEvent(new LogEntry().setLogLevel(Level.ERROR).setMessageFormat("exception while generating private key and X509 certificate").setThrowable(e));
            }
        }
    }

    @Override
    public boolean certificateNotYetCreated() {
        return this.customPrivateKeyAndCertificateProvided() && this.x509AndPrivateKey == null;
    }

    private String privateKeyPath() {
        return new File(new File(ConfigurationProperties.directoryToSaveDynamicSSLCertificate()), "PKCS8PrivateKey.pem").getAbsolutePath();
    }

    private String x509CertificatePath() {
        return new File(new File(ConfigurationProperties.directoryToSaveDynamicSSLCertificate()), "Certificate.pem").getAbsolutePath();
    }

    @Override
    public PrivateKey privateKey() {
        if (this.customPrivateKeyAndCertificateProvided()) {
            return PEMToFile.privateKeyFromPEM(this.x509AndPrivateKey.getPrivateKey());
        }
        return PEMToFile.privateKeyFromPEMFile(ConfigurationProperties.privateKeyPath());
    }

    @Override
    public X509Certificate x509Certificate() {
        if (this.customPrivateKeyAndCertificateProvided()) {
            return PEMToFile.x509FromPEM(this.x509AndPrivateKey.getCert());
        }
        return PEMToFile.x509FromPEMFile(ConfigurationProperties.x509CertificatePath());
    }
}

