/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.templates;

import javax.script.ScriptEngineManager;
import org.apache.commons.lang3.NotImplementedException;
import org.mockserver.logging.MockServerLogger;
import org.mockserver.model.HttpRequest;
import org.mockserver.model.HttpResponse;
import org.mockserver.serialization.model.HttpResponseDTO;
import org.mockserver.templates.engine.javascript.JavaScriptTemplateEngine;
import org.mockserver.templates.engine.mustache.MustacheTemplateEngine;
import org.mockserver.templates.engine.velocity.VelocityTemplateEngine;

public class ResponseTemplateTester {
    private static final MockServerLogger MOCK_SERVER_LOGGER = new MockServerLogger(ResponseTemplateTester.class);

    public static HttpResponse testMustacheTemplate(String template, HttpRequest request) {
        return (HttpResponse)new MustacheTemplateEngine(MOCK_SERVER_LOGGER).executeTemplate(template, request, HttpResponseDTO.class);
    }

    public static HttpResponse testVelocityTemplate(String template, HttpRequest request) {
        return (HttpResponse)new VelocityTemplateEngine(MOCK_SERVER_LOGGER).executeTemplate(template, request, HttpResponseDTO.class);
    }

    public static HttpResponse testJavaScriptTemplate(String template, HttpRequest request) {
        if (new ScriptEngineManager().getEngineByName("nashorn") != null) {
            return (HttpResponse)new JavaScriptTemplateEngine(MOCK_SERVER_LOGGER).executeTemplate(template, request, HttpResponseDTO.class);
        }
        throw new NotImplementedException("Nashorn is not available on this JVM so JavaScript templates are not supported");
    }
}

