/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.mappers;

import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import java.util.ArrayList;
import java.util.Enumeration;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.mockserver.codec.BodyServletDecoderEncoder;
import org.mockserver.codec.ExpandedParameterDecoder;
import org.mockserver.configuration.Configuration;
import org.mockserver.logging.MockServerLogger;
import org.mockserver.model.Cookies;
import org.mockserver.model.Header;
import org.mockserver.model.Headers;
import org.mockserver.model.HttpRequest;

public class HttpServletRequestToMockServerHttpRequestDecoder {
    private final BodyServletDecoderEncoder bodyDecoderEncoder;
    private final ExpandedParameterDecoder formParameterParser;

    public HttpServletRequestToMockServerHttpRequestDecoder(Configuration configuration, MockServerLogger mockServerLogger) {
        this.bodyDecoderEncoder = new BodyServletDecoderEncoder(mockServerLogger);
        this.formParameterParser = new ExpandedParameterDecoder(configuration, mockServerLogger);
    }

    public HttpRequest mapHttpServletRequestToMockServerRequest(HttpServletRequest httpServletRequest) {
        HttpRequest request = new HttpRequest();
        this.setMethod(request, httpServletRequest);
        this.setPath(request, httpServletRequest);
        this.setQueryString(request, httpServletRequest);
        this.setBody(request, httpServletRequest);
        this.setHeaders(request, httpServletRequest);
        this.setCookies(request, httpServletRequest);
        this.setSocketAddress(request, httpServletRequest);
        request.withKeepAlive(this.isKeepAlive(httpServletRequest));
        request.withSecure(httpServletRequest.isSecure());
        request.withRemoteAddress(httpServletRequest.getRemoteHost());
        return request;
    }

    private void setMethod(HttpRequest httpRequest, HttpServletRequest httpServletRequest) {
        httpRequest.withMethod(httpServletRequest.getMethod());
    }

    private void setPath(HttpRequest httpRequest, HttpServletRequest httpServletRequest) {
        httpRequest.withPath(httpServletRequest.getPathInfo() != null && httpServletRequest.getContextPath() != null ? httpServletRequest.getPathInfo() : httpServletRequest.getRequestURI());
    }

    private void setQueryString(HttpRequest httpRequest, HttpServletRequest httpServletRequest) {
        if (StringUtils.isNotBlank((CharSequence)httpServletRequest.getQueryString())) {
            httpRequest.withQueryStringParameters(this.formParameterParser.retrieveQueryParameters(httpServletRequest.getQueryString(), false));
        }
    }

    private void setBody(HttpRequest httpRequest, HttpServletRequest httpServletRequest) {
        httpRequest.withBody(this.bodyDecoderEncoder.servletRequestToBody(httpServletRequest));
    }

    private void setHeaders(HttpRequest httpRequest, HttpServletRequest httpServletRequest) {
        Enumeration headerNames = httpServletRequest.getHeaderNames();
        if (headerNames.hasMoreElements()) {
            Headers headers = new Headers(new Header[0]);
            while (headerNames.hasMoreElements()) {
                String headerName = (String)headerNames.nextElement();
                ArrayList<String> mappedHeaderValues = new ArrayList<String>();
                Enumeration headerValues = httpServletRequest.getHeaders(headerName);
                while (headerValues.hasMoreElements()) {
                    mappedHeaderValues.add((String)headerValues.nextElement());
                }
                headers.withEntry(headerName, mappedHeaderValues);
            }
            httpRequest.withHeaders(headers);
        }
    }

    private void setCookies(HttpRequest httpRequest, HttpServletRequest httpServletRequest) {
        Cookie[] httpServletRequestCookies = httpServletRequest.getCookies();
        if (httpServletRequestCookies != null && httpServletRequestCookies.length > 0) {
            Cookies cookies = new Cookies(new org.mockserver.model.Cookie[0]);
            for (Cookie cookie : httpServletRequestCookies) {
                cookies.withEntry(new org.mockserver.model.Cookie(cookie.getName(), cookie.getValue()));
            }
            httpRequest.withCookies(cookies);
        }
    }

    private void setSocketAddress(HttpRequest httpRequest, HttpServletRequest httpServletRequest) {
        httpRequest.withSocketAddress(httpServletRequest.isSecure(), httpServletRequest.getHeader("host"), httpServletRequest.getLocalPort());
    }

    public boolean isKeepAlive(HttpServletRequest httpServletRequest) {
        String connection = httpServletRequest.getHeader(HttpHeaderNames.CONNECTION.toString());
        if (HttpHeaderValues.CLOSE.contentEqualsIgnoreCase((CharSequence)connection)) {
            return false;
        }
        if (httpServletRequest.getProtocol().equals("HTTP/1.1")) {
            return !HttpHeaderValues.CLOSE.contentEqualsIgnoreCase((CharSequence)connection);
        }
        return HttpHeaderValues.KEEP_ALIVE.contentEqualsIgnoreCase((CharSequence)connection);
    }
}

