/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.matchers;

import java.util.Objects;
import org.mockserver.character.Character;
import org.mockserver.configuration.Configuration;
import org.mockserver.logging.MockServerLogger;
import org.mockserver.matchers.HttpRequestMatcher;
import org.mockserver.matchers.HttpRequestPropertiesMatcher;
import org.mockserver.matchers.MatchDifference;
import org.mockserver.matchers.NotMatcher;
import org.mockserver.mock.Expectation;
import org.mockserver.mock.listeners.MockServerMatcherNotifier;
import org.mockserver.model.RequestDefinition;

public abstract class AbstractHttpRequestMatcher
extends NotMatcher<RequestDefinition>
implements HttpRequestMatcher {
    protected static final String REQUEST_DID_NOT_MATCH = "request:{}didn't match";
    protected static final String REQUEST_MATCHER = " request matcher";
    protected static final String EXPECTATION = " expectation";
    protected static final String BECAUSE = ":{}because:{}";
    protected static final String REQUEST_DID_MATCH = "request:{}matched request:{}";
    protected static final String EXPECTATION_DID_MATCH = "request:{}matched expectation:{}";
    protected static final String DID_NOT_MATCH = " didn't match";
    protected static final String MATCHED = " matched";
    protected static final String COLON_NEW_LINES = ": " + Character.NEW_LINE + Character.NEW_LINE;
    protected final Configuration configuration;
    protected final MockServerLogger mockServerLogger;
    private int hashCode;
    private boolean isBlank = false;
    private boolean responseInProgress = false;
    private MockServerMatcherNotifier.Cause source;
    protected boolean controlPlaneMatcher;
    protected Expectation expectation;
    protected String didNotMatchRequestBecause = "request:{}didn't match request matcher:{}because:{}";
    protected String didNotMatchExpectationBecause = "request:{}didn't match expectation:{}because:{}";
    protected String didNotMatchExpectationWithoutBecause = "request:{}didn't match expectation";

    protected AbstractHttpRequestMatcher(Configuration configuration, MockServerLogger mockServerLogger) {
        this.configuration = configuration;
        this.mockServerLogger = mockServerLogger;
    }

    public void setDescription(String description) {
        this.didNotMatchRequestBecause = REQUEST_DID_NOT_MATCH + description + REQUEST_MATCHER + BECAUSE;
        this.didNotMatchExpectationBecause = REQUEST_DID_NOT_MATCH + description + EXPECTATION + BECAUSE;
        this.didNotMatchExpectationWithoutBecause = REQUEST_DID_NOT_MATCH + description + EXPECTATION;
    }

    @Override
    public boolean update(Expectation expectation) {
        if (this.expectation != null && this.expectation.equals(expectation)) {
            return false;
        }
        this.controlPlaneMatcher = false;
        this.expectation = expectation;
        this.hashCode = 0;
        this.isBlank = expectation.getHttpRequest() == null;
        this.apply(expectation.getHttpRequest());
        return true;
    }

    @Override
    public boolean update(RequestDefinition requestDefinition) {
        this.controlPlaneMatcher = true;
        this.expectation = null;
        this.hashCode = 0;
        this.isBlank = requestDefinition == null;
        return this.apply(requestDefinition);
    }

    public void setControlPlaneMatcher(boolean controlPlaneMatcher) {
        this.controlPlaneMatcher = controlPlaneMatcher;
    }

    abstract boolean apply(RequestDefinition var1);

    @Override
    public boolean matches(RequestDefinition requestDefinition) {
        return this.matches((MatchDifference)null, requestDefinition);
    }

    @Override
    public abstract boolean matches(MatchDifference var1, RequestDefinition var2);

    @Override
    public Expectation getExpectation() {
        return this.expectation;
    }

    @Override
    public boolean isResponseInProgress() {
        return this.responseInProgress;
    }

    @Override
    public HttpRequestMatcher setResponseInProgress(boolean responseInProgress) {
        this.responseInProgress = responseInProgress;
        return this;
    }

    @Override
    public MockServerMatcherNotifier.Cause getSource() {
        return this.source;
    }

    @Override
    public AbstractHttpRequestMatcher withSource(MockServerMatcherNotifier.Cause source) {
        this.source = source;
        return this;
    }

    @Override
    public boolean isBlank() {
        return this.isBlank;
    }

    @Override
    public boolean isActive() {
        return this.expectation == null || this.expectation.isActive();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (this.hashCode() != o.hashCode()) {
            return false;
        }
        HttpRequestPropertiesMatcher that = (HttpRequestPropertiesMatcher)o;
        return Objects.equals(this.expectation, that.expectation);
    }

    @Override
    public int hashCode() {
        if (this.hashCode == 0) {
            this.hashCode = Objects.hash(this.expectation);
        }
        return this.hashCode;
    }
}

