/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.serialization;

import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import org.apache.commons.lang3.StringUtils;
import org.mockserver.character.Character;
import org.mockserver.formatting.StringFormatter;
import org.mockserver.log.model.LogEntry;
import org.mockserver.logging.MockServerLogger;
import org.mockserver.serialization.ObjectMapperFactory;
import org.mockserver.serialization.Serializer;
import org.mockserver.serialization.model.VerificationDTO;
import org.mockserver.validator.jsonschema.JsonSchemaValidator;
import org.mockserver.validator.jsonschema.JsonSchemaVerificationValidator;
import org.mockserver.verify.Verification;
import org.slf4j.event.Level;

public class VerificationSerializer
implements Serializer<Verification> {
    private final MockServerLogger mockServerLogger;
    private ObjectWriter objectWriter = ObjectMapperFactory.createObjectMapper(true, false, new JsonSerializer[0]);
    private ObjectMapper objectMapper = ObjectMapperFactory.createObjectMapper();
    private JsonSchemaVerificationValidator verificationValidator;

    public VerificationSerializer(MockServerLogger mockServerLogger) {
        this.mockServerLogger = mockServerLogger;
    }

    private JsonSchemaVerificationValidator getValidator() {
        if (this.verificationValidator == null) {
            this.verificationValidator = JsonSchemaVerificationValidator.jsonSchemaVerificationValidator(this.mockServerLogger);
        }
        return this.verificationValidator;
    }

    @Override
    public String serialize(Verification verification) {
        try {
            return this.objectWriter.writeValueAsString((Object)new VerificationDTO(verification));
        }
        catch (Exception e) {
            this.mockServerLogger.logEvent(new LogEntry().setLogLevel(Level.ERROR).setMessageFormat("exception while serializing verification to JSON with value " + verification).setThrowable(e));
            throw new RuntimeException("Exception while serializing verification to JSON with value " + verification, e);
        }
    }

    @Override
    public Verification deserialize(String jsonVerification) {
        if (StringUtils.isBlank((CharSequence)jsonVerification)) {
            throw new IllegalArgumentException("1 error:" + Character.NEW_LINE + " - a verification is required but value was \"" + jsonVerification + "\"" + Character.NEW_LINE + Character.NEW_LINE + JsonSchemaValidator.OPEN_API_SPECIFICATION_URL);
        }
        String validationErrors = this.getValidator().isValid(jsonVerification);
        if (validationErrors.isEmpty()) {
            Verification verification = null;
            try {
                VerificationDTO verificationDTO = (VerificationDTO)this.objectMapper.readValue(jsonVerification, VerificationDTO.class);
                if (verificationDTO != null) {
                    verification = verificationDTO.buildObject();
                }
            }
            catch (Throwable throwable) {
                this.mockServerLogger.logEvent(new LogEntry().setLogLevel(Level.ERROR).setMessageFormat("exception while parsing{}for Verification " + throwable.getMessage()).setArguments(jsonVerification).setThrowable(throwable));
                throw new IllegalArgumentException("exception while parsing [" + jsonVerification + "] for Verification", throwable);
            }
            return verification;
        }
        throw new IllegalArgumentException(StringUtils.removeEndIgnoreCase((String)StringFormatter.formatLogMessage("incorrect verification json format for:{}schema validation errors:{}", jsonVerification, validationErrors), (String)"\n"));
    }

    @Override
    public Class<Verification> supportsType() {
        return Verification.class;
    }
}

