/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.authentication.jwt;

import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.JOSEObjectType;
import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jose.jwk.source.JWKSource;
import com.nimbusds.jose.proc.BadJOSEException;
import com.nimbusds.jose.proc.DefaultJOSEObjectTypeVerifier;
import com.nimbusds.jose.proc.JOSEObjectTypeVerifier;
import com.nimbusds.jose.proc.JWSKeySelector;
import com.nimbusds.jose.proc.JWSVerificationKeySelector;
import com.nimbusds.jose.proc.SecurityContext;
import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.jwt.proc.ConfigurableJWTProcessor;
import com.nimbusds.jwt.proc.DefaultJWTClaimsVerifier;
import com.nimbusds.jwt.proc.DefaultJWTProcessor;
import com.nimbusds.jwt.proc.JWTClaimsSetVerifier;
import java.text.ParseException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.mockserver.authentication.AuthenticationException;

public class JWTValidator {
    private final JWKSource<SecurityContext> jwkSource;
    private final ConfigurableJWTProcessor<SecurityContext> jwtProcessor;
    private String expectedAudience;
    private Map<String, String> matchingClaims;
    private Set<String> requiredClaims;
    private static final Set<JWSAlgorithm> JWS_ALGORITHMS = new HashSet<JWSAlgorithm>(Arrays.asList(JWSAlgorithm.HS256, JWSAlgorithm.HS384, JWSAlgorithm.HS512, JWSAlgorithm.RS256, JWSAlgorithm.RS384, JWSAlgorithm.RS512, JWSAlgorithm.ES256, JWSAlgorithm.ES256K, JWSAlgorithm.ES384, JWSAlgorithm.ES512, JWSAlgorithm.PS256, JWSAlgorithm.PS384, JWSAlgorithm.PS512, JWSAlgorithm.EdDSA));

    public JWTValidator(JWKSource<SecurityContext> jwkSource) {
        this.jwkSource = jwkSource;
        this.jwtProcessor = new DefaultJWTProcessor();
        this.jwtProcessor.setJWSTypeVerifier((JOSEObjectTypeVerifier)new DefaultJOSEObjectTypeVerifier(new JOSEObjectType[]{null, new JOSEObjectType("at+jwt"), JOSEObjectType.JOSE, JOSEObjectType.JOSE_JSON, JOSEObjectType.JWT}));
    }

    public JWTValidator withExpectedAudience(String expectedAudience) {
        this.expectedAudience = StringUtils.isNotBlank((CharSequence)expectedAudience) ? expectedAudience : null;
        return this;
    }

    public JWTValidator withMatchingClaims(Map<String, String> matchingClaims) {
        this.matchingClaims = !matchingClaims.isEmpty() ? matchingClaims : null;
        return this;
    }

    public JWTValidator withRequiredClaims(Set<String> requiredClaims) {
        this.requiredClaims = !requiredClaims.isEmpty() ? requiredClaims : null;
        return this;
    }

    public JWTClaimsSet validate(String jwt) {
        try {
            this.jwtProcessor.setJWSKeySelector((JWSKeySelector)new JWSVerificationKeySelector(JWS_ALGORITHMS, this.jwkSource));
            JWTClaimsSet.Builder matchingClaimsBuilder = new JWTClaimsSet.Builder();
            if (this.matchingClaims != null) {
                this.matchingClaims.forEach((arg_0, arg_1) -> ((JWTClaimsSet.Builder)matchingClaimsBuilder).claim(arg_0, arg_1));
            }
            this.jwtProcessor.setJWTClaimsSetVerifier((JWTClaimsSetVerifier)new DefaultJWTClaimsVerifier(this.expectedAudience, matchingClaimsBuilder.build(), this.requiredClaims));
            return this.jwtProcessor.process(jwt, null);
        }
        catch (JOSEException | BadJOSEException | ParseException exception) {
            throw new AuthenticationException(exception.getMessage(), exception);
        }
    }
}

