/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.file;

import com.google.common.io.ByteStreams;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;

public class FileReader {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String readFileFromClassPathOrPath(String filePath) {
        try (InputStream inputStream = FileReader.openStreamToFileFromClassPathOrPath(filePath);){
            String string = new String(ByteStreams.toByteArray((InputStream)inputStream), StandardCharsets.UTF_8.name());
            return string;
        }
        catch (IOException ioe) {
            throw new RuntimeException("Exception while loading \"" + filePath + "\"", ioe);
        }
    }

    public static InputStream openStreamToFileFromClassPathOrPath(String filename) throws FileNotFoundException {
        InputStream inputStream = FileReader.class.getClassLoader().getResourceAsStream(filename);
        if (inputStream == null) {
            inputStream = new FileInputStream(filename);
        }
        return inputStream;
    }

    public static Reader openReaderToFileFromClassPathOrPath(String filename) throws FileNotFoundException {
        return new InputStreamReader(FileReader.openStreamToFileFromClassPathOrPath(filename));
    }
}

