/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.matchers;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.regex.PatternSyntaxException;
import org.apache.commons.lang3.StringUtils;
import org.mockserver.log.model.LogEntry;
import org.mockserver.logging.MockServerLogger;
import org.mockserver.matchers.BodyMatcher;
import org.mockserver.matchers.MatchDifference;
import org.mockserver.model.NottableSchemaString;
import org.mockserver.model.NottableString;
import org.slf4j.event.Level;

public class RegexStringMatcher
extends BodyMatcher<NottableString> {
    private static final String[] EXCLUDED_FIELDS = new String[]{"mockServerLogger"};
    private final MockServerLogger mockServerLogger;
    private final NottableString matcher;
    private final boolean controlPlaneMatcher;

    public RegexStringMatcher(MockServerLogger mockServerLogger, boolean controlPlaneMatcher) {
        this.mockServerLogger = mockServerLogger;
        this.controlPlaneMatcher = controlPlaneMatcher;
        this.matcher = null;
    }

    RegexStringMatcher(MockServerLogger mockServerLogger, NottableString matcher, boolean controlPlaneMatcher) {
        this.mockServerLogger = mockServerLogger;
        this.controlPlaneMatcher = controlPlaneMatcher;
        this.matcher = matcher;
    }

    public boolean matches(String matched) {
        return this.matches((MatchDifference)null, NottableString.string(matched));
    }

    @Override
    public boolean matches(MatchDifference context, NottableString matched) {
        boolean result = this.matcher == null || this.matches(this.mockServerLogger, context, this.matcher, matched);
        return this.not != result;
    }

    public boolean matches(NottableString matcher, NottableString matched) {
        return this.matches(this.mockServerLogger, null, matcher, matched);
    }

    public boolean matches(MockServerLogger mockServerLogger, MatchDifference context, NottableString matcher, NottableString matched) {
        if (matcher instanceof NottableSchemaString && matched instanceof NottableSchemaString) {
            return this.controlPlaneMatcher && this.matchesByNottedStrings(mockServerLogger, context, matcher, matched);
        }
        if (matcher instanceof NottableSchemaString) {
            return this.matchesBySchemas(mockServerLogger, context, (NottableSchemaString)matcher, matched);
        }
        if (matched instanceof NottableSchemaString) {
            return this.controlPlaneMatcher && this.matchesBySchemas(mockServerLogger, context, (NottableSchemaString)matched, matcher);
        }
        return this.matchesByNottedStrings(mockServerLogger, context, matcher, matched);
    }

    private boolean matchesByNottedStrings(MockServerLogger mockServerLogger, MatchDifference context, NottableString matcher, NottableString matched) {
        if (matcher.isNot() && matched.isNot()) {
            return this.matchesByStrings(mockServerLogger, context, matcher, matched);
        }
        return (matcher.isNot() || matched.isNot()) ^ this.matchesByStrings(mockServerLogger, context, matcher, matched);
    }

    private boolean matchesBySchemas(MockServerLogger mockServerLogger, MatchDifference context, NottableSchemaString schema, NottableString string) {
        return string.isNot() != schema.matches(mockServerLogger, context, string.getValue());
    }

    private boolean matchesByStrings(MockServerLogger mockServerLogger, MatchDifference context, NottableString matcher, NottableString matched) {
        block13: {
            String matchedValue;
            if (matcher == null) {
                return true;
            }
            String matcherValue = matcher.getValue();
            if (StringUtils.isBlank((CharSequence)matcherValue)) {
                return true;
            }
            if (matched != null && (matchedValue = matched.getValue()) != null) {
                block12: {
                    if (matchedValue.equals(matcherValue) || matchedValue.equalsIgnoreCase(matcherValue)) {
                        return true;
                    }
                    try {
                        if (matcher.matches(matchedValue)) {
                            return true;
                        }
                    }
                    catch (PatternSyntaxException pse) {
                        if (!MockServerLogger.isEnabled(Level.DEBUG) || mockServerLogger == null) break block12;
                        mockServerLogger.logEvent(new LogEntry().setLogLevel(Level.DEBUG).setMessageFormat("error while matching regex [" + matcher + "] for string [" + matched + "] " + pse.getMessage()).setThrowable(pse));
                    }
                }
                try {
                    if (this.controlPlaneMatcher && matched.matches(matcherValue)) {
                        return true;
                    }
                    if (MockServerLogger.isEnabled(Level.DEBUG) && matched.matches(matcherValue) && mockServerLogger != null) {
                        mockServerLogger.logEvent(new LogEntry().setLogLevel(Level.DEBUG).setMessageFormat("matcher{}would match{}if matcher was used for control plane").setArguments(matcher, matched));
                    }
                }
                catch (PatternSyntaxException pse) {
                    if (!this.controlPlaneMatcher || !MockServerLogger.isEnabled(Level.DEBUG) || mockServerLogger == null) break block13;
                    mockServerLogger.logEvent(new LogEntry().setLogLevel(Level.DEBUG).setMessageFormat("error while matching regex [" + matched + "] for string [" + matcher + "] " + pse.getMessage()).setThrowable(pse));
                }
            }
        }
        if (context != null) {
            context.addDifference(mockServerLogger, "string or regex match failed expected:{}found:{}", matcher, matched);
        }
        return false;
    }

    @Override
    public boolean isBlank() {
        return this.matcher == null || StringUtils.isBlank((CharSequence)this.matcher.getValue());
    }

    @Override
    @JsonIgnore
    protected String[] fieldsExcludedFromEqualsAndHashCode() {
        return EXCLUDED_FIELDS;
    }
}

