/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.metrics;

import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.util.concurrent.GenericFutureListener;
import io.prometheus.client.CollectorRegistry;
import io.prometheus.client.exporter.common.TextFormat;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Enumeration;
import org.mockserver.configuration.Configuration;
import org.mockserver.model.HttpRequest;
import org.mockserver.model.HttpResponse;

public class MetricsHandler {
    private final Boolean metricsEnabled;

    public MetricsHandler(Configuration configuration) {
        this.metricsEnabled = configuration.metricsEnabled();
    }

    public void renderMetrics(ChannelHandlerContext ctx, HttpRequest request) throws Exception {
        HttpResponse response = HttpResponse.notFoundResponse();
        if (this.metricsEnabled.booleanValue()) {
            StringWriter stringWriter = new StringWriter();
            String contentType = TextFormat.chooseContentType((String)request.getFirstHeader("Accept"));
            TextFormat.writeFormat((String)contentType, (Writer)stringWriter, (Enumeration)CollectorRegistry.defaultRegistry.metricFamilySamples());
            String content = stringWriter.toString();
            response = HttpResponse.response().withHeader(HttpHeaderNames.CONTENT_TYPE.toString(), contentType).withHeader(HttpHeaderNames.CONTENT_LENGTH.toString(), String.valueOf(content.getBytes().length)).withBody(content);
        }
        if (!request.isKeepAlive().booleanValue()) {
            ctx.writeAndFlush((Object)response).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
        } else {
            ctx.writeAndFlush((Object)response);
        }
    }
}

