/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.mock;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.mockserver.closurecallback.websocketregistry.WebSocketClientRegistry;
import org.mockserver.collections.CircularHashMap;
import org.mockserver.collections.CircularPriorityQueue;
import org.mockserver.configuration.Configuration;
import org.mockserver.log.model.LogEntry;
import org.mockserver.logging.MockServerLogger;
import org.mockserver.matchers.HttpRequestMatcher;
import org.mockserver.matchers.MatchDifference;
import org.mockserver.matchers.MatcherBuilder;
import org.mockserver.metrics.Metrics;
import org.mockserver.mock.Expectation;
import org.mockserver.mock.SortableExpectationId;
import org.mockserver.mock.listeners.MockServerMatcherNotifier;
import org.mockserver.model.Action;
import org.mockserver.model.ExpectationId;
import org.mockserver.model.HttpObjectCallback;
import org.mockserver.model.HttpRequest;
import org.mockserver.model.RequestDefinition;
import org.mockserver.scheduler.Scheduler;
import org.mockserver.uuid.UUIDService;
import org.slf4j.event.Level;

public class RequestMatchers
extends MockServerMatcherNotifier {
    final CircularPriorityQueue<String, HttpRequestMatcher, SortableExpectationId> httpRequestMatchers;
    final CircularHashMap<String, RequestDefinition> expectationRequestDefinitions;
    private final MockServerLogger mockServerLogger;
    private final Configuration configuration;
    private final Scheduler scheduler;
    private WebSocketClientRegistry webSocketClientRegistry;
    private MatcherBuilder matcherBuilder;
    private Metrics metrics;

    public RequestMatchers(Configuration configuration, MockServerLogger mockServerLogger, Scheduler scheduler, WebSocketClientRegistry webSocketClientRegistry) {
        super(scheduler);
        this.configuration = configuration;
        this.scheduler = scheduler;
        this.matcherBuilder = new MatcherBuilder(configuration, mockServerLogger);
        this.mockServerLogger = mockServerLogger;
        this.webSocketClientRegistry = webSocketClientRegistry;
        this.metrics = new Metrics(configuration);
        this.httpRequestMatchers = new CircularPriorityQueue<String, HttpRequestMatcher, SortableExpectationId>(configuration.maxExpectations(), SortableExpectationId.EXPECTATION_SORTABLE_PRIORITY_COMPARATOR, httpRequestMatcher -> httpRequestMatcher.getExpectation() != null ? httpRequestMatcher.getExpectation().getSortableId() : SortableExpectationId.NULL, httpRequestMatcher -> httpRequestMatcher.getExpectation() != null ? httpRequestMatcher.getExpectation().getId() : "");
        this.expectationRequestDefinitions = new CircularHashMap(configuration.maxExpectations());
        if (MockServerLogger.isEnabled(Level.TRACE) && mockServerLogger != null) {
            mockServerLogger.logEvent(new LogEntry().setLogLevel(Level.TRACE).setMessageFormat("expectation circular priority queue created, with size " + configuration.maxExpectations()));
        }
    }

    public Expectation add(Expectation expectation, MockServerMatcherNotifier.Cause cause) {
        Expectation upsertedExpectation = null;
        if (expectation != null) {
            this.expectationRequestDefinitions.put(expectation.getId(), expectation.getHttpRequest());
            upsertedExpectation = this.httpRequestMatchers.getByKey(expectation.getId()).map(httpRequestMatcher -> {
                if (httpRequestMatcher.getExpectation() != null && httpRequestMatcher.getExpectation().getAction() != null) {
                    this.metrics.decrement(httpRequestMatcher.getExpectation().getAction().getType());
                }
                if (httpRequestMatcher.getExpectation() != null) {
                    expectation.withCreated(httpRequestMatcher.getExpectation().getCreated());
                }
                this.httpRequestMatchers.removePriorityKey((HttpRequestMatcher)httpRequestMatcher);
                if (httpRequestMatcher.update(expectation)) {
                    this.httpRequestMatchers.addPriorityKey((HttpRequestMatcher)httpRequestMatcher);
                    if (MockServerLogger.isEnabled(Level.INFO)) {
                        this.mockServerLogger.logEvent(new LogEntry().setType(LogEntry.LogMessageType.UPDATED_EXPECTATION).setLogLevel(Level.INFO).setHttpRequest(expectation.getHttpRequest()).setMessageFormat("updated expectation:{}with id:{}").setArguments(expectation.clone(), expectation.getId()));
                    }
                    if (expectation.getAction() != null) {
                        this.metrics.increment(expectation.getAction().getType());
                    }
                } else {
                    this.httpRequestMatchers.addPriorityKey((HttpRequestMatcher)httpRequestMatcher);
                }
                return httpRequestMatcher;
            }).orElseGet(() -> this.addPrioritisedExpectation(expectation, cause)).getExpectation();
            this.notifyListeners(this, cause);
        }
        return upsertedExpectation;
    }

    public void update(Expectation[] expectations, MockServerMatcherNotifier.Cause cause) {
        AtomicInteger numberOfChanges = new AtomicInteger(0);
        if (expectations != null) {
            Map<String, HttpRequestMatcher> httpRequestMatchersByKey = this.httpRequestMatchers.keyMap();
            Set<String> existingKeysForCause = httpRequestMatchersByKey.entrySet().stream().filter(entry -> ((HttpRequestMatcher)entry.getValue()).getSource().equals(cause)).map(Map.Entry::getKey).collect(Collectors.toSet());
            HashSet addedIds = new HashSet();
            Arrays.stream(expectations).forEach(expectation -> {
                if (!addedIds.contains(expectation.getId())) {
                    addedIds.add(expectation.getId());
                    this.expectationRequestDefinitions.put(expectation.getId(), expectation.getHttpRequest());
                    existingKeysForCause.remove(expectation.getId());
                    if (httpRequestMatchersByKey.containsKey(expectation.getId())) {
                        HttpRequestMatcher httpRequestMatcher = (HttpRequestMatcher)httpRequestMatchersByKey.get(expectation.getId());
                        httpRequestMatcher.withSource(cause);
                        if (httpRequestMatcher.getExpectation() != null && httpRequestMatcher.getExpectation().getAction() != null) {
                            this.metrics.decrement(httpRequestMatcher.getExpectation().getAction().getType());
                        }
                        if (httpRequestMatcher.getExpectation() != null) {
                            expectation.withCreated(httpRequestMatcher.getExpectation().getCreated());
                        }
                        this.httpRequestMatchers.removePriorityKey(httpRequestMatcher);
                        if (httpRequestMatcher.update((Expectation)expectation)) {
                            this.httpRequestMatchers.addPriorityKey(httpRequestMatcher);
                            numberOfChanges.getAndIncrement();
                            if (MockServerLogger.isEnabled(Level.INFO)) {
                                this.mockServerLogger.logEvent(new LogEntry().setType(LogEntry.LogMessageType.UPDATED_EXPECTATION).setLogLevel(Level.INFO).setHttpRequest(expectation.getHttpRequest()).setMessageFormat("updated expectation:{}with id:{}").setArguments(expectation.clone(), expectation.getId()));
                            }
                            if (expectation.getAction() != null) {
                                this.metrics.increment(expectation.getAction().getType());
                            }
                        } else {
                            this.httpRequestMatchers.addPriorityKey(httpRequestMatcher);
                        }
                    } else {
                        this.addPrioritisedExpectation((Expectation)expectation, cause);
                        numberOfChanges.getAndIncrement();
                    }
                }
            });
            existingKeysForCause.forEach(key -> {
                numberOfChanges.getAndIncrement();
                HttpRequestMatcher httpRequestMatcher = (HttpRequestMatcher)httpRequestMatchersByKey.get(key);
                this.removeHttpRequestMatcher(httpRequestMatcher, cause, false, UUIDService.getUUID());
                if (httpRequestMatcher.getExpectation() != null && httpRequestMatcher.getExpectation().getAction() != null) {
                    this.metrics.decrement(httpRequestMatcher.getExpectation().getAction().getType());
                }
            });
            if (numberOfChanges.get() > 0) {
                this.notifyListeners(this, cause);
            }
        }
    }

    private HttpRequestMatcher addPrioritisedExpectation(Expectation expectation, MockServerMatcherNotifier.Cause cause) {
        HttpRequestMatcher httpRequestMatcher = this.matcherBuilder.transformsToMatcher(expectation);
        this.httpRequestMatchers.add(httpRequestMatcher);
        httpRequestMatcher.withSource(cause);
        if (expectation.getAction() != null) {
            this.metrics.increment(expectation.getAction().getType());
        }
        if (MockServerLogger.isEnabled(Level.INFO)) {
            this.mockServerLogger.logEvent(new LogEntry().setType(LogEntry.LogMessageType.CREATED_EXPECTATION).setLogLevel(Level.INFO).setHttpRequest(expectation.getHttpRequest()).setMessageFormat("creating expectation:{}with id:{}").setArguments(expectation.clone(), expectation.getId()));
        }
        return httpRequestMatcher;
    }

    public int size() {
        return this.httpRequestMatchers.size();
    }

    public void reset(MockServerMatcherNotifier.Cause cause) {
        this.httpRequestMatchers.stream().forEach(httpRequestMatcher -> this.removeHttpRequestMatcher((HttpRequestMatcher)httpRequestMatcher, cause, false, UUIDService.getUUID()));
        this.expectationRequestDefinitions.clear();
        Metrics.clearActionMetrics();
        Metrics.clearRequestAndExpectationMetrics();
        this.notifyListeners(this, cause);
    }

    public void reset() {
        this.reset(MockServerMatcherNotifier.Cause.API);
    }

    public Expectation firstMatchingExpectation(HttpRequest httpRequest) {
        Optional<Expectation> first = this.getHttpRequestMatchersCopy().map(httpRequestMatcher -> {
            Expectation matchingExpectation = null;
            boolean remainingMatchesDecremented = false;
            if (httpRequestMatcher.matches(MockServerLogger.isEnabled(Level.DEBUG) ? new MatchDifference(this.configuration.detailedMatchFailures(), httpRequest) : null, httpRequest)) {
                matchingExpectation = httpRequestMatcher.getExpectation();
                httpRequestMatcher.setResponseInProgress(true);
                if (matchingExpectation.decrementRemainingMatches()) {
                    remainingMatchesDecremented = true;
                }
            } else if (!httpRequestMatcher.isResponseInProgress() && !httpRequestMatcher.isActive()) {
                this.scheduler.submit(() -> this.removeHttpRequestMatcher((HttpRequestMatcher)httpRequestMatcher, UUIDService.getUUID()));
            }
            if (remainingMatchesDecremented) {
                this.notifyListeners(this, MockServerMatcherNotifier.Cause.API);
            }
            return matchingExpectation;
        }).filter(Objects::nonNull).findFirst();
        if (this.configuration.metricsEnabled().booleanValue()) {
            if (!first.isPresent() || first.get().getAction() == null) {
                this.metrics.increment(Metrics.Name.EXPECTATIONS_NOT_MATCHED_COUNT);
            } else if (first.get().getAction().getType().direction == Action.Direction.FORWARD) {
                this.metrics.increment(Metrics.Name.FORWARD_EXPECTATIONS_MATCHED_COUNT);
            } else {
                this.metrics.increment(Metrics.Name.RESPONSE_EXPECTATIONS_MATCHED_COUNT);
            }
        }
        return first.orElse(null);
    }

    public void clear(RequestDefinition requestDefinition) {
        if (requestDefinition != null) {
            HttpRequestMatcher clearHttpRequestMatcher = this.matcherBuilder.transformsToMatcher(requestDefinition);
            this.getHttpRequestMatchersCopy().forEach(httpRequestMatcher -> {
                RequestDefinition request = httpRequestMatcher.getExpectation().getHttpRequest();
                if (StringUtils.isNotBlank((CharSequence)requestDefinition.getLogCorrelationId())) {
                    request = request.shallowClone().withLogCorrelationId(requestDefinition.getLogCorrelationId());
                }
                if (clearHttpRequestMatcher.matches(request)) {
                    this.removeHttpRequestMatcher((HttpRequestMatcher)httpRequestMatcher, requestDefinition.getLogCorrelationId());
                }
            });
            if (MockServerLogger.isEnabled(Level.INFO)) {
                this.mockServerLogger.logEvent(new LogEntry().setType(LogEntry.LogMessageType.CLEARED).setLogLevel(Level.INFO).setCorrelationId(requestDefinition.getLogCorrelationId()).setHttpRequest(requestDefinition).setMessageFormat("cleared expectations that match:{}").setArguments(requestDefinition));
            }
        } else {
            this.reset();
        }
    }

    public void clear(ExpectationId expectationId, String logCorrelationId) {
        if (expectationId != null) {
            this.httpRequestMatchers.getByKey(expectationId.getId()).ifPresent(httpRequestMatcher -> this.removeHttpRequestMatcher((HttpRequestMatcher)httpRequestMatcher, logCorrelationId));
            if (MockServerLogger.isEnabled(Level.INFO)) {
                this.mockServerLogger.logEvent(new LogEntry().setType(LogEntry.LogMessageType.CLEARED).setLogLevel(Level.INFO).setCorrelationId(logCorrelationId).setMessageFormat("cleared expectations that have id:{}").setArguments(expectationId.getId()));
            }
        } else {
            this.reset();
        }
    }

    Expectation postProcess(Expectation expectation) {
        if (expectation != null) {
            this.getHttpRequestMatchersCopy().filter(httpRequestMatcher -> httpRequestMatcher.getExpectation() == expectation).findFirst().ifPresent(httpRequestMatcher -> {
                if (!expectation.isActive()) {
                    this.removeHttpRequestMatcher((HttpRequestMatcher)httpRequestMatcher, UUIDService.getUUID());
                }
                httpRequestMatcher.setResponseInProgress(false);
            });
        }
        return expectation;
    }

    private void removeHttpRequestMatcher(HttpRequestMatcher httpRequestMatcher, String logCorrelationId) {
        this.removeHttpRequestMatcher(httpRequestMatcher, MockServerMatcherNotifier.Cause.API, true, logCorrelationId);
    }

    private void removeHttpRequestMatcher(HttpRequestMatcher httpRequestMatcher, MockServerMatcherNotifier.Cause cause, boolean notifyAndUpdateMetrics, String logCorrelationId) {
        if (this.httpRequestMatchers.remove(httpRequestMatcher)) {
            if (httpRequestMatcher.getExpectation() != null && MockServerLogger.isEnabled(Level.INFO)) {
                Expectation expectation = httpRequestMatcher.getExpectation().clone();
                this.mockServerLogger.logEvent(new LogEntry().setType(LogEntry.LogMessageType.REMOVED_EXPECTATION).setLogLevel(Level.INFO).setCorrelationId(logCorrelationId).setHttpRequest(httpRequestMatcher.getExpectation().getHttpRequest()).setMessageFormat("removed expectation:{}with id:{}").setArguments(expectation, expectation.getId()));
            }
            if (httpRequestMatcher.getExpectation() != null) {
                Action action = httpRequestMatcher.getExpectation().getAction();
                if (action instanceof HttpObjectCallback) {
                    this.webSocketClientRegistry.unregisterClient(((HttpObjectCallback)action).getClientId());
                }
                if (notifyAndUpdateMetrics && action != null) {
                    this.metrics.decrement(action.getType());
                }
            }
            if (notifyAndUpdateMetrics) {
                this.notifyListeners(this, cause);
            }
        }
    }

    public Stream<RequestDefinition> retrieveRequestDefinitions(List<ExpectationId> expectationIds) {
        return expectationIds.stream().map(expectationId -> {
            if (StringUtils.isBlank((CharSequence)expectationId.getId())) {
                throw new IllegalArgumentException("No expectation id specified found \"" + expectationId.getId() + "\"");
            }
            if (this.expectationRequestDefinitions.containsKey(expectationId.getId())) {
                return (RequestDefinition)this.expectationRequestDefinitions.get(expectationId.getId());
            }
            throw new IllegalArgumentException("No expectation found with id " + expectationId.getId());
        }).filter(Objects::nonNull);
    }

    public List<Expectation> retrieveActiveExpectations(RequestDefinition requestDefinition) {
        if (requestDefinition == null) {
            return this.httpRequestMatchers.stream().map(HttpRequestMatcher::getExpectation).collect(Collectors.toList());
        }
        ArrayList<Expectation> expectations = new ArrayList<Expectation>();
        HttpRequestMatcher requestMatcher = this.matcherBuilder.transformsToMatcher(requestDefinition);
        this.getHttpRequestMatchersCopy().forEach(httpRequestMatcher -> {
            if (requestMatcher.matches(httpRequestMatcher.getExpectation().getHttpRequest())) {
                expectations.add(httpRequestMatcher.getExpectation());
            }
        });
        return expectations;
    }

    public List<HttpRequestMatcher> retrieveRequestMatchers(RequestDefinition requestDefinition) {
        if (requestDefinition == null) {
            return this.httpRequestMatchers.stream().collect(Collectors.toList());
        }
        ArrayList<HttpRequestMatcher> httpRequestMatchers = new ArrayList<HttpRequestMatcher>();
        HttpRequestMatcher requestMatcher = this.matcherBuilder.transformsToMatcher(requestDefinition);
        this.getHttpRequestMatchersCopy().forEach(httpRequestMatcher -> {
            if (requestMatcher.matches(httpRequestMatcher.getExpectation().getHttpRequest())) {
                httpRequestMatchers.add((HttpRequestMatcher)httpRequestMatcher);
            }
        });
        return httpRequestMatchers;
    }

    public boolean isEmpty() {
        return this.httpRequestMatchers.isEmpty();
    }

    @Override
    protected void notifyListeners(RequestMatchers notifier, MockServerMatcherNotifier.Cause cause) {
        super.notifyListeners(notifier, cause);
    }

    private Stream<HttpRequestMatcher> getHttpRequestMatchersCopy() {
        return this.httpRequestMatchers.stream();
    }
}

