/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.model;

import java.util.Arrays;
import java.util.Collection;
import org.mockserver.model.KeyToMultiValue;
import org.mockserver.model.NottableOptionalString;
import org.mockserver.model.NottableSchemaString;
import org.mockserver.model.NottableString;

public class Header
extends KeyToMultiValue {
    public Header(String name, String ... value) {
        super(name, value);
    }

    public Header(NottableString name, NottableString ... value) {
        super(name, value);
    }

    public Header(NottableString name, String ... value) {
        super(name, value);
    }

    public Header(String name, Collection<String> value) {
        super(name, value);
    }

    public Header(NottableString name, Collection<NottableString> value) {
        super(name, value);
    }

    public static Header header(String name, int value) {
        return new Header(name, String.valueOf(value));
    }

    public static Header header(String name, String ... value) {
        return new Header(name, value);
    }

    public static Header header(NottableString name, NottableString ... value) {
        return new Header(name, value);
    }

    public static Header header(String name, Collection<String> value) {
        return new Header(name, value);
    }

    public static Header header(NottableString name, Collection<NottableString> value) {
        return new Header(name, value);
    }

    public static Header schemaHeader(String name, String ... values) {
        if (values.length == 0) {
            values = new String[]{".*"};
        }
        return new Header(NottableString.string(name), (NottableString[])Arrays.stream(values).map(NottableSchemaString::schemaString).toArray(NottableString[]::new));
    }

    public static Header optionalHeader(String name, String ... values) {
        if (values.length == 0) {
            values = new String[]{".*"};
        }
        return new Header((NottableString)NottableOptionalString.optional(name), (NottableString[])Arrays.stream(values).map(NottableString::string).toArray(NottableString[]::new));
    }
}

