/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.socket.tls;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.DecoderException;
import io.netty.handler.ssl.AbstractSniHandler;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslHandler;
import io.netty.util.AttributeKey;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.concurrent.Future;
import io.netty.util.internal.PlatformDependent;
import java.security.cert.Certificate;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
import org.apache.commons.lang3.StringUtils;
import org.mockserver.configuration.Configuration;
import org.mockserver.log.model.LogEntry;
import org.mockserver.logging.MockServerLogger;
import org.mockserver.model.Protocol;
import org.mockserver.socket.tls.NettySslContextFactory;
import org.slf4j.event.Level;

public class SniHandler
extends AbstractSniHandler<SslContext> {
    private static final AttributeKey<SSLEngine> UPSTREAM_SSL_ENGINE = AttributeKey.valueOf((String)"UPSTREAM_SSL_ENGINE");
    private static final AttributeKey<SslHandler> UPSTREAM_SSL_HANDLER = AttributeKey.valueOf((String)"UPSTREAM_SSL_HANDLER");
    private static final AttributeKey<Certificate[]> UPSTREAM_CLIENT_CERTIFICATES = AttributeKey.valueOf((String)"UPSTREAM_CLIENT_CERTIFICATES");
    private static final AttributeKey<Protocol> NEGOTIATED_APPLICATION_PROTOCOL = AttributeKey.valueOf((String)"NEGOTIATED_APPLICATION_PROTOCOL");
    private final Configuration configuration;
    private final NettySslContextFactory nettySslContextFactory;

    public SniHandler(Configuration configuration, NettySslContextFactory nettySslContextFactory) {
        this.configuration = configuration;
        this.nettySslContextFactory = nettySslContextFactory;
    }

    protected Future<SslContext> lookup(ChannelHandlerContext ctx, String hostname) {
        if (StringUtils.isNotBlank((CharSequence)hostname)) {
            this.configuration.addSubjectAlternativeName(hostname);
        }
        return ctx.executor().newSucceededFuture((Object)this.nettySslContextFactory.createServerSslContext());
    }

    protected void onLookupComplete(ChannelHandlerContext ctx, String hostname, Future<SslContext> sslContextFuture) {
        if (!sslContextFuture.isSuccess()) {
            Throwable cause = sslContextFuture.cause();
            if (cause instanceof Error) {
                throw (Error)cause;
            }
            throw new DecoderException("Failed to get the SslContext for " + hostname, cause);
        }
        try {
            this.replaceHandler(ctx, sslContextFuture);
        }
        catch (Throwable cause) {
            PlatformDependent.throwException((Throwable)cause);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void replaceHandler(ChannelHandlerContext ctx, Future<SslContext> sslContext) {
        SslHandler sslHandler = null;
        try {
            sslHandler = ((SslContext)sslContext.getNow()).newHandler(ctx.alloc());
            ctx.channel().attr(UPSTREAM_SSL_ENGINE).set((Object)sslHandler.engine());
            ctx.channel().attr(UPSTREAM_SSL_HANDLER).set((Object)sslHandler);
            ctx.pipeline().replace((ChannelHandler)this, "SslHandler#0", (ChannelHandler)sslHandler);
            sslHandler = null;
        }
        finally {
            if (sslHandler != null) {
                ReferenceCountUtil.safeRelease((Object)sslHandler.engine());
            }
        }
    }

    public static Certificate[] retrieveClientCertificates(MockServerLogger mockServerLogger, ChannelHandlerContext ctx) {
        Certificate[] clientCertificates;
        block5: {
            SSLSession sslSession;
            SSLEngine sslEngine;
            clientCertificates = null;
            if (ctx.channel().attr(UPSTREAM_CLIENT_CERTIFICATES).get() != null) {
                clientCertificates = (Certificate[])ctx.channel().attr(UPSTREAM_CLIENT_CERTIFICATES).get();
            } else if (ctx.channel().attr(UPSTREAM_SSL_ENGINE).get() != null && (sslEngine = (SSLEngine)ctx.channel().attr(UPSTREAM_SSL_ENGINE).get()) != null && (sslSession = sslEngine.getSession()) != null) {
                try {
                    Certificate[] peerCertificates = sslSession.getPeerCertificates();
                    ctx.channel().attr(UPSTREAM_CLIENT_CERTIFICATES).set((Object)peerCertificates);
                    return peerCertificates;
                }
                catch (SSLPeerUnverifiedException ignore) {
                    if (!MockServerLogger.isEnabled(Level.TRACE) || mockServerLogger == null) break block5;
                    mockServerLogger.logEvent(new LogEntry().setLogLevel(Level.TRACE).setMessageFormat("no client certificate chain as client did not complete mTLS"));
                }
            }
        }
        return clientCertificates;
    }

    public static Protocol getALPNProtocol(MockServerLogger mockServerLogger, ChannelHandlerContext ctx) {
        Protocol protocol;
        block9: {
            protocol = null;
            try {
                if (ctx != null && ctx.channel() != null) {
                    SslHandler sslHandler;
                    String negotiatedApplicationProtocol;
                    if (ctx.channel().attr(NEGOTIATED_APPLICATION_PROTOCOL).get() != null) {
                        return (Protocol)((Object)ctx.channel().attr(NEGOTIATED_APPLICATION_PROTOCOL).get());
                    }
                    if (ctx.channel().attr(UPSTREAM_SSL_HANDLER).get() != null && StringUtils.isNotBlank((CharSequence)(negotiatedApplicationProtocol = (sslHandler = (SslHandler)ctx.channel().attr(UPSTREAM_SSL_HANDLER).get()).applicationProtocol()))) {
                        if (negotiatedApplicationProtocol.equalsIgnoreCase("h2")) {
                            protocol = Protocol.HTTP_2;
                        } else if (negotiatedApplicationProtocol.equalsIgnoreCase("http/1.1")) {
                            protocol = Protocol.HTTP_1_1;
                        }
                        ctx.channel().attr(NEGOTIATED_APPLICATION_PROTOCOL).set((Object)protocol);
                        if (MockServerLogger.isEnabled(Level.TRACE) && mockServerLogger != null) {
                            mockServerLogger.logEvent(new LogEntry().setLogLevel(Level.TRACE).setMessageFormat("found ALPN protocol:{}").setArguments(negotiatedApplicationProtocol));
                        }
                    }
                }
            }
            catch (Throwable throwable) {
                if (!MockServerLogger.isEnabled(Level.WARN) || mockServerLogger == null) break block9;
                mockServerLogger.logEvent(new LogEntry().setLogLevel(Level.WARN).setMessageFormat("exception reading ALPN protocol").setThrowable(throwable));
            }
        }
        return protocol;
    }
}

