/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.socket.tls.bouncycastle;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.math.BigInteger;
import java.security.Key;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Security;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Random;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.BasicConstraints;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.asn1.x509.KeyPurposeId;
import org.bouncycastle.asn1.x509.KeyUsage;
import org.bouncycastle.asn1.x509.SubjectKeyIdentifier;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.X509v3CertificateBuilder;
import org.bouncycastle.cert.bc.BcX509ExtensionUtils;
import org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import org.bouncycastle.cert.jcajce.JcaX509v3CertificateBuilder;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.openssl.jcajce.JcaPEMWriter;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;
import org.bouncycastle.util.IPAddress;
import org.mockserver.configuration.Configuration;
import org.mockserver.file.FileCreator;
import org.mockserver.file.FilePath;
import org.mockserver.file.FileReader;
import org.mockserver.keys.AsymmetricKeyGenerator;
import org.mockserver.keys.AsymmetricKeyPairAlgorithm;
import org.mockserver.log.model.LogEntry;
import org.mockserver.logging.MockServerLogger;
import org.mockserver.socket.tls.KeyAndCertificateFactory;
import org.mockserver.socket.tls.PEMToFile;
import org.slf4j.event.Level;

public class BCKeyAndCertificateFactory
implements KeyAndCertificateFactory {
    private static final String PROVIDER_NAME = "BC";
    private final Configuration configuration;
    private final MockServerLogger mockServerLogger;
    private PrivateKey privateKey;
    private X509Certificate x509Certificate;
    private PrivateKey certificateAuthorityPrivateKey;
    private X509Certificate certificateAuthorityX509Certificate;

    public BCKeyAndCertificateFactory(Configuration configuration, MockServerLogger mockServerLogger) {
        this.configuration = configuration;
        this.mockServerLogger = mockServerLogger;
    }

    @Override
    public void buildAndSaveCertificateAuthorityPrivateKeyAndX509Certificate() {
        if (this.dynamicallyUpdateCertificateAuthority() && this.certificateAuthorityCertificateNotYetCreated()) {
            try {
                AsymmetricKeyPairAlgorithm keyGenerationAndSigningAlgorithm = KeyAndCertificateFactory.DEFAULT_KEY_GENERATION_AND_SIGNING_ALGORITHM;
                KeyPair caKeyPair = AsymmetricKeyGenerator.createKeyPair(keyGenerationAndSigningAlgorithm);
                this.saveAsPEMFile(this.generateCACert(keyGenerationAndSigningAlgorithm, caKeyPair.getPublic(), caKeyPair.getPrivate()), this.certificateAuthorityX509CertificatePath(), "Certificate Authority X509 Certificate PEM");
                this.saveAsPEMFile(caKeyPair.getPrivate(), this.certificateAuthorityPrivateKeyPath(), "Certificate Authority Private Key PEM");
            }
            catch (Exception e) {
                this.mockServerLogger.logEvent(new LogEntry().setLogLevel(Level.ERROR).setMessageFormat("exception while generating certificate authority private key and X509 certificate").setThrowable(e));
            }
        }
    }

    private String certificateAuthorityPrivateKeyPath() {
        if (this.dynamicallyUpdateCertificateAuthority()) {
            return new File(new File(this.configuration.directoryToSaveDynamicSSLCertificate()), "PKCS8CertificateAuthorityPrivateKey.pem").getAbsolutePath();
        }
        return this.configuration.certificateAuthorityPrivateKey();
    }

    private PrivateKey certificateAuthorityPrivateKey() {
        if (this.certificateAuthorityPrivateKey == null) {
            if (this.dynamicallyUpdateCertificateAuthority()) {
                this.buildAndSaveCertificateAuthorityPrivateKeyAndX509Certificate();
            }
            this.certificateAuthorityPrivateKey = PEMToFile.privateKeyFromPEMFile(this.certificateAuthorityPrivateKeyPath());
            if (MockServerLogger.isEnabled(Level.TRACE) && this.mockServerLogger != null) {
                this.mockServerLogger.logEvent(new LogEntry().setLogLevel(Level.TRACE).setMessageFormat("loaded CA private key from path{}containing PEM{}").setArguments(FilePath.absolutePathFromClassPathOrPath(this.certificateAuthorityPrivateKeyPath()), this.certificateAuthorityPrivateKey));
            } else if (MockServerLogger.isEnabled(Level.INFO) && this.mockServerLogger != null) {
                this.mockServerLogger.logEvent(new LogEntry().setLogLevel(Level.INFO).setMessageFormat("loaded CA private key from path{}").setArguments(FilePath.absolutePathFromClassPathOrPath(this.certificateAuthorityPrivateKeyPath())));
            }
        }
        return this.certificateAuthorityPrivateKey;
    }

    private String certificateAuthorityX509CertificatePath() {
        if (this.dynamicallyUpdateCertificateAuthority()) {
            return new File(new File(this.configuration.directoryToSaveDynamicSSLCertificate()), "CertificateAuthorityCertificate.pem").getAbsolutePath();
        }
        return this.configuration.certificateAuthorityCertificate();
    }

    @Override
    public X509Certificate certificateAuthorityX509Certificate() {
        if (this.certificateAuthorityX509Certificate == null) {
            if (this.dynamicallyUpdateCertificateAuthority()) {
                this.buildAndSaveCertificateAuthorityPrivateKeyAndX509Certificate();
            }
            this.certificateAuthorityX509Certificate = PEMToFile.x509FromPEMFile(this.certificateAuthorityX509CertificatePath());
            if (MockServerLogger.isEnabled(Level.DEBUG) && this.mockServerLogger != null) {
                this.mockServerLogger.logEvent(new LogEntry().setLogLevel(Level.DEBUG).setMessageFormat("loaded CA X509 from path{}containing PEM{}as{}").setArguments(FilePath.absolutePathFromClassPathOrPath(this.certificateAuthorityX509CertificatePath()), FileReader.readFileFromClassPathOrPath(this.certificateAuthorityX509CertificatePath()), this.certificateAuthorityX509Certificate));
            } else if (MockServerLogger.isEnabled(Level.INFO) && this.mockServerLogger != null) {
                this.mockServerLogger.logEvent(new LogEntry().setLogLevel(Level.INFO).setMessageFormat("loaded CA X509 from path{}containing PEM{}").setArguments(FilePath.absolutePathFromClassPathOrPath(this.certificateAuthorityX509CertificatePath()), FileReader.readFileFromClassPathOrPath(this.certificateAuthorityX509CertificatePath())));
            }
        }
        return this.certificateAuthorityX509Certificate;
    }

    private X509Certificate generateCACert(AsymmetricKeyPairAlgorithm keyGenerationAndSigningAlgorithm, PublicKey publicKey, PrivateKey privateKey) throws Exception {
        X500Name issuerName = new X500Name("CN=www.mockserver.com, O=MockServer, L=London, ST=England, C=UK");
        BigInteger serial = BigInteger.valueOf(new Random().nextInt(Integer.MAX_VALUE));
        JcaX509v3CertificateBuilder builder = new JcaX509v3CertificateBuilder(issuerName, serial, NOT_BEFORE, NOT_AFTER, issuerName, publicKey);
        builder.addExtension(Extension.subjectKeyIdentifier, false, (ASN1Encodable)this.createSubjectKeyIdentifier(publicKey));
        builder.addExtension(Extension.basicConstraints, true, (ASN1Encodable)new BasicConstraints(true));
        KeyUsage usage = new KeyUsage(182);
        builder.addExtension(Extension.keyUsage, false, (ASN1Encodable)usage);
        ASN1EncodableVector purposes = new ASN1EncodableVector();
        purposes.add((ASN1Encodable)KeyPurposeId.id_kp_serverAuth);
        purposes.add((ASN1Encodable)KeyPurposeId.id_kp_clientAuth);
        purposes.add((ASN1Encodable)KeyPurposeId.anyExtendedKeyUsage);
        builder.addExtension(Extension.extendedKeyUsage, false, (ASN1Encodable)new DERSequence(purposes));
        X509Certificate cert = this.signCertificate(keyGenerationAndSigningAlgorithm, (X509v3CertificateBuilder)builder, privateKey);
        cert.checkValidity(new Date());
        cert.verify(publicKey);
        return cert;
    }

    @Override
    public void buildAndSavePrivateKeyAndX509Certificate() {
        if (this.customPrivateKeyAndCertificateProvided()) {
            try {
                if (this.dynamicallyUpdateCertificateAuthority()) {
                    this.buildAndSaveCertificateAuthorityPrivateKeyAndX509Certificate();
                }
                AsymmetricKeyPairAlgorithm keyGenerationAndSigningAlgorithm = KeyAndCertificateFactory.DEFAULT_KEY_GENERATION_AND_SIGNING_ALGORITHM;
                KeyPair keyPair = AsymmetricKeyGenerator.createKeyPair(keyGenerationAndSigningAlgorithm);
                this.privateKey = keyPair.getPrivate();
                this.x509Certificate = this.generateLeafCert(keyGenerationAndSigningAlgorithm, keyPair.getPublic(), this.certificateAuthorityX509Certificate(), this.certificateAuthorityPrivateKey(), this.certificateAuthorityX509Certificate().getPublicKey(), this.configuration.sslCertificateDomainName(), this.configuration.sslSubjectAlternativeNameDomains(), this.configuration.sslSubjectAlternativeNameIps());
                if (MockServerLogger.isEnabled(Level.TRACE) && this.mockServerLogger != null) {
                    this.mockServerLogger.logEvent(new LogEntry().setLogLevel(Level.TRACE).setMessageFormat("created new X509{}with SAN Domain Names{}and IPs{}").setArguments(this.x509Certificate(), this.configuration.sslSubjectAlternativeNameDomains(), this.configuration.sslSubjectAlternativeNameIps()));
                }
                if (this.configuration.preventCertificateDynamicUpdate().booleanValue()) {
                    this.saveAsPEMFile(this.x509Certificate, this.x509CertificatePath(), "X509 Certificate PEM");
                    this.saveAsPEMFile(this.privateKey, this.privateKeyPath(), "Private Key PEM");
                }
            }
            catch (Exception e) {
                this.mockServerLogger.logEvent(new LogEntry().setLogLevel(Level.ERROR).setMessageFormat("exception while generating private key and X509 certificate").setThrowable(e));
            }
        }
    }

    private String privateKeyPath() {
        return new File(new File(this.configuration.directoryToSaveDynamicSSLCertificate()), "PKCS8PrivateKey.pem").getAbsolutePath();
    }

    @Override
    public PrivateKey privateKey() {
        if (this.customPrivateKeyAndCertificateProvided()) {
            return this.privateKey;
        }
        return PEMToFile.privateKeyFromPEMFile(this.configuration.privateKeyPath());
    }

    private String x509CertificatePath() {
        return new File(new File(this.configuration.directoryToSaveDynamicSSLCertificate()), "Certificate.pem").getAbsolutePath();
    }

    @Override
    public X509Certificate x509Certificate() {
        if (this.customPrivateKeyAndCertificateProvided()) {
            return this.x509Certificate;
        }
        return PEMToFile.x509FromPEMFile(this.configuration.x509CertificatePath());
    }

    private X509Certificate generateLeafCert(AsymmetricKeyPairAlgorithm keyGenerationAndSigningAlgorithm, PublicKey publicKey, X509Certificate certificateAuthorityCert, PrivateKey certificateAuthorityPrivateKey, PublicKey certificateAuthorityPublicKey, String domain, Set<String> subjectAlternativeNameDomains, Set<String> subjectAlternativeNameIps) throws Exception {
        X500Name issuer = new X509CertificateHolder(certificateAuthorityCert.getEncoded()).getSubject();
        X500Name subject = new X500Name("CN=" + domain + ", O=" + "MockServer" + ", L=" + "London" + ", ST=" + "England" + ", C=" + "UK");
        BigInteger serial = BigInteger.valueOf(new Random().nextInt(Integer.MAX_VALUE));
        JcaX509v3CertificateBuilder builder = new JcaX509v3CertificateBuilder(issuer, serial, NOT_BEFORE, NOT_AFTER, subject, publicKey);
        builder.addExtension(Extension.subjectKeyIdentifier, false, (ASN1Encodable)this.createSubjectKeyIdentifier(publicKey));
        builder.addExtension(Extension.basicConstraints, false, (ASN1Encodable)new BasicConstraints(false));
        ArrayList<GeneralName> subjectAlternativeNames = new ArrayList<GeneralName>();
        if (subjectAlternativeNameDomains != null) {
            subjectAlternativeNames.add(new GeneralName(2, domain));
            for (String subjectAlternativeNameDomain : subjectAlternativeNameDomains) {
                subjectAlternativeNames.add(new GeneralName(2, subjectAlternativeNameDomain));
            }
        }
        if (subjectAlternativeNameIps != null) {
            for (String subjectAlternativeNameIp : subjectAlternativeNameIps) {
                if (!IPAddress.isValidIPv6WithNetmask((String)subjectAlternativeNameIp) && !IPAddress.isValidIPv6((String)subjectAlternativeNameIp) && !IPAddress.isValidIPv4WithNetmask((String)subjectAlternativeNameIp) && !IPAddress.isValidIPv4((String)subjectAlternativeNameIp)) continue;
                subjectAlternativeNames.add(new GeneralName(7, subjectAlternativeNameIp));
            }
        }
        if (subjectAlternativeNames.size() > 0) {
            DERSequence subjectAlternativeNamesExtension = new DERSequence(subjectAlternativeNames.toArray(new ASN1Encodable[0]));
            builder.addExtension(Extension.subjectAlternativeName, false, (ASN1Encodable)subjectAlternativeNamesExtension);
        }
        X509Certificate signedX509Certificate = this.signCertificate(keyGenerationAndSigningAlgorithm, (X509v3CertificateBuilder)builder, certificateAuthorityPrivateKey);
        signedX509Certificate.checkValidity(new Date());
        signedX509Certificate.verify(certificateAuthorityPublicKey);
        return signedX509Certificate;
    }

    private X509Certificate signCertificate(AsymmetricKeyPairAlgorithm keyGenerationAndSigningAlgorithm, X509v3CertificateBuilder certificateBuilder, PrivateKey privateKey) throws OperatorCreationException, CertificateException {
        ContentSigner signer = new JcaContentSignerBuilder(keyGenerationAndSigningAlgorithm.getSigningAlgorithm()).setProvider(PROVIDER_NAME).build(privateKey);
        return new JcaX509CertificateConverter().setProvider(PROVIDER_NAME).getCertificate(certificateBuilder.build(signer));
    }

    private SubjectKeyIdentifier createSubjectKeyIdentifier(Key key) throws IOException {
        try (ASN1InputStream is = new ASN1InputStream((InputStream)new ByteArrayInputStream(key.getEncoded()));){
            ASN1Sequence seq = (ASN1Sequence)is.readObject();
            SubjectPublicKeyInfo info = SubjectPublicKeyInfo.getInstance((Object)seq);
            SubjectKeyIdentifier subjectKeyIdentifier = new BcX509ExtensionUtils().createSubjectKeyIdentifier(info);
            return subjectKeyIdentifier;
        }
    }

    @Override
    public boolean certificateNotYetCreated() {
        return this.customPrivateKeyAndCertificateProvided() && this.x509Certificate == null;
    }

    private boolean customPrivateKeyAndCertificateProvided() {
        return StringUtils.isBlank((CharSequence)this.configuration.privateKeyPath()) || StringUtils.isBlank((CharSequence)this.configuration.x509CertificatePath());
    }

    private boolean dynamicallyUpdateCertificateAuthority() {
        return this.configuration.dynamicallyCreateCertificateAuthorityCertificate();
    }

    public boolean certificateAuthorityCertificateNotYetCreated() {
        return !PEMToFile.validX509PEMFileExists(this.certificateAuthorityX509CertificatePath());
    }

    private void saveAsPEMFile(Object object, String absolutePath, String type) throws IOException {
        if (MockServerLogger.isEnabled(Level.INFO) && this.mockServerLogger != null) {
            this.mockServerLogger.logEvent(new LogEntry().setLogLevel(Level.INFO).setMessageFormat("created dynamic " + type + " file at{}").setArguments(absolutePath));
        }
        try (FileWriter pemfileWriter = new FileWriter(FileCreator.createFileIfNotExists(type, new File(absolutePath)));
             JcaPEMWriter jcaPEMWriter = new JcaPEMWriter((Writer)pemfileWriter);){
            jcaPEMWriter.writeObject(object);
        }
    }

    @Override
    public List<X509Certificate> certificateChain() {
        ArrayList<X509Certificate> result = new ArrayList<X509Certificate>();
        result.add(this.x509Certificate());
        result.add(this.certificateAuthorityX509Certificate());
        return result;
    }

    static {
        Security.addProvider((Provider)new BouncyCastleProvider());
    }
}

