/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.log.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.lmax.disruptor.EventTranslator;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.mockserver.formatting.StringFormatter;
import org.mockserver.log.TimeService;
import org.mockserver.matchers.HttpRequestMatcher;
import org.mockserver.matchers.TimeToLive;
import org.mockserver.matchers.Times;
import org.mockserver.mock.Expectation;
import org.mockserver.model.HttpError;
import org.mockserver.model.HttpRequest;
import org.mockserver.model.HttpResponse;
import org.mockserver.model.ObjectWithJsonToString;
import org.slf4j.event.Level;

public class LogEntry
extends ObjectWithJsonToString
implements EventTranslator<LogEntry> {
    private static final String[] EXCLUDED_FIELDS = new String[]{"key", "timestamp", "message", "throwable"};
    private Level logLevel = Level.INFO;
    public static final DateFormat LOG_DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private long epochTime = TimeService.currentTimeMillis();
    private String timestamp;
    private LogMessageType type;
    private HttpRequest[] httpRequests;
    private HttpResponse httpResponse;
    private HttpError httpError;
    private Expectation expectation;
    private Throwable throwable;
    private Runnable consumer;
    private String messageFormat;
    private Object[] arguments;
    private String message;

    public void clear() {
        this.logLevel = Level.INFO;
        this.epochTime = -1L;
        this.httpRequests = new HttpRequest[]{HttpRequest.request()};
        this.timestamp = null;
        this.httpResponse = null;
        this.httpError = null;
        this.expectation = null;
        this.throwable = null;
        this.consumer = null;
        this.messageFormat = null;
        this.arguments = null;
        this.message = null;
    }

    public Level getLogLevel() {
        return this.logLevel;
    }

    public LogEntry setLogLevel(Level logLevel) {
        this.logLevel = logLevel;
        return this;
    }

    public long getEpochTime() {
        return this.epochTime;
    }

    public LogEntry setEpochTime(long epochTime) {
        this.epochTime = epochTime;
        this.timestamp = null;
        return this;
    }

    public String getTimestamp() {
        if (this.timestamp == null) {
            this.timestamp = LOG_DATE_FORMAT.format(new Date(this.epochTime));
        }
        return this.timestamp;
    }

    public LogMessageType getType() {
        return this.type;
    }

    public LogEntry setType(LogMessageType type) {
        this.type = type;
        return this;
    }

    @JsonIgnore
    public HttpRequest[] getHttpRequests() {
        if (this.httpRequests == null) {
            return new HttpRequest[0];
        }
        return this.httpRequests;
    }

    @JsonIgnore
    public List<HttpRequest> getHttpRequests(HttpRequestMatcher matcher) {
        ArrayList<HttpRequest> matchingRequests = new ArrayList<HttpRequest>();
        if (this.httpRequests != null) {
            for (HttpRequest httpRequest : this.httpRequests) {
                if (matcher != null && !matcher.matches(httpRequest)) continue;
                matchingRequests.add(httpRequest);
            }
        }
        return matchingRequests;
    }

    @JsonIgnore
    public boolean matches(HttpRequestMatcher matcher) {
        if (matcher == null) {
            return true;
        }
        if (this.httpRequests != null) {
            for (HttpRequest httpRequest : this.httpRequests) {
                if (!matcher.matches(httpRequest)) continue;
                return true;
            }
        }
        return false;
    }

    public LogEntry setHttpRequests(HttpRequest[] httpRequests) {
        this.httpRequests = httpRequests;
        return this;
    }

    public LogEntry setHttpRequest(HttpRequest httpRequest) {
        this.httpRequests = httpRequest != null ? new HttpRequest[]{httpRequest} : new HttpRequest[]{HttpRequest.request()};
        return this;
    }

    public HttpRequest getHttpRequest() {
        if (this.httpRequests != null && this.httpRequests.length > 0) {
            return this.httpRequests[0];
        }
        return null;
    }

    public HttpResponse getHttpResponse() {
        return this.httpResponse;
    }

    public LogEntry setHttpResponse(HttpResponse httpResponse) {
        this.httpResponse = httpResponse;
        return this;
    }

    public HttpError getHttpError() {
        return this.httpError;
    }

    public LogEntry setHttpError(HttpError httpError) {
        this.httpError = httpError;
        return this;
    }

    public Expectation getExpectation() {
        if (this.getType() == LogMessageType.FORWARDED_REQUEST && this.expectation == null) {
            this.expectation = new Expectation(this.getHttpRequest(), Times.once(), TimeToLive.unlimited()).thenRespond(this.httpResponse);
        }
        return this.expectation;
    }

    public LogEntry setExpectation(Expectation expectation) {
        this.expectation = expectation;
        return this;
    }

    public Throwable getThrowable() {
        return this.throwable;
    }

    public LogEntry setThrowable(Throwable throwable) {
        this.throwable = throwable;
        return this;
    }

    public Runnable getConsumer() {
        return this.consumer;
    }

    public LogEntry setConsumer(Runnable consumer) {
        this.consumer = consumer;
        return this;
    }

    public String getMessageFormat() {
        return this.messageFormat;
    }

    public LogEntry setMessageFormat(String messageFormat) {
        this.messageFormat = messageFormat;
        return this;
    }

    public Object[] getArguments() {
        return this.arguments;
    }

    public LogEntry setArguments(Object ... arguments) {
        this.arguments = arguments;
        return this;
    }

    @JsonIgnore
    public String getMessage() {
        if (this.message == null) {
            this.message = this.arguments != null ? StringFormatter.formatLogMessage(this.messageFormat, this.arguments) : this.messageFormat;
        }
        return this.message;
    }

    public LogEntry clone() {
        return new LogEntry().setLogLevel(this.getLogLevel()).setEpochTime(this.getEpochTime()).setType(this.getType()).setHttpRequests(this.getHttpRequests()).setHttpResponse(this.getHttpResponse()).setHttpError(this.getHttpError()).setExpectation(this.getExpectation()).setMessageFormat(this.getMessageFormat()).setArguments(this.getArguments()).setThrowable(this.getThrowable()).setConsumer(this.getConsumer());
    }

    public void translateTo(LogEntry event, long sequence) {
        event.setLogLevel(this.getLogLevel()).setEpochTime(this.getEpochTime()).setType(this.getType()).setHttpRequests(this.getHttpRequests()).setHttpResponse(this.getHttpResponse()).setHttpError(this.getHttpError()).setExpectation(this.getExpectation()).setMessageFormat(this.getMessageFormat()).setArguments(this.getArguments()).setThrowable(this.getThrowable()).setConsumer(this.getConsumer());
        this.clear();
    }

    @Override
    protected String[] fieldsExcludedFromEqualsAndHashCode() {
        return EXCLUDED_FIELDS;
    }

    public static enum LogMessageType {
        RUNNABLE,
        TRACE,
        DEBUG,
        INFO,
        WARN,
        EXCEPTION,
        CLEARED,
        RETRIEVED,
        CREATED_EXPECTATION,
        RECEIVED_REQUEST,
        EXPECTATION_RESPONSE,
        EXPECTATION_NOT_MATCHED_RESPONSE,
        EXPECTATION_MATCHED,
        EXPECTATION_NOT_MATCHED,
        VERIFICATION,
        VERIFICATION_FAILED,
        FORWARDED_REQUEST,
        TEMPLATE_GENERATED,
        SERVER_CONFIGURATION;

    }
}

